/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.sharding;

import com.google.gson.JsonObject;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.geojson.GeoJsonType;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.converters.StringToShardConverter;
import org.openstreetmap.atlas.utilities.collections.StringList;

public class CountryShard
implements Shard {
    private static final long serialVersionUID = -4158215940506552768L;
    private final Shard shard;
    private final String country;

    public static CountryShard forName(String name) {
        StringList split = StringList.split(name, "_", 2);
        return new CountryShard(split.get(0), new StringToShardConverter().convert(split.get(1)));
    }

    public CountryShard(String country, Shard shard) {
        if (shard == null || country == null) {
            throw new CoreException("Cannot have null parameters: Country = {} and Shard = {}", country, shard);
        }
        this.shard = shard;
        this.country = country;
    }

    public CountryShard(String country, String shardString) {
        if (shardString == null || country == null) {
            throw new CoreException("Cannot have null parameters: Country = {} and Shard = {}", country, shardString);
        }
        this.country = country;
        this.shard = new StringToShardConverter().convert(shardString);
    }

    @Override
    public JsonObject asGeoJson() {
        return this.shard.asGeoJson();
    }

    @Override
    public Rectangle bounds() {
        return this.shard.bounds();
    }

    public boolean equals(Object other) {
        if (other instanceof CountryShard) {
            CountryShard that = (CountryShard)other;
            return this.getCountry().equals(that.getCountry()) && this.getShard().equals(that.getShard());
        }
        return false;
    }

    public String getCountry() {
        return this.country;
    }

    @Override
    public GeoJsonType getGeoJsonType() {
        return this.shard.getGeoJsonType();
    }

    @Override
    public String getName() {
        return this.country + "_" + this.shard.getName();
    }

    public Shard getShard() {
        return this.shard;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.shard).append(this.country).hashCode();
    }

    public String toString() {
        return "[CountryShard: country = " + this.country + ", shard = " + this.shard.toString() + "]";
    }

    @Override
    public byte[] toWkb() {
        return this.shard.toWkb();
    }

    @Override
    public String toWkt() {
        return this.shard.toWkt();
    }
}

