/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.matching;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Segment;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public final class PolyLineRoute
implements Comparable<PolyLineRoute> {
    private final List<Segment> candidateSegments;
    private final Distance cost;
    private final PolyLine source;
    private final List<PolyLine> candidates;
    private PolyLine polyLine;

    protected static PolyLineRoute startFrom(PolyLine source, List<PolyLine> candidates, int polyLineIndex, int segmentIndex) {
        ArrayList<Segment> candidateSegments = new ArrayList<Segment>();
        candidateSegments.add(PolyLineRoute.candidateSegment(candidates, polyLineIndex, segmentIndex));
        return new PolyLineRoute(source, candidates, candidateSegments);
    }

    private static Segment candidateSegment(List<PolyLine> candidates, int polyLineIndex, int segmentIndex) {
        return new Segment(candidates.get(polyLineIndex).get(segmentIndex), segmentIndex < candidates.get(polyLineIndex).size() - 1 ? candidates.get(polyLineIndex).get(segmentIndex + 1) : candidates.get(polyLineIndex).first());
    }

    private PolyLineRoute(PolyLine source, List<PolyLine> candidates, List<Segment> candidateSegments) {
        this.candidateSegments = candidateSegments;
        this.source = source;
        this.candidates = candidates;
        this.cost = this.source.averageOneWayDistanceTo(this.asPolyLine()).add(this.asPolyLine().size() > 2 ? new PolyLine(this.asPolyLine().innerLocations()).averageOneWayDistanceTo(this.source) : Distance.ZERO);
    }

    public PolyLine asPolyLine() {
        if (this.polyLine == null) {
            ArrayList<Location> locations = new ArrayList<Location>();
            this.candidateSegments.forEach(segment -> locations.add(segment.first()));
            if (this.source instanceof Polygon) {
                return new Polygon((List<Location>)locations);
            }
            locations.add(this.candidateSegments.get(this.candidateSegments.size() - 1).last());
            return new PolyLine((List<? extends Location>)locations);
        }
        return this.polyLine;
    }

    @Override
    public int compareTo(PolyLineRoute other) {
        return this.cost.isGreaterThan(other.getCost()) ? 1 : (this.cost.isLessThan(other.getCost()) ? -1 : 0);
    }

    public boolean equals(Object other) {
        if (other instanceof PolyLineRoute) {
            return ((PolyLineRoute)other).asPolyLine().equals(this.asPolyLine());
        }
        return false;
    }

    public Distance getCost() {
        return this.cost;
    }

    public int hashCode() {
        return this.asPolyLine().hashCode();
    }

    public String toString() {
        return "[PolyLineRoute: " + this.asPolyLine() + "]";
    }

    protected Optional<Location> canAppend(int polyLineIndex, int segmentIndex) {
        Location end = this.candidateSegments.get(this.candidateSegments.size() - 1).last();
        Location proposed = this.candidates.get(polyLineIndex).get(segmentIndex);
        Segment candidateSegment = PolyLineRoute.candidateSegment(this.candidates, polyLineIndex, segmentIndex);
        boolean matchingLocations = end.equals(proposed);
        boolean candidateSegmentAlreadyContained = this.candidateSegments.contains(candidateSegment);
        if (matchingLocations && !candidateSegmentAlreadyContained) {
            return Optional.of(proposed);
        }
        return Optional.empty();
    }

    protected PolyLineRoute copyAndAppend(int polyLineIndex, int segmentIndex) {
        if (this.canAppend(polyLineIndex, segmentIndex).isPresent()) {
            ArrayList<Segment> polyLineIndexAndSegmentIndex = new ArrayList<Segment>(this.candidateSegments);
            polyLineIndexAndSegmentIndex.add(PolyLineRoute.candidateSegment(this.candidates, polyLineIndex, segmentIndex));
            return new PolyLineRoute(this.source, this.candidates, polyLineIndexAndSegmentIndex);
        }
        throw new CoreException("Unable to append {} and {}", this.asPolyLine(), this.getSegment(polyLineIndex, segmentIndex));
    }

    private Segment getSegment(int polyLineIndex, int segmentIndex) {
        return this.candidates.get(polyLineIndex).segments().get(segmentIndex);
    }
}

