/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.geojson.parser.mapper.impl;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.lang3.Validate;
import org.openstreetmap.atlas.geography.geojson.parser.mapper.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DefaultBeanUtilsBasedMapperImpl implements Mapper
{
    instance;

    private static final Logger log;
    private static final Set<Class<?>> scalarTypes;

    @Override
    public <T> T map(Map<String, Object> map, Class<T> targetClass) {
        T bean = this.create(targetClass);
        this.populate(map, bean);
        return bean;
    }

    private <T> void copyProperty(BeanUtilsBean beanUtilsBean, T bean, String name, Object value) {
        try {
            beanUtilsBean.copyProperty(bean, name, value);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to copy " + value + " in " + bean.getClass() + "#" + name + ".", e);
        }
    }

    private <T> T create(Class<T> targetClass) {
        Validate.notNull(targetClass, "null class cannot be instantiated.", new Object[0]);
        try {
            return targetClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to construct instance of class: " + targetClass + "; isArray: " + targetClass.isArray(), e);
        }
    }

    private <C> boolean isScalarType(Class<C> clazz) {
        return scalarTypes.contains(clazz) || clazz.isPrimitive();
    }

    private <T> void populate(Map<String, Object> map, T bean) {
        try {
            PropertyDescriptor[] propertyDescriptors;
            Validate.notNull(map, "input map is NULL.", new Object[0]);
            Validate.notNull(bean, "bean is NULL", new Object[0]);
            BeanUtilsBean beanUtilsBean = new BeanUtilsBean();
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanUtilsBean.getPropertyUtils().getPropertyDescriptors(bean)) {
                try {
                    String name = propertyDescriptor.getName();
                    Class<?> propertyType = propertyDescriptor.getPropertyType();
                    Object value = map.get(name);
                    if (value == null) continue;
                    if (this.isScalarType(propertyType) || Map.class.isAssignableFrom(propertyType)) {
                        this.copyProperty(beanUtilsBean, bean, name, value);
                        continue;
                    }
                    if (!propertyType.isArray()) {
                        Object child = this.create(propertyType);
                        this.populate((Map)value, child);
                        this.copyProperty(beanUtilsBean, bean, name, child);
                        continue;
                    }
                    List values = (List)value;
                    if (values == null || values.isEmpty() || values.get(0) == null) continue;
                    if (this.isScalarType(values.get(0).getClass())) {
                        this.copyProperty(beanUtilsBean, bean, name, values.toArray());
                        continue;
                    }
                    log.info("values: {}.", (Object)values);
                    Class<?> componentType = propertyType.getComponentType();
                    A[] valuesAsObjects = values.stream().map(item -> {
                        Validate.notNull(item, "item is NULL, do you have a trailing comma in the JSON?", new Object[0]);
                        Object child = this.create(componentType);
                        this.populate((Map)item, child);
                        return child;
                    }).toArray(Propersize -> (Object[])Array.newInstance(componentType, values.size()));
                    this.copyProperty(beanUtilsBean, bean, name, valuesAsObjects);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Population failed. propertyDescriptor name: " + propertyDescriptor.getName() + "; map: " + map + "; bean: " + bean + ".", e);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Population fialed. map: " + map + "; bean: " + bean + ".", e);
        }
    }

    static {
        log = LoggerFactory.getLogger(DefaultBeanUtilsBasedMapperImpl.class);
        scalarTypes = new HashSet<Class>(Arrays.asList(String.class, Integer.class, Long.class, Float.class, Double.class, Short.class, Boolean.class, Byte.class));
    }
}

