/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.geojson.parser.domain.geometry.coordinate;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.openstreetmap.atlas.geography.geojson.parser.domain.geometry.coordinate.Position;

public final class Coordinates<V> {
    private V value;

    public static Coordinates<List<Position>> forLineString(List<List<Double>> data) {
        return Coordinates.forMultiPoint(data);
    }

    public static Coordinates<List<List<Position>>> forMultiLineString(List<List<List<Double>>> data) {
        return new Coordinates<List<List<Position>>>(Coordinates.toListOfPositionList(data));
    }

    public static Coordinates<List<Position>> forMultiPoint(List<List<Double>> data) {
        return new Coordinates<List<Position>>(Coordinates.toPositionList(data));
    }

    public static Coordinates<List<List<Position>>> forMultiPolygon(List<List<List<Double>>> data) {
        return Coordinates.forMultiLineString(data);
    }

    public static Coordinates<Position> forPoint(List<Double> data) {
        return new Coordinates<Position>(Coordinates.toPosition(data));
    }

    public static Coordinates<List<List<Position>>> forPolygon(List<List<List<Double>>> data) {
        return Coordinates.forMultiLineString(data);
    }

    private static List<List<Position>> toListOfPositionList(List<List<List<Double>>> data) {
        Validate.notEmpty(data, "list containing the lists of coordinates is EMPTY.", new Object[0]);
        Validate.isTrue(data.size() >= 1, "multi point coordinates must be at least 1: %s.", data);
        return data.stream().map(listOfCoords -> Coordinates.toPositionList(listOfCoords)).collect(Collectors.toList());
    }

    private static Position toPosition(List<Double> data) {
        Validate.notEmpty(data, "coordinates is EMPTY.", new Object[0]);
        Validate.isTrue(data.size() == 2, "point coordinates is NOT 2: %s.", data);
        return new Position(data.get(0), data.get(1));
    }

    private static List<Position> toPositionList(List<List<Double>> data) {
        Validate.notEmpty(data, "list of coordinates is EMPTY.", new Object[0]);
        Validate.isTrue(data.size() >= 1, "multi point coordinates must be at least 1: %s.", data);
        return data.stream().map(coords -> Coordinates.toPosition(coords)).collect(Collectors.toList());
    }

    private Coordinates(V value) {
        this.value = value;
    }

    public boolean equals(Object that) {
        return EqualsBuilder.reflectionEquals((Object)this, that, new String[0]);
    }

    public V getValue() {
        return this.value;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}

