/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.geojson.parser.domain.geometry;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.geojson.parser.domain.geometry.AbstractGeometryWithCoordinateSupport;
import org.openstreetmap.atlas.geography.geojson.parser.domain.geometry.coordinate.Coordinates;
import org.openstreetmap.atlas.geography.geojson.parser.domain.geometry.coordinate.Position;
import org.openstreetmap.atlas.geography.geojson.parser.domain.geometry.coordinate.Positions;

public class MultiLineString
extends AbstractGeometryWithCoordinateSupport<List<List<Position>>, List<PolyLine>> {
    private Coordinates<List<List<Position>>> coordinates;

    public MultiLineString(Map<String, Object> map) {
        super(map, null);
        this.coordinates = Coordinates.forMultiLineString((List)MultiLineString.extractRawCoordinates(map));
    }

    @Override
    public Coordinates<List<List<Position>>> getCoordinates() {
        return this.coordinates;
    }

    @Override
    public List<PolyLine> toAtlasGeometry() {
        List<List<Location>> listsOfLocations = Positions.toCollectionsOfLocations(this.coordinates.getValue());
        return listsOfLocations.stream().map(PolyLine::new).collect(Collectors.toList());
    }
}

