/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.geojson.parser.domain.base;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.tuple.Pair;
import org.openstreetmap.atlas.geography.geojson.parser.domain.base.GeoJsonItem;
import org.openstreetmap.atlas.geography.geojson.parser.domain.bbox.Bbox;
import org.openstreetmap.atlas.geography.geojson.parser.domain.bbox.Dimensions;
import org.openstreetmap.atlas.geography.geojson.parser.domain.foreign.ForeignFields;
import org.openstreetmap.atlas.geography.geojson.parser.domain.properties.Properties;

public abstract class AbstractGeoJsonItem
implements GeoJsonItem {
    private Bbox bbox;
    private Properties properties;
    private ForeignFields foreignFields;

    public static Object extractBbox(Map<String, Object> map) {
        List list = (List)map.get("bbox");
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        Double[] rawBbox = list.toArray(new Double[list.size()]);
        return rawBbox;
    }

    public static Map<String, Object> extractPropertiesMap(Map<String, Object> map) {
        Map properties = (Map)map.get("properties");
        return properties;
    }

    protected static Map<String, Object> extractForeignFields(Map<String, Object> map, HashSet<String> exclude) {
        return new HashMap<String, Object>(map).entrySet().stream().map(entry -> Pair.of((String)entry.getKey(), entry.getValue())).filter(pair -> !exclude.contains(pair.getKey())).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    private static Bbox toBbox(Map<String, Object> map) {
        Double[] coordinates = (Double[])AbstractGeoJsonItem.extractBbox(map);
        if (coordinates == null) {
            return null;
        }
        return Dimensions.toBbox(coordinates);
    }

    public AbstractGeoJsonItem(Bbox bbox, Properties properties, ForeignFields foreignFields) {
        this.bbox = bbox;
        this.properties = properties;
        this.foreignFields = foreignFields;
    }

    public AbstractGeoJsonItem(Map<String, Object> map, ForeignFields foreignFields) {
        this(AbstractGeoJsonItem.toBbox(map), new Properties(AbstractGeoJsonItem.extractPropertiesMap(map)), foreignFields);
        Validate.notEmpty(map, "input map is empty.", new Object[0]);
    }

    public boolean equals(Object that) {
        return EqualsBuilder.reflectionEquals((Object)this, that, new String[0]);
    }

    @Override
    public Bbox getBbox() {
        return this.bbox;
    }

    @Override
    public ForeignFields getForeignFields() {
        return this.foreignFields;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}

