/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.coordinates;

import java.io.Serializable;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.openstreetmap.atlas.geography.Altitude;
import org.openstreetmap.atlas.geography.Latitude;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Longitude;

public class GeodeticCoordinate
implements Serializable {
    private static final long serialVersionUID = 4614378421580938085L;
    private final Latitude latitude;
    private final Longitude longitude;
    private final Altitude altitude;

    public GeodeticCoordinate(Latitude latitude, Longitude longitude, Altitude altitude) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.altitude = altitude;
    }

    public GeodeticCoordinate(Location location) {
        this.latitude = location.getLatitude();
        this.longitude = location.getLongitude();
        this.altitude = Altitude.MEAN_SEA_LEVEL;
    }

    public boolean equals(Object other) {
        if (other instanceof GeodeticCoordinate) {
            GeodeticCoordinate that = (GeodeticCoordinate)other;
            return this.getLatitude().equals(that.getLatitude()) && this.getLongitude().equals(that.getLongitude()) && this.getAltitude().equals(that.getAltitude());
        }
        return false;
    }

    public Altitude getAltitude() {
        return this.altitude;
    }

    public Latitude getLatitude() {
        return this.latitude;
    }

    public Longitude getLongitude() {
        return this.longitude;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getLatitude()).append(this.getLongitude()).append(this.getAltitude()).hashCode();
    }

    public String toString() {
        return "(" + this.getLatitude() + ", " + this.getLongitude() + ", " + this.getAltitude() + ")";
    }
}

