/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.converters.jts;

import java.util.ArrayList;
import java.util.Collection;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.converters.jts.JtsLocationConverter;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.conversion.TwoWayConverter;

public class JtsCoordinateArrayConverter
implements TwoWayConverter<Iterable<Location>, CoordinateSequence> {
    private static final JtsLocationConverter LOCATION_CONVERTER = new JtsLocationConverter();

    public static CoordinateSequence empty() {
        Coordinate[] emptyCoordinateArray = new Coordinate[]{};
        return new CoordinateArraySequence(emptyCoordinateArray);
    }

    @Override
    public Iterable<Location> backwardConvert(CoordinateSequence coordinateSequence) {
        ArrayList<Location> result = new ArrayList<Location>();
        for (Coordinate coordinate : coordinateSequence.toCoordinateArray()) {
            result.add(LOCATION_CONVERTER.backwardConvert(coordinate));
        }
        return result;
    }

    @Override
    public CoordinateSequence convert(Iterable<Location> locations) {
        int size = locations instanceof Collection ? ((Collection)locations).size() : (int)Iterables.size(locations);
        Coordinate[] result = new Coordinate[size];
        int index = 0;
        for (Location location : locations) {
            result[index++] = LOCATION_CONVERTER.convert(location);
        }
        return new CoordinateArraySequence(result);
    }
}

