/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.converters;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.converters.jts.JtsMultiPolygonToMultiPolygonConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsPolygonConverter;
import org.openstreetmap.atlas.utilities.conversion.TwoWayConverter;

public class WktPolygonConverter
implements TwoWayConverter<Polygon, String> {
    private static final JtsMultiPolygonToMultiPolygonConverter JTS_MULTI_POLYGON_TO_MULTI_POLYGON_CONVERTER = new JtsMultiPolygonToMultiPolygonConverter();

    @Override
    public Polygon backwardConvert(String wkt) {
        WKTReader myReader = new WKTReader();
        try {
            MultiPolygon castResult;
            Geometry result = myReader.read(wkt);
            if (result instanceof org.locationtech.jts.geom.Polygon) {
                return new JtsPolygonConverter().backwardConvert((org.locationtech.jts.geom.Polygon)result);
            }
            if (result instanceof org.locationtech.jts.geom.MultiPolygon && (castResult = JTS_MULTI_POLYGON_TO_MULTI_POLYGON_CONVERTER.convert((org.locationtech.jts.geom.MultiPolygon)result)).outers().size() == 1 && castResult.inners().isEmpty()) {
                return castResult.outers().iterator().next();
            }
            throw new CoreException("Cannot convert wkt which is not a Polygon or single-outer MultiPolygon: {}", wkt);
        }
        catch (ParseException e) {
            throw new CoreException("Cannot parse wkt: {}", wkt, e);
        }
    }

    @Override
    public String convert(Polygon polygon) {
        org.locationtech.jts.geom.Polygon geometry = new JtsPolygonConverter().convert(polygon);
        return new WKTWriter().write(geometry);
    }
}

