/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.converters;

import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.converters.jts.JtsPointConverter;
import org.openstreetmap.atlas.utilities.conversion.TwoWayConverter;

public class WktLocationConverter
implements TwoWayConverter<Location, String> {
    @Override
    public Location backwardConvert(String wkt) {
        Point geometry = null;
        WKTReader myReader = new WKTReader();
        try {
            geometry = (Point)myReader.read(wkt);
        }
        catch (ClassCastException | ParseException e) {
            throw new CoreException("Cannot parse wkt : {}", wkt);
        }
        return new JtsPointConverter().backwardConvert(geometry);
    }

    @Override
    public String convert(Location location) {
        Point geometry = new JtsPointConverter().convert(location);
        String wkt = new WKTWriter().write(geometry);
        return wkt;
    }
}

