/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.converters;

import java.util.ArrayList;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.converters.PolygonStringConverter;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.conversion.TwoWayStringConverter;
import org.openstreetmap.atlas.utilities.maps.MultiMap;

public class MultiPolygonStringConverter
implements TwoWayStringConverter<MultiPolygon> {
    public static final String OUTER_SEPARATOR = "&";
    public static final String OUTER_INNERS_SEPARATOR = "#";
    public static final String INNER_SEPARATOR = "+";
    private static final PolygonStringConverter POLYGON_STRING_CONVERTER = new PolygonStringConverter();

    @Override
    public String backwardConvert(MultiPolygon object) {
        StringList outers = new StringList();
        for (Polygon outer : object.outers()) {
            StringList inners = new StringList();
            for (Polygon inner : object.innersOf(outer)) {
                inners.add(inner.toCompactString());
            }
            outers.add(outer.toCompactString() + OUTER_INNERS_SEPARATOR + inners.join(INNER_SEPARATOR));
        }
        return outers.join(OUTER_SEPARATOR);
    }

    @Override
    public MultiPolygon convert(String object) {
        MultiMap<Polygon, Polygon> result = new MultiMap<Polygon, Polygon>();
        StringList outers = StringList.split(object, OUTER_SEPARATOR);
        for (String outerString : outers) {
            StringList outerInners = StringList.split(outerString, OUTER_INNERS_SEPARATOR);
            Polygon outer = POLYGON_STRING_CONVERTER.convert(outerInners.get(0));
            if (outerInners.size() > 1) {
                StringList inners = StringList.split(outerInners.get(1), INNER_SEPARATOR);
                for (String innerString : inners) {
                    result.add(outer, POLYGON_STRING_CONVERTER.convert(innerString));
                }
                continue;
            }
            result.put(outer, new ArrayList());
        }
        return new MultiPolygon(result);
    }
}

