/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.boundary;

import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.index.strtree.STRtree;
import org.openstreetmap.atlas.geography.boundary.AbstractGridIndexBuilder;

public class FixedGridIndexBuilder
extends AbstractGridIndexBuilder {
    private static final double BOUND_ROUNDING_IN_MICRODEGREES = 0.5;
    private static final double GRANULARITY = 0.1;
    private STRtree index;
    private final List<Polygon> boundaries;
    private final Envelope envelope;

    public FixedGridIndexBuilder(List<Polygon> boundaries, Envelope envelope) {
        this.envelope = envelope;
        this.boundaries = boundaries;
        this.index = null;
    }

    @Override
    public List<Polygon> getBoundaries() {
        return this.boundaries;
    }

    @Override
    public Envelope getEnvelope() {
        return this.envelope;
    }

    @Override
    public STRtree getIndex() {
        if (this.index == null) {
            this.index = new STRtree();
            for (Polygon polygon : this.boundaries) {
                Envelope bound = polygon.getEnvelopeInternal();
                Envelope workingBound = bound.intersection(this.envelope);
                workingBound.expandBy(0.5);
                double incrementValue = 0.1;
                double minX = Math.round(workingBound.getMinX());
                double minY = Math.round(workingBound.getMinY());
                double maxX = Math.round(workingBound.getMaxX());
                double maxY = Math.round(workingBound.getMaxY());
                for (double currentY = minY; currentY < maxY; currentY += 0.1) {
                    for (double currentX = minX; currentX < maxX; currentX += 0.1) {
                        Envelope box = new Envelope(currentX, currentX + 0.1, currentY, currentY + 0.1);
                        Polygon geoBox = FixedGridIndexBuilder.buildGeoBox(currentX, currentX + 0.1, currentY, currentY + 0.1);
                        if (!geoBox.intersects(polygon)) continue;
                        this.index.insert(box, (Object)polygon);
                    }
                }
            }
        }
        return this.index;
    }
}

