/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.boundary;

import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.boundary.CountryShardListing;
import org.openstreetmap.atlas.geography.sharding.CountryShard;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.Sharding;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.writers.SafeBufferedWriter;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountryToShardListing
extends Command {
    private static final Logger logger = LoggerFactory.getLogger(CountryToShardListing.class);
    private static final Command.Switch<CountryBoundaryMap> BOUNDARIES = new Command.Switch("boundaries", "The country boundaries.", value -> {
        Time start = Time.now();
        logger.info("Loading boundaries");
        CountryBoundaryMap result = CountryBoundaryMap.fromPlainText(new File((String)value));
        logger.info("Loaded boundaries in {}", (Object)start.elapsedSince());
        return result;
    }, Command.Optionality.REQUIRED);
    private static final Command.Switch<StringList> COUNTRIES = new Command.Switch("countries", "CSV list of the country iso3 codes", value -> StringList.split(value, ","), Command.Optionality.REQUIRED);
    private static final Command.Switch<Sharding> SHARDING = new Command.Switch("sharding", "File containing the sharding definition (Works with files only)", Sharding::forString, Command.Optionality.REQUIRED);
    private static final Command.Switch<File> OUTPUT = new Command.Switch("output", "The output file", File::new, Command.Optionality.REQUIRED);

    public static void main(String[] args) {
        new CountryToShardListing().run(args);
    }

    @Override
    protected int onRun(CommandMap command) {
        Time overall = Time.now();
        StringList countries = (StringList)command.get(COUNTRIES);
        logger.info("Listing for countries: {}", (Object)countries);
        CountryBoundaryMap boundaries = (CountryBoundaryMap)command.get(BOUNDARIES);
        File output = (File)command.get(OUTPUT);
        Sharding sharding = (Sharding)command.get(SHARDING);
        try (SafeBufferedWriter writer = output.writer();){
            CountryShardListing.countryToShardList(countries, boundaries, sharding).forEach((country, shardSet) -> shardSet.forEach(shard -> writer.writeLine(new CountryShard((String)country, (Shard)shard).getName())));
        }
        catch (Exception e) {
            throw new CoreException("Could not match shards to boundaries", e);
        }
        logger.info("Finished in {}", (Object)overall.elapsedSince());
        return 0;
    }

    @Override
    protected Command.SwitchList switches() {
        return new Command.SwitchList().with(BOUNDARIES, COUNTRIES, SHARDING, OUTPUT);
    }
}

