/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.boundary;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.IntStream;
import org.openstreetmap.atlas.geography.boundary.CountryBoundary;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.boundary.CountryShardListingProcessor;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.Sharding;
import org.openstreetmap.atlas.utilities.maps.MultiMapWithSet;
import org.openstreetmap.atlas.utilities.threads.Pool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CountryShardListing {
    private static final Logger logger = LoggerFactory.getLogger(CountryShardListing.class);

    public static MultiMapWithSet<String, Shard> countryToShardList(Iterable<String> countries, CountryBoundaryMap boundaries, Sharding sharding) {
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        MultiMapWithSet<String, Shard> countryToShardMap = new MultiMapWithSet<String, Shard>();
        countries.forEach(country -> {
            countryToShardMap.put((String)country, new HashSet());
            List<CountryBoundary> countryBoundaries = boundaries.countryBoundary((String)country);
            if (countryBoundaries == null) {
                logger.error("No boundaries found for {}!", country);
                return;
            }
            countryBoundaries.forEach(queue::add);
        });
        int threadCount = Runtime.getRuntime().availableProcessors() - 1;
        logger.info("Generating tasks with {} processors (threads).", (Object)threadCount);
        try (Pool processPool = new Pool(threadCount, "CountryShardListing");){
            IntStream.range(0, threadCount).forEach(index -> processPool.queue(new CountryShardListingProcessor(queue, sharding, boundaries, countryToShardMap)));
        }
        return countryToShardMap;
    }

    private CountryShardListing() {
    }
}

