/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.boundary;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;

public class CountryCodeGenerator
extends Command {
    private static final String SEPARATOR = ",";
    private static final Command.Switch<File> BOUNDARY = new Command.Switch("boundary", "The country boundary file", path -> new File((String)path), Command.Optionality.REQUIRED);
    private static final Command.Switch<Set<String>> COUNTRIES_TO_EXCLUDE = new Command.Switch("countriesToExclude", "The comma separated country name list to exclude", countries -> new HashSet<String>(Arrays.asList(countries.split(SEPARATOR))), Command.Optionality.OPTIONAL);

    public static void main(String[] args) {
        new CountryCodeGenerator().run(args);
    }

    @Override
    protected int onRun(CommandMap command) {
        File boundaryFile = (File)command.get(BOUNDARY);
        CountryBoundaryMap boundaryMap = CountryBoundaryMap.fromShapeFile(boundaryFile);
        StringList allCountries = boundaryMap.countryCodesOverlappingWith(Rectangle.MAXIMUM);
        System.out.println("The number of all countries: " + allCountries.size());
        System.out.println(allCountries.join(SEPARATOR));
        Set countriesToExclude = (Set)command.get(COUNTRIES_TO_EXCLUDE);
        if (countriesToExclude != null) {
            StringList filtered = new StringList();
            for (String country : allCountries) {
                if (countriesToExclude.contains(country)) continue;
                filtered.add(country);
            }
            System.out.println("The number of all filtered countries: " + filtered.size());
            System.out.println(filtered.join(SEPARATOR));
        }
        return 0;
    }

    @Override
    protected Command.SwitchList switches() {
        return new Command.SwitchList().with(BOUNDARY, COUNTRIES_TO_EXCLUDE);
    }
}

