/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.boundary;

import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.boundary.CountryBoundary;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.conversion.StringConverter;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountryBoundaryMapPrinter
extends Command {
    private static final Logger logger = LoggerFactory.getLogger(CountryBoundaryMapPrinter.class);
    private static final Command.Switch<String> COUNTRIES = new Command.Switch<String>("countries", "The countries to extract as geojson (csv list)", StringConverter.IDENTITY, Command.Optionality.OPTIONAL);
    private static final Command.Switch<File> INPUT = new Command.Switch("input", "The input boundaries file", File::new, Command.Optionality.REQUIRED);

    public static void main(String[] args) {
        new CountryBoundaryMapPrinter().run(args);
    }

    @Override
    protected int onRun(CommandMap command) {
        File input = (File)command.get(INPUT);
        String countries = (String)command.get(COUNTRIES);
        this.print(input, countries);
        return 0;
    }

    protected void print(File input) {
        this.print(input, null);
    }

    protected void print(File input, String countries) {
        String inputName = input.getName();
        inputName = inputName.substring(0, inputName.indexOf(46));
        File geojson = input.parent().child(inputName + "-geojson");
        geojson.mkdirs();
        File wkt = input.parent().child(inputName + "-wkt");
        wkt.mkdirs();
        CountryBoundaryMap map = CountryBoundaryMap.fromPlainText(input);
        Set countrySet = countries == null ? map.countryCodesOverlappingWith(Rectangle.MAXIMUM).stream().collect(Collectors.toSet()) : StringList.split(countries, ",").stream().collect(Collectors.toSet());
        for (String country : countrySet) {
            Time start = Time.now();
            List<CountryBoundary> boundaries = map.countryBoundary(country);
            for (int i = 0; i < boundaries.size(); ++i) {
                Object name = country;
                if (i > 0) {
                    name = (String)name + "_" + i;
                }
                MultiPolygon multiPolygon = boundaries.get(i).getBoundary();
                this.save(wkt.child(country + FileSuffix.WKT), multiPolygon.toWkt());
                File countryFile = geojson.child((String)name + FileSuffix.GEO_JSON);
                multiPolygon.asGeoJsonFeatureCollection().save(countryFile);
            }
            logger.info("Saved {} in {}", (Object)country, (Object)start.elapsedSince());
        }
    }

    @Override
    protected Command.SwitchList switches() {
        return new Command.SwitchList().with(INPUT, COUNTRIES);
    }

    private void save(WritableResource output, String string) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output.write(), StandardCharsets.UTF_8));){
            writer.write(string);
        }
        catch (Exception e) {
            throw new CoreException("Could not save file {}", output.getName(), e);
        }
    }
}

