/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.validators;

import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.change.ChangeType;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.items.Relation;

public class FeatureChangeUsefulnessValidator {
    private final FeatureChange featureChange;

    public FeatureChangeUsefulnessValidator(FeatureChange featureChange) {
        this.featureChange = featureChange;
    }

    public void validate() {
        this.validateFeatureChange();
    }

    private void validateFeatureChange() {
        ChangeType changeType = this.featureChange.getChangeType();
        AtlasEntity beforeView = this.featureChange.getBeforeView();
        AtlasEntity afterView = this.featureChange.getAfterView();
        if (changeType == ChangeType.REMOVE) {
            return;
        }
        if (beforeView == null) {
            return;
        }
        if (beforeView.getType() != afterView.getType()) {
            throw new CoreException("beforeView type {} did not match afterView type {} in {}", beforeView, afterView, this.featureChange.toString());
        }
        if (beforeView.getTags() != null && afterView.getTags() != null && !beforeView.getTags().equals(afterView.getTags())) {
            return;
        }
        if (beforeView.relations() != null && afterView.relations() != null && !beforeView.relations().equals(afterView.relations())) {
            return;
        }
        switch (afterView.getType()) {
            case AREA: {
                Area beforeArea = (Area)beforeView;
                Area afterArea = (Area)afterView;
                if (beforeArea.asPolygon() == null || afterArea.asPolygon() == null || beforeArea.asPolygon().equals(afterArea.asPolygon())) break;
                return;
            }
            case EDGE: {
                Edge beforeEdge = (Edge)beforeView;
                Edge afterEdge = (Edge)afterView;
                if (beforeEdge.asPolyLine() != null && afterEdge.asPolyLine() != null && !beforeEdge.asPolyLine().equals(afterEdge.asPolyLine())) {
                    return;
                }
                if (beforeEdge.start() != null && afterEdge.start() != null && !beforeEdge.start().equals(afterEdge.start())) {
                    return;
                }
                if (beforeEdge.end() == null || afterEdge.end() == null || beforeEdge.end().equals(afterEdge.end())) break;
                return;
            }
            case LINE: {
                Line beforeLine = (Line)beforeView;
                Line afterLine = (Line)afterView;
                if (beforeLine.asPolyLine() == null || afterLine.asPolyLine() == null || beforeLine.asPolyLine().equals(afterLine.asPolyLine())) break;
                return;
            }
            case NODE: {
                Node beforeNode = (Node)beforeView;
                Node afterNode = (Node)afterView;
                if (beforeNode.getLocation() != null && afterNode.getLocation() != null && !beforeNode.getLocation().equals(afterNode.getLocation())) {
                    return;
                }
                if (beforeNode.inEdges() != null && afterNode.inEdges() != null && !beforeNode.inEdges().equals(afterNode.inEdges())) {
                    return;
                }
                if (beforeNode.outEdges() == null || afterNode.outEdges() == null || beforeNode.outEdges().equals(afterNode.outEdges())) break;
                return;
            }
            case POINT: {
                Point beforePoint = (Point)beforeView;
                Point afterPoint = (Point)afterView;
                if (beforePoint.getLocation() == null || afterPoint.getLocation() == null || beforePoint.getLocation().equals(afterPoint.getLocation())) break;
                return;
            }
            case RELATION: {
                Relation beforeRelation = (Relation)beforeView;
                Relation afterRelation = (Relation)afterView;
                if (beforeRelation.members() != null && afterRelation.members() != null && !beforeRelation.members().equals(afterRelation.members())) {
                    return;
                }
                if (beforeRelation.allRelationsWithSameOsmIdentifier() != null && afterRelation.allRelationsWithSameOsmIdentifier() != null && !beforeRelation.allRelationsWithSameOsmIdentifier().equals(afterRelation.allRelationsWithSameOsmIdentifier())) {
                    return;
                }
                if (beforeRelation.allKnownOsmMembers() != null && afterRelation.allKnownOsmMembers() != null && !beforeRelation.allKnownOsmMembers().equals(afterRelation.allKnownOsmMembers())) {
                    return;
                }
                if (beforeRelation.osmRelationIdentifier() == null || afterRelation.osmRelationIdentifier() == null || beforeRelation.osmRelationIdentifier().equals(afterRelation.osmRelationIdentifier())) break;
                return;
            }
            default: {
                throw new CoreException("Unknown ItemType {}", new Object[]{afterView.getType()});
            }
        }
        throw new CoreException("FeatureChange is not useful: beforeView perfectly matched afterView: {} vs {}", beforeView, afterView);
    }
}

