/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.validators;

import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasNodeValidator {
    private static final Logger logger = LoggerFactory.getLogger(AtlasNodeValidator.class);
    private final Atlas atlas;

    public AtlasNodeValidator(Atlas atlas) {
        this.atlas = atlas;
    }

    public void validate() {
        logger.trace("Starting Node validation of Atlas {}", (Object)this.atlas.getName());
        Time start = Time.now();
        this.validateNodeToEdgeConnectivity();
        this.validateNodeToEdgeLocationAccuracy();
        logger.trace("Finished Node validation of Atlas {} in {}", (Object)this.atlas.getName(), (Object)start.elapsedSince());
    }

    protected void validateNodeToEdgeConnectivity() {
        for (Node node : this.atlas.nodes()) {
            for (Edge edge : node.inEdges()) {
                if (edge != null) continue;
                throw new CoreException("Node {} is logically disconnected from some referenced in edge.", node.getIdentifier());
            }
            for (Edge edge : node.outEdges()) {
                if (edge != null) continue;
                throw new CoreException("Node {} is logically disconnected from some out edge.", node.getIdentifier());
            }
        }
    }

    protected void validateNodeToEdgeLocationAccuracy() {
        for (Node node : this.atlas.nodes()) {
            Location nodeLocation = node.getLocation();
            for (Edge edge : node.outEdges()) {
                Location edgeStartLocation = edge.asPolyLine().first();
                if (nodeLocation.equals(edgeStartLocation)) continue;
                throw new CoreException("Node {} at location {} references outEdge {} which starts at a different location {}", node.getIdentifier(), nodeLocation, edge.getIdentifier(), edgeStartLocation);
            }
            for (Edge edge : node.inEdges()) {
                Location edgeEndLocation = edge.asPolyLine().last();
                if (nodeLocation.equals(edgeEndLocation)) continue;
                throw new CoreException("Node {} at location {} references inEdge {} which ends at a different location {}", node.getIdentifier(), nodeLocation, edge.getIdentifier(), edgeEndLocation);
            }
        }
    }
}

