/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.validators;

import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.LocationItem;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasLocationItemValidator {
    private static final Logger logger = LoggerFactory.getLogger(AtlasLocationItemValidator.class);
    private final Atlas atlas;

    public AtlasLocationItemValidator(Atlas atlas) {
        this.atlas = atlas;
    }

    public void validate() {
        logger.trace("Starting LocationItem validation of Atlas {}", (Object)this.atlas.getName());
        Time start = Time.now();
        this.validateLocationPresent();
        logger.trace("Finished LocationItem validation of Atlas {} in {}", (Object)this.atlas.getName(), (Object)start.elapsedSince());
    }

    protected void validateLocationPresent() {
        for (LocationItem locationItem : this.atlas.locationItems()) {
            if (locationItem.getLocation() != null) continue;
            throw new CoreException("{} {} is missing a Location.", new Object[]{locationItem.getType(), locationItem.getIdentifier()});
        }
    }
}

