/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.statistics.coverage.linear.line;

import java.util.function.Predicate;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.statistics.coverage.linear.line.LineCoverage;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RiverLineCoverage
extends LineCoverage {
    private static final Logger logger = LoggerFactory.getLogger(RiverLineCoverage.class);
    public static final StringList WATERWAY_MATCHES = new StringList("river", "stream", "wadi", "canal");
    public static final StringList NATURAL_MATCHES = new StringList("water");
    public static final StringList WATER_MATCHES = new StringList("river", "canal");

    public RiverLineCoverage(Atlas atlas) {
        super(logger, atlas);
    }

    public RiverLineCoverage(Atlas atlas, Predicate<Line> filter) {
        super(logger, atlas, filter);
    }

    @Override
    protected boolean isCounted(Line item) {
        return item.containsValue("waterway", WATERWAY_MATCHES) || item.containsValue("natural", NATURAL_MATCHES) && item.containsValue("water", WATER_MATCHES);
    }

    @Override
    protected String type() {
        return "river_length";
    }
}

