/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.statistics.coverage.area;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.statistics.coverage.Coverage;
import org.slf4j.Logger;

public abstract class AreaCoverage
extends Coverage<Area> {
    public AreaCoverage(Logger logger, Atlas atlas) {
        super(logger, atlas);
    }

    public AreaCoverage(Logger logger, Atlas atlas, Predicate<Area> filter) {
        super(logger, atlas, filter);
    }

    @Override
    protected Coverage.CoverageType coverageType() {
        return Coverage.CoverageType.DISTANCE;
    }

    @Override
    protected Iterable<Area> getEntities() {
        return this.getAtlas().areas();
    }

    @Override
    protected Set<String> getKeys(Area area) {
        return new HashSet<String>();
    }

    @Override
    protected String getUnit() {
        return "kilometer squared";
    }

    @Override
    protected double getValue(Area area) {
        return area.asPolygon().surface().asKilometerSquared();
    }
}

