/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.raw.slicing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.operation.linemerge.LineMerger;
import org.locationtech.jts.operation.overlay.snap.SnapOverlayOp;
import org.locationtech.jts.precision.GeometryPrecisionReducer;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.change.ChangeAtlas;
import org.openstreetmap.atlas.geography.atlas.change.ChangeBuilder;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteArea;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteLine;
import org.openstreetmap.atlas.geography.atlas.complete.CompletePoint;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteRelation;
import org.openstreetmap.atlas.geography.atlas.dynamic.DynamicAtlas;
import org.openstreetmap.atlas.geography.atlas.dynamic.policy.DynamicAtlasPolicy;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.items.complex.RelationOrAreaToMultiPolygonConverter;
import org.openstreetmap.atlas.geography.atlas.pbf.AtlasLoadingOption;
import org.openstreetmap.atlas.geography.atlas.pbf.slicing.identifier.CountrySlicingIdentifierFactory;
import org.openstreetmap.atlas.geography.atlas.sub.AtlasCutType;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.converters.jts.JtsMultiPolygonToMultiPolygonConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsPolyLineConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsPolygonConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsPrecisionManager;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.Sharding;
import org.openstreetmap.atlas.tags.ISOCountryTag;
import org.openstreetmap.atlas.tags.SyntheticBoundaryNodeTag;
import org.openstreetmap.atlas.tags.SyntheticRelationMemberAdded;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.identifiers.EntityIdentifierGenerator;
import org.openstreetmap.atlas.utilities.scalars.Duration;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawAtlasSlicer {
    private static final JtsPolygonConverter JTS_POLYGON_CONVERTER = new JtsPolygonConverter();
    private static final JtsPolyLineConverter JTS_POLYLINE_CONVERTER = new JtsPolyLineConverter();
    private static final JtsMultiPolygonToMultiPolygonConverter JTS_MULTIPOLYGON_CONVERTER = new JtsMultiPolygonToMultiPolygonConverter();
    private static final RelationOrAreaToMultiPolygonConverter RELATION_TO_MULTIPOLYGON_CONVERTER = new RelationOrAreaToMultiPolygonConverter();
    private static final Logger logger = LoggerFactory.getLogger(RawAtlasSlicer.class);
    private static final long SLICING_DURATION_WARN = 10L;
    private static final String MULTIPOLYGON_RELATION_SLICING_NOT_NEEDED = "Relation {} for Atlas {} had no sliced members and therefore does not need to be sliced!";
    private static final String MULTIPOLYGON_RELATION_EXCEPTION_CREATING_POLYGON = "Relation {} for Atlas {} could not be constructed into valid multipolygon!";
    private static final String MULTIPOLYGON_RELATION_INVALID_GEOMETRY = "Relation {} for Atlas {} had invalid multipolygon geometry {}!";
    private static final String MULTIPOLYGON_RELATION_HAD_NO_SLICED_GEOMETRY = "Relation {} for Atlas {} had no valid sliced geometry!";
    private static final String MULTIPOLYGON_RELATION_HAD_EQUIVALENT_SLICED_GEOMETRY = "Relation {} for Atlas {} had sliced geometry equal to original geometry, not slicing!";
    private static final String MULTIPOLYGON_RELATION_ENTIRELY_SYNTHETIC_GEOMETRY = "Relation {} for Atlas {} created using entirely synthetic members!";
    private static final String MULTIPOLYGON_RELATION_SLICING_DURATION_EXCEEDED = "Relation {} for Atlas {} took {} to slice!";
    private static final String MULTIPOLYGON_RELATION_TOPOLOGY_EXCEPTION = "Topology exception while using snap overlay operation on relation {} for Atlas {}, falling back to regular intersection";
    private static final String MULTIPOLYGON_RELATION_INVALID_MEMBER_REMOVED = "Purging invalid member {} from relation {}";
    private static final String MULTIPOLYGON_RELATION_INVALID_SLICED_GEOMETRY = "Relation {} sliced for country {} produced invalid geometry {}!";
    private static final String LINE_HAD_MULTIPOLYGON_SLICE = "Line {} for Atlas {} had multipolygon slicing result {}, discarding as cannot be represented in an Area";
    private static final String LINE_SLICING_DURATION_EXCEEDED = "Line {} for Atlas {} took {} to slice!";
    private static final String LINE_HAD_INVALID_GEOMETRY = "Line {} for Atlas {} had invalid geometry {}, removing instead of slicing!";
    private static final String LINE_EXCEEDED_SLICING_IDENTIFIER_SPACE = "Country slicing exceeded maximum line identifier name space of {} for line {} for Atlas {}. It will be added as is, with two or more country codes";
    private static final String STARTED_SLICING = "Starting slicing for Atlas {}";
    private static final String FINISHED_SLICING = "Finished slicing for Atlas {} in {}";
    private static final String STARTED_LINE_SLICING = "Starting line slicing for Atlas {}";
    private static final String FINISHED_LINE_SLICING = "Finished line slicing for Atlas {} in {}";
    private static final String STARTED_RELATION_SLICING = "Starting relation slicing for Atlas {}";
    private static final String FINISHED_RELATION_SLICING = "Finished relation slicing for Atlas {} in {}";
    private static final String STARTED_POINT_SLICING = "Starting point slicing for Atlas {}";
    private static final String FINISHED_POINT_SLICING = "Finished point slicing for Atlas {} in {}";
    private static final String STARTED_RELATION_FILTERING = "Starting relation filtering for Atlas {}";
    private static final String FINISHED_RELATION_FILTERING = "Finished relation filtering for Atlas {} in {}";
    private final Predicate<AtlasEntity> relationPredicate;
    private final AtlasLoadingOption loadingOption;
    private final String shardOrAtlasName;
    private final Atlas startingAtlas;
    private final Shard initialShard;
    private final Map<Long, Map<String, CompleteRelation>> splitRelations = new HashMap<Long, Map<String, CompleteRelation>>();
    private final Set<FeatureChange> changes = new HashSet<FeatureChange>();
    private final Map<Long, CompleteRelation> stagedRelations = new HashMap<Long, CompleteRelation>();
    private final Map<Long, CompleteLine> stagedLines = new HashMap<Long, CompleteLine>();
    private final Map<Long, CompletePoint> stagedPoints = new HashMap<Long, CompletePoint>();
    private final Map<Long, CompleteArea> stagedAreas = new HashMap<Long, CompleteArea>();
    private final Predicate<AtlasEntity> isInCountry;

    public RawAtlasSlicer(AtlasLoadingOption loadingOption, Atlas startingAtlas) {
        this.loadingOption = loadingOption;
        this.startingAtlas = startingAtlas;
        this.initialShard = null;
        this.relationPredicate = entity -> entity.getType().equals((Object)ItemType.RELATION) && loadingOption.getRelationSlicingFilter().test((Taggable)entity);
        this.isInCountry = entity -> ISOCountryTag.isIn(this.getCountries()).test((Taggable)entity);
        this.shardOrAtlasName = startingAtlas.metaData().getShardName().orElse(startingAtlas.getName());
        this.startingAtlas.points().forEach(point -> this.stagedPoints.put(point.getIdentifier(), CompletePoint.from(point)));
        this.startingAtlas.lines().forEach(line -> this.stagedLines.put(line.getIdentifier(), CompleteLine.from(line)));
        this.startingAtlas.relations().forEach(relation -> this.stagedRelations.put(relation.getIdentifier(), CompleteRelation.from(relation)));
    }

    public RawAtlasSlicer(AtlasLoadingOption loadingOption, Shard initialShard, Sharding sharding, Function<Shard, Optional<Atlas>> atlasFetcher) {
        this.loadingOption = loadingOption;
        this.initialShard = initialShard;
        this.relationPredicate = entity -> entity.getType().equals((Object)ItemType.RELATION) && loadingOption.getRelationSlicingFilter().test((Taggable)entity);
        this.isInCountry = entity -> ISOCountryTag.isIn(this.getCountries()).test((Taggable)entity);
        HashSet relationsForInitialShard = new HashSet();
        Optional<Atlas> initialShardOptional = atlasFetcher.apply(initialShard);
        if (!initialShardOptional.isPresent()) {
            throw new CoreException("Could not get data for initial shard {} during slicing!", initialShard.getName());
        }
        initialShardOptional.get().relations().forEach(relation -> relationsForInitialShard.add(relation.getIdentifier()));
        Atlas expandedAtlas = this.buildExpandedAtlas(initialShard, initialShardOptional.get(), sharding, atlasFetcher);
        Predicate<AtlasEntity> filter = entity -> {
            if (entity.getType().equals((Object)ItemType.RELATION)) {
                return relationsForInitialShard.contains(entity.getIdentifier());
            }
            return true;
        };
        Optional<Atlas> subAtlasOptional = expandedAtlas.subAtlas(filter, AtlasCutType.SILK_CUT);
        if (!subAtlasOptional.isPresent()) {
            throw new CoreException("No data after sub-atlasing to remove new relations from partially expanded Atlas {}!", expandedAtlas.getName());
        }
        this.startingAtlas = subAtlasOptional.get();
        this.shardOrAtlasName = this.startingAtlas.metaData().getShardName().orElse(this.startingAtlas.getName());
        this.startingAtlas.points().forEach(point -> this.stagedPoints.put(point.getIdentifier(), CompletePoint.from(point)));
        this.startingAtlas.lines().forEach(line -> this.stagedLines.put(line.getIdentifier(), CompleteLine.from(line)));
        this.startingAtlas.relations().forEach(relation -> this.stagedRelations.put(relation.getIdentifier(), CompleteRelation.from(relation)));
    }

    public Atlas slice() {
        Time overallTime = Time.now();
        Time time = Time.now();
        logger.info(STARTED_SLICING, (Object)this.shardOrAtlasName);
        logger.info(STARTED_LINE_SLICING, (Object)this.shardOrAtlasName);
        this.startingAtlas.lines().forEach(line -> {
            if (line.isClosed() && !this.isAtlasEdge((Line)line)) {
                this.sliceArea((Line)line);
            } else {
                this.sliceLine((Line)line);
            }
        });
        logger.info(FINISHED_LINE_SLICING, (Object)this.shardOrAtlasName, (Object)time.elapsedSince().asMilliseconds());
        time = Time.now();
        logger.info(STARTED_RELATION_SLICING, (Object)this.shardOrAtlasName);
        this.startingAtlas.relationsLowerOrderFirst().forEach(relation -> {
            if (this.relationPredicate.test((AtlasEntity)relation)) {
                this.sliceMultiPolygonRelation(this.stagedRelations.get(relation.getIdentifier()));
            }
        });
        logger.info(FINISHED_RELATION_SLICING, (Object)this.shardOrAtlasName, (Object)time.elapsedSince().asMilliseconds());
        time = Time.now();
        logger.info(STARTED_POINT_SLICING, (Object)this.shardOrAtlasName);
        this.startingAtlas.points().forEach(this::slicePoint);
        logger.info(FINISHED_POINT_SLICING, (Object)this.shardOrAtlasName, (Object)time.elapsedSince().asMilliseconds());
        logger.info(STARTED_RELATION_FILTERING, (Object)this.shardOrAtlasName);
        this.startingAtlas.relationsLowerOrderFirst().forEach(relation -> {
            if (this.stagedRelations.containsKey(relation.getIdentifier()) && !Validators.hasValuesFor(this.stagedRelations.get(relation.getIdentifier()), ISOCountryTag.class)) {
                this.filterRelation(this.stagedRelations.get(relation.getIdentifier()));
            }
        });
        logger.info(FINISHED_RELATION_FILTERING, (Object)this.shardOrAtlasName, (Object)time.elapsedSince().asMilliseconds());
        this.stagedLines.values().forEach(line -> this.changes.add(FeatureChange.add(line, this.startingAtlas)));
        this.stagedPoints.values().forEach(point -> this.changes.add(FeatureChange.add(point, this.startingAtlas)));
        this.stagedRelations.values().forEach(relation -> this.changes.add(FeatureChange.add(relation, this.startingAtlas)));
        this.stagedAreas.values().forEach(area -> this.changes.add(FeatureChange.add(area, this.startingAtlas)));
        logger.info(FINISHED_SLICING, (Object)this.shardOrAtlasName, (Object)overallTime.elapsedSince().asMilliseconds());
        return this.cutSubAtlasForOriginalShard(new ChangeAtlas(this.startingAtlas, new ChangeBuilder().addAll(this.changes).get()));
    }

    private void addCountryMembersToSplitRelation(CompleteRelation newRelation, CompleteRelation oldRelation, org.locationtech.jts.geom.MultiPolygon countryMultiPolygon) {
        oldRelation.membersMatching(member -> Validators.isOfSameType(this.stagedLines.get(member.getEntity().getIdentifier()), newRelation, ISOCountryTag.class)).forEach(member -> {
            CompleteLine lineForMember = this.stagedLines.get(member.getEntity().getIdentifier());
            if (JTS_POLYLINE_CONVERTER.convert(lineForMember.asPolyLine()).intersects(countryMultiPolygon)) {
                newRelation.withAddedMember((AtlasEntity)lineForMember, member.getRole());
                lineForMember.withAddedRelationIdentifier(newRelation.getIdentifier());
            }
            lineForMember.withRemovedRelationIdentifier(oldRelation.getIdentifier());
        });
    }

    private void addSyntheticBoundaryNodesForSlice(Line line, PolyLine slice) {
        CompletePoint syntheticBoundaryNode;
        HashMap<String, String> tags;
        TreeSet<String> countries;
        EntityIdentifierGenerator pointIdentifierGenerator;
        if (!slice.first().equals(line.asPolyLine().first())) {
            Iterable<Point> pointsAtFirstLocation = this.startingAtlas.pointsAt(slice.first());
            if (Iterables.isEmpty(pointsAtFirstLocation)) {
                pointIdentifierGenerator = new EntityIdentifierGenerator();
                countries = new TreeSet<String>();
                tags = new HashMap<String, String>();
                countries.addAll(Arrays.asList(this.getCountryBoundaryMap().getCountryCodeISO3(slice.first()).getIso3CountryCode().split(",")));
                tags.put("iso_country_code", String.join((CharSequence)",", countries));
                tags.put("synthetic_boundary_node", SyntheticBoundaryNodeTag.YES.toString());
                syntheticBoundaryNode = new CompletePoint(1L, slice.first(), tags, new HashSet<Long>());
                syntheticBoundaryNode.withIdentifier(pointIdentifierGenerator.generateIdentifier(syntheticBoundaryNode));
                this.stagedPoints.put(syntheticBoundaryNode.getIdentifier(), syntheticBoundaryNode);
            } else {
                this.stagedPoints.get(pointsAtFirstLocation.iterator().next().getIdentifier()).withAddedTag("synthetic_boundary_node", SyntheticBoundaryNodeTag.EXISTING.toString());
            }
        }
        if (!slice.last().equals(line.asPolyLine().last())) {
            Iterable<Point> pointsAtLastLocation = this.startingAtlas.pointsAt(slice.last());
            if (Iterables.isEmpty(pointsAtLastLocation)) {
                pointIdentifierGenerator = new EntityIdentifierGenerator();
                countries = new TreeSet();
                tags = new HashMap();
                countries.addAll(Arrays.asList(this.getCountryBoundaryMap().getCountryCodeISO3(slice.last()).getIso3CountryCode().split(",")));
                tags.put("iso_country_code", String.join((CharSequence)",", countries));
                tags.put("synthetic_boundary_node", SyntheticBoundaryNodeTag.YES.toString());
                syntheticBoundaryNode = new CompletePoint(1L, slice.last(), tags, new HashSet<Long>());
                syntheticBoundaryNode.withIdentifier(pointIdentifierGenerator.generateIdentifier(syntheticBoundaryNode));
                this.stagedPoints.put(syntheticBoundaryNode.getIdentifier(), syntheticBoundaryNode);
            } else {
                this.stagedPoints.get(pointsAtLastLocation.iterator().next().getIdentifier()).withAddedTag("synthetic_boundary_node", SyntheticBoundaryNodeTag.EXISTING.toString());
            }
        }
    }

    private Set<String> addSyntheticLinesForRemainder(CompleteRelation newRelation, Geometry remainder, String role) {
        Optional<String> countryCodeTag = newRelation.getTag("iso_country_code");
        if (countryCodeTag.isEmpty()) {
            throw new CoreException("Could not find country code for split relation {}", newRelation.getIdentifier());
        }
        String countryCode = countryCodeTag.get();
        HashSet<String> synetheticIdsAdded = new HashSet<String>();
        for (int i = 0; i < remainder.getNumGeometries(); ++i) {
            LineString remainderLine = (LineString)remainder.getGeometryN(i);
            HashMap<String, String> newLineTags = new HashMap<String, String>();
            newLineTags.put("iso_country_code", countryCode);
            EntityIdentifierGenerator lineIdentifierGenerator = new EntityIdentifierGenerator();
            CompleteLine newLine = new CompleteLine(0L, JTS_POLYLINE_CONVERTER.backwardConvert(remainderLine), newLineTags, new HashSet<Long>());
            newLine.withIdentifier(lineIdentifierGenerator.generateIdentifier(newLine));
            newLine.withAddedRelationIdentifier(newRelation.getIdentifier());
            newRelation.withAddedMember((AtlasEntity)newLine, role);
            this.stagedLines.put(newLine.getIdentifier(), newLine);
            synetheticIdsAdded.add(Long.toString(newLine.getIdentifier()));
        }
        return synetheticIdsAdded;
    }

    private Atlas buildExpandedAtlas(Shard initialShard, Atlas initialAtlas, Sharding sharding, Function<Shard, Optional<Atlas>> atlasFetcher) {
        Predicate<AtlasEntity> expandPredicate = entity -> entity.getType().equals((Object)ItemType.LINE) && entity.relations().stream().anyMatch(relation -> this.relationPredicate.test((AtlasEntity)relation) && initialAtlas.relation(relation.getIdentifier()) != null);
        DynamicAtlasPolicy policy = new DynamicAtlasPolicy(atlasFetcher, sharding, initialShard, (Polygon)Rectangle.MAXIMUM).withDeferredLoading(true).withExtendIndefinitely(true).withAtlasEntitiesToConsiderForExpansion(expandPredicate);
        DynamicAtlas atlas = new DynamicAtlas(policy);
        atlas.preemptiveLoad();
        return atlas;
    }

    private boolean checkSlices(Set<String> slicesCountryCodes, long totalSlicesCount, Line line) {
        if (slicesCountryCodes.size() == 1) {
            String countryCode = slicesCountryCodes.iterator().next();
            this.stagedLines.get(line.getIdentifier()).withAddedTag("iso_country_code", countryCode);
            if (!this.isInCountry.test(this.stagedLines.get(line.getIdentifier()))) {
                this.removeLine(line);
            }
            return false;
        }
        if (totalSlicesCount > 1000L) {
            logger.error(LINE_EXCEEDED_SLICING_IDENTIFIER_SPACE, new Object[]{1000L, line.getOsmIdentifier(), this.shardOrAtlasName});
            String countryString = String.join((CharSequence)",", slicesCountryCodes);
            ((CompleteLine)this.stagedLines.get(line.getIdentifier()).withTags(line.getTags())).withAddedTag("iso_country_code", countryString);
            return false;
        }
        return true;
    }

    private void createNewSlicedAreas(Line line, SortedMap<String, Set<org.locationtech.jts.geom.Polygon>> slices) {
        CountrySlicingIdentifierFactory lineIdentifierFactory = new CountrySlicingIdentifierFactory(line.getIdentifier());
        slices.keySet().forEach(countryCode -> {
            for (org.locationtech.jts.geom.Polygon slice : (Set)slices.get(countryCode)) {
                long lineSliceIdentifier = lineIdentifierFactory.nextIdentifier();
                Polygon newLineGeometry = new Polygon(this.processSlice(slice, line));
                Map<String, String> lineTags = line.getTags();
                lineTags.put("iso_country_code", (String)countryCode);
                HashSet<Long> relationIds = new HashSet<Long>();
                line.relations().forEach(relation -> relationIds.add(relation.getIdentifier()));
                CompleteArea newAreaSlice = new CompleteArea(lineSliceIdentifier, newLineGeometry, lineTags, relationIds);
                if (!this.isInsideWorkingBound(newAreaSlice)) continue;
                this.stagedAreas.put(newAreaSlice.getIdentifier(), newAreaSlice);
                for (Relation relation2 : line.relations()) {
                    if (!this.stagedRelations.containsKey(relation2.getIdentifier())) continue;
                    this.stagedRelations.get(relation2.getIdentifier()).withAddedMember((AtlasEntity)newAreaSlice, line);
                }
            }
        });
        CompleteLine removedOldLine = this.stagedLines.remove(line.getIdentifier());
        this.changes.add(FeatureChange.remove(removedOldLine, this.startingAtlas));
        this.stagedLines.remove(line.getIdentifier());
        removedOldLine.relationIdentifiers().forEach(relationIdentifier -> {
            if (this.stagedRelations.containsKey(relationIdentifier)) {
                this.stagedRelations.get(relationIdentifier).withRemovedMember(removedOldLine);
            }
        });
    }

    private void createNewSlicedLines(Line line, SortedMap<String, Set<LineString>> slices) {
        CountrySlicingIdentifierFactory lineIdentifierFactory = new CountrySlicingIdentifierFactory(line.getIdentifier());
        slices.keySet().forEach(countryCode -> {
            for (LineString slice : (Set)slices.get(countryCode)) {
                long lineSliceIdentifier = lineIdentifierFactory.nextIdentifier();
                if (!this.getCountries().contains(countryCode)) continue;
                PolyLine newLineGeometry = this.processSlice(slice, line);
                if (this.isAtlasEdge(line)) {
                    this.addSyntheticBoundaryNodesForSlice(line, newLineGeometry);
                }
                Map<String, String> lineTags = line.getTags();
                lineTags.put("iso_country_code", (String)countryCode);
                CompleteLine newLineSlice = ((CompleteLine)CompleteLine.from(line).withIdentifier(lineSliceIdentifier).withTags(lineTags)).withPolyLine(newLineGeometry);
                this.stagedLines.put(newLineSlice.getIdentifier(), newLineSlice);
                for (Relation relation : line.relations()) {
                    if (!this.stagedRelations.containsKey(relation.getIdentifier())) continue;
                    this.stagedRelations.get(relation.getIdentifier()).withAddedMember((AtlasEntity)newLineSlice, line);
                }
            }
        });
        CompleteLine removedOldLine = this.stagedLines.remove(line.getIdentifier());
        this.changes.add(FeatureChange.remove(removedOldLine, this.startingAtlas));
        this.stagedLines.remove(line.getIdentifier());
        removedOldLine.relationIdentifiers().forEach(relationIdentifier -> {
            if (this.stagedRelations.containsKey(relationIdentifier)) {
                this.stagedRelations.get(relationIdentifier).withRemovedMember(removedOldLine);
            }
        });
    }

    private void createSyntheticRelationMembers(CompleteRelation newRelation, org.locationtech.jts.geom.MultiPolygon newMultiPolygon) {
        TreeSet<String> syntheticIds = new TreeSet<String>();
        for (int polygonIndex = 0; polygonIndex < newMultiPolygon.getNumGeometries(); ++polygonIndex) {
            org.locationtech.jts.geom.Polygon geometry = (org.locationtech.jts.geom.Polygon)newMultiPolygon.getGeometryN(polygonIndex);
            Geometry remainderExterior = geometry.getExteriorRing();
            if (newRelation.members() != null) {
                remainderExterior = this.cutOutExistingMembers(newRelation, geometry.getExteriorRing());
            } else {
                logger.warn(MULTIPOLYGON_RELATION_ENTIRELY_SYNTHETIC_GEOMETRY, (Object)newRelation.getIdentifier(), (Object)this.shardOrAtlasName);
            }
            if (remainderExterior.isEmpty()) continue;
            syntheticIds.addAll(this.addSyntheticLinesForRemainder(newRelation, remainderExterior, "outer"));
            for (int i = 0; i < geometry.getNumInteriorRing(); ++i) {
                Geometry remainderInterior = geometry.getInteriorRingN(i);
                for (RelationMember member2 : newRelation.membersMatching(member -> member.getRole().equals("inner"))) {
                    LineString innerLineString = JTS_POLYLINE_CONVERTER.convert(this.stagedLines.get(member2.getEntity().getIdentifier()).asPolyLine());
                    if (!innerLineString.intersects(remainderInterior)) continue;
                    remainderInterior = SnapOverlayOp.difference(remainderInterior, innerLineString);
                }
                if (((Geometry)remainderInterior).isEmpty()) continue;
                syntheticIds.addAll(this.addSyntheticLinesForRemainder(newRelation, remainderInterior, "inner"));
            }
        }
        newRelation.withAddedTag("synthetic_relation_member_added", String.join((CharSequence)",", syntheticIds));
    }

    private Geometry cutOutExistingMembers(CompleteRelation newRelation, Geometry slicedPolygonOuter) {
        Geometry remainder = slicedPolygonOuter;
        for (RelationMember member : newRelation.members()) {
            LineString outerLineString = JTS_POLYLINE_CONVERTER.convert(this.stagedLines.get(member.getEntity().getIdentifier()).asPolyLine());
            if (!outerLineString.intersects(slicedPolygonOuter)) continue;
            try {
                remainder = SnapOverlayOp.difference(remainder, outerLineString);
            }
            catch (TopologyException exception) {
                logger.error(MULTIPOLYGON_RELATION_TOPOLOGY_EXCEPTION, (Object)newRelation.getIdentifier(), (Object)this.shardOrAtlasName);
                remainder = remainder.difference(outerLineString);
            }
            if (!member.getRole().equals("inner")) continue;
            newRelation.changeMemberRole(member.getEntity(), "outer");
        }
        return remainder;
    }

    private Atlas cutSubAtlasForOriginalShard(Atlas atlas) {
        if (this.initialShard == null) {
            return atlas;
        }
        Optional<Atlas> finalSubAtlas = atlas.subAtlas(this.initialShard.bounds(), AtlasCutType.SILK_CUT);
        if (finalSubAtlas.isPresent()) {
            return finalSubAtlas.get();
        }
        return null;
    }

    private void filterRelation(CompleteRelation relation) {
        HashSet<String> countryList = new HashSet<String>();
        for (RelationMember member : relation.members()) {
            AtlasEntity stagedRelationMember = this.getStagedEntityForMember(member);
            if (stagedRelationMember == null) {
                relation.withRemovedMember(member.getEntity());
                if (!member.getEntity().getType().equals((Object)ItemType.RELATION) || !this.splitRelations.containsKey(member.getEntity().getIdentifier())) continue;
                this.splitRelations.get(member.getEntity().getIdentifier()).keySet().forEach(countryCode -> {
                    if (this.getCountries().contains(countryCode)) {
                        relation.withAddedMember((AtlasEntity)this.splitRelations.get(member.getEntity().getIdentifier()).get(countryCode), member.getRole());
                        countryList.add((String)countryCode);
                    }
                });
                continue;
            }
            Optional<String> countryCodeTag = stagedRelationMember.getTag("iso_country_code");
            if (countryCodeTag.isEmpty()) {
                throw new CoreException("Untagged country value for entity {} for relation {} for Atlas {}", stagedRelationMember, relation.getIdentifier(), this.shardOrAtlasName);
            }
            Collections.addAll(countryList, countryCodeTag.get().split(","));
        }
        if (countryList.isEmpty()) {
            this.stagedRelations.remove(relation.getIdentifier());
            this.changes.add(FeatureChange.remove(relation));
            return;
        }
        relation.withAddedTag("iso_country_code", ISOCountryTag.join(countryList));
    }

    private Set<String> getCountries() {
        if (this.loadingOption.getCountryCodes().isEmpty()) {
            HashSet<String> allCountryCodes = new HashSet<String>();
            allCountryCodes.addAll(this.loadingOption.getCountryBoundaryMap().allCountryNames());
            this.loadingOption.setAdditionalCountryCodes(allCountryCodes);
        }
        return this.loadingOption.getCountryCodes();
    }

    private CountryBoundaryMap getCountryBoundaryMap() {
        return this.loadingOption.getCountryBoundaryMap();
    }

    private Set<org.locationtech.jts.geom.Polygon> getIntersectingBoundaryPolygons(Geometry targetGeometry) {
        return this.getCountryBoundaryMap().query(targetGeometry.getEnvelopeInternal()).stream().distinct().collect(Collectors.toSet());
    }

    private AtlasEntity getStagedEntityForMember(RelationMember member) {
        long identifier = member.getEntity().getIdentifier();
        if (member.getEntity() instanceof Point) {
            if (this.stagedPoints.containsKey(identifier)) {
                return this.stagedPoints.get(identifier);
            }
            return null;
        }
        if (member.getEntity() instanceof Line) {
            if (this.stagedLines.containsKey(identifier)) {
                return this.stagedLines.get(identifier);
            }
            return null;
        }
        if (member.getEntity() instanceof Area) {
            if (this.stagedAreas.containsKey(identifier)) {
                return this.stagedAreas.get(identifier);
            }
            return null;
        }
        if (this.stagedRelations.containsKey(identifier)) {
            return this.stagedRelations.get(identifier);
        }
        return null;
    }

    private boolean isAtlasEdge(Line line) {
        return this.loadingOption.getEdgeFilter().test(line);
    }

    private boolean isInsideWorkingBound(AtlasEntity entity) {
        Optional<String> countryCodes = entity.getTag("iso_country_code");
        if (countryCodes.isPresent() && this.getCountries() != null && !this.getCountries().isEmpty()) {
            for (String countryCode : countryCodes.get().split(",")) {
                if (!this.getCountries().contains(countryCode)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isMultipolygonMember(Line line) {
        return line.relations().stream().anyMatch(this.relationPredicate::test);
    }

    private boolean isSignificantGeometry(Geometry geometry) {
        if (!geometry.isValid() && logger.isWarnEnabled()) {
            logger.warn("Found invalid geometry {} during slicing Atlas {}", (Object)geometry.toText(), (Object)this.shardOrAtlasName);
        }
        return geometry.isValid() && (geometry.getDimension() == 1 && geometry.getLength() > 1.0E-6 || geometry.getDimension() == 2 && geometry.getArea() > 5.0E-9);
    }

    private PolyLine processSlice(Geometry slice, Line line) {
        boolean sliceClockwise;
        boolean originalClockwise;
        PolyLine polylineForSlice;
        if (slice instanceof LineString) {
            polylineForSlice = JTS_POLYLINE_CONVERTER.backwardConvert((LineString)slice);
        } else if (slice instanceof org.locationtech.jts.geom.Polygon) {
            polylineForSlice = JTS_POLYLINE_CONVERTER.backwardConvert(((org.locationtech.jts.geom.Polygon)slice).getExteriorRing());
        } else {
            throw new CoreException("Unexpected geometry when slicing line {} for Atlas {}", line.getOsmIdentifier(), this.shardOrAtlasName);
        }
        if (line.isClosed() && slice instanceof org.locationtech.jts.geom.Polygon && (originalClockwise = new Polygon(line.asPolyLine().truncate(0, 1)).isClockwise()) != (sliceClockwise = new Polygon(polylineForSlice.truncate(0, 1)).isClockwise())) {
            polylineForSlice = polylineForSlice.reversed();
        }
        return polylineForSlice;
    }

    private void purgeInvalidMultiPolygonMembers(CompleteRelation relation) {
        relation.membersMatching(member -> member.getEntity().getType() != ItemType.LINE || !member.getRole().equals("outer") && !member.getRole().equals("inner")).forEach(invalidMember -> {
            long identifier = invalidMember.getEntity().getIdentifier();
            logger.warn(MULTIPOLYGON_RELATION_INVALID_MEMBER_REMOVED, invalidMember, (Object)relation.getOsmIdentifier());
            relation.withRemovedMember(invalidMember.getEntity());
            if (invalidMember.getEntity().getType().equals((Object)ItemType.LINE)) {
                this.stagedLines.get(identifier).withRemovedRelationIdentifier(relation.getIdentifier());
            } else if (invalidMember.getEntity().getType().equals((Object)ItemType.AREA)) {
                this.stagedAreas.get(identifier).withRemovedRelationIdentifier(relation.getIdentifier());
            } else if (invalidMember.getEntity().getType().equals((Object)ItemType.POINT)) {
                this.stagedPoints.get(identifier).withRemovedRelationIdentifier(relation.getIdentifier());
            } else if (this.stagedRelations.containsKey(identifier)) {
                this.stagedRelations.get(identifier).withRemovedRelationIdentifier(relation.getIdentifier());
            } else if (this.splitRelations.containsKey(identifier)) {
                this.splitRelations.get(identifier).values().forEach(childRelation -> childRelation.withRemovedRelationIdentifier(relation.getIdentifier()));
            }
        });
    }

    private void removeLine(Line line) {
        CompleteLine removedLine = this.stagedLines.remove(line.getIdentifier());
        this.changes.add(FeatureChange.remove(removedLine, this.startingAtlas));
        removedLine.relationIdentifiers().forEach(relationIdentifier -> {
            if (this.stagedRelations.containsKey(relationIdentifier)) {
                this.stagedRelations.get(relationIdentifier).withRemovedMember(removedLine);
            }
        });
    }

    private void sliceArea(Line line) {
        SortedMap<String, Set<org.locationtech.jts.geom.Polygon>> slices;
        Time time = Time.now();
        org.locationtech.jts.geom.Polygon jtsPolygon = JTS_POLYGON_CONVERTER.convert(new Polygon(line.asPolyLine()));
        Set<org.locationtech.jts.geom.Polygon> intersectingBoundaryPolygons = this.getIntersectingBoundaryPolygons(jtsPolygon);
        if (intersectingBoundaryPolygons.size() == 1 || CountryBoundaryMap.isSameCountry(intersectingBoundaryPolygons)) {
            String countryCode = CountryBoundaryMap.getGeometryProperty(intersectingBoundaryPolygons.iterator().next(), "iso_country_code");
            this.stagedLines.get(line.getIdentifier()).withAddedTag("iso_country_code", countryCode);
            if (!this.isInCountry.test(this.stagedLines.get(line.getIdentifier()))) {
                this.removeLine(line);
            }
            return;
        }
        if (jtsPolygon.isEmpty() || !jtsPolygon.isValid()) {
            if (logger.isErrorEnabled()) {
                logger.error(LINE_HAD_INVALID_GEOMETRY, new Object[]{line.getOsmIdentifier(), this.shardOrAtlasName, jtsPolygon.toText()});
            }
            TreeSet countries = new TreeSet();
            intersectingBoundaryPolygons.forEach(polygon -> countries.add(CountryBoundaryMap.getGeometryProperty(polygon, "iso_country_code")));
            String countryCodes = String.join((CharSequence)",", countries);
            this.stagedLines.get(line.getIdentifier()).withAddedTag("iso_country_code", countryCodes);
            return;
        }
        try {
            slices = this.slicePolygonGeometry(line.getOsmIdentifier(), jtsPolygon, intersectingBoundaryPolygons);
        }
        catch (CoreException exception) {
            logger.error("Line {} for Atlas {} had multipolygon slicing result when sliced as polygon, will slice as line instead!", (Object)line.getOsmIdentifier(), (Object)this.shardOrAtlasName);
            this.sliceLine(line);
            return;
        }
        if (!this.checkSlices(slices.keySet(), slices.values().size(), line)) {
            return;
        }
        this.createNewSlicedAreas(line, slices);
        if (time.elapsedSince().isMoreThan(Duration.minutes(10.0))) {
            logger.warn(LINE_SLICING_DURATION_EXCEEDED, new Object[]{line.getOsmIdentifier(), this.shardOrAtlasName, time.elapsedSince().asMilliseconds()});
        }
        if (this.isMultipolygonMember(line)) {
            this.stagedLines.put(line.getIdentifier(), CompleteLine.from(line));
            this.sliceLine(line);
        }
    }

    private Map<String, Set<Geometry>> sliceGeometry(Geometry geometry, Set<org.locationtech.jts.geom.Polygon> countryBoundaryPolygons) {
        HashMap<String, Set<Geometry>> results = new HashMap<String, Set<Geometry>>();
        for (org.locationtech.jts.geom.Polygon boundaryPolygon : countryBoundaryPolygons) {
            Geometry clipped;
            String countryCode = CountryBoundaryMap.getGeometryProperty(boundaryPolygon, "iso_country_code");
            IntersectionMatrix matrix = geometry.relate(boundaryPolygon);
            if (matrix.isWithin()) {
                CountryBoundaryMap.setGeometryProperty(geometry, "iso_country_code", countryCode);
                results.clear();
                results.put(countryCode, new HashSet());
                ((Set)results.get(countryCode)).add(geometry);
                return results;
            }
            if (!matrix.isIntersects()) continue;
            if (!results.containsKey(countryCode)) {
                results.put(countryCode, new HashSet());
            }
            if ((clipped = GeometryPrecisionReducer.reduce(geometry.intersection(boundaryPolygon), JtsPrecisionManager.getPrecisionModel())) instanceof GeometryCollection) {
                CountryBoundaryMap.geometries((GeometryCollection)clipped).filter(this::isSignificantGeometry).forEach(result -> {
                    CountryBoundaryMap.setGeometryProperty(result, "iso_country_code", countryCode);
                    ((Set)results.get(countryCode)).add(result);
                });
                continue;
            }
            if (!this.isSignificantGeometry(clipped)) continue;
            CountryBoundaryMap.setGeometryProperty(clipped, "iso_country_code", countryCode);
            ((Set)results.get(countryCode)).add(clipped);
        }
        return results;
    }

    private void sliceLine(Line line) {
        Time time = Time.now();
        LineString jtsLine = JTS_POLYLINE_CONVERTER.convert(line.asPolyLine());
        Set<org.locationtech.jts.geom.Polygon> intersectingBoundaryPolygons = this.getIntersectingBoundaryPolygons(jtsLine);
        if (CountryBoundaryMap.isSameCountry(intersectingBoundaryPolygons)) {
            String countryCode = CountryBoundaryMap.getGeometryProperty(intersectingBoundaryPolygons.iterator().next(), "iso_country_code");
            this.stagedLines.get(line.getIdentifier()).withAddedTag("iso_country_code", countryCode);
            if (!this.isInCountry.test(this.stagedLines.get(line.getIdentifier()))) {
                this.removeLine(line);
            }
            return;
        }
        if (jtsLine.isEmpty() || !jtsLine.isValid()) {
            if (logger.isErrorEnabled()) {
                logger.error(LINE_HAD_INVALID_GEOMETRY, new Object[]{line.getOsmIdentifier(), this.shardOrAtlasName, jtsLine.toText()});
            }
            TreeSet countries = new TreeSet();
            intersectingBoundaryPolygons.forEach(polygon -> countries.add(CountryBoundaryMap.getGeometryProperty(polygon, "iso_country_code")));
            String countryCodes = String.join((CharSequence)",", countries);
            this.stagedLines.get(line.getIdentifier()).withAddedTag("iso_country_code", countryCodes);
            return;
        }
        SortedMap<String, Set<LineString>> slices = this.sliceLineStringGeometry(jtsLine, intersectingBoundaryPolygons);
        if (!this.checkSlices(slices.keySet(), slices.values().size(), line)) {
            return;
        }
        this.createNewSlicedLines(line, slices);
        if (time.elapsedSince().isMoreThan(Duration.minutes(10.0))) {
            logger.warn(LINE_SLICING_DURATION_EXCEEDED, new Object[]{line.getOsmIdentifier(), this.shardOrAtlasName, time.elapsedSince().asMilliseconds()});
        }
    }

    private SortedMap<String, Set<LineString>> sliceLineStringGeometry(LineString line, Set<org.locationtech.jts.geom.Polygon> intersectingBoundaryPolygons) {
        Map<String, Set<Geometry>> currentResults = this.sliceGeometry(line, intersectingBoundaryPolygons);
        TreeMap<String, Set<LineString>> results = new TreeMap<String, Set<LineString>>();
        for (Map.Entry<String, Set<Geometry>> entry : currentResults.entrySet()) {
            HashSet lineSlices = new HashSet();
            LineMerger lineMerger = new LineMerger();
            entry.getValue().stream().filter(polygon -> polygon instanceof LineString).forEach(lineMerger::add);
            String countryCode = entry.getKey();
            lineMerger.add(lineSlices);
            lineMerger.getMergedLineStrings().forEach(mergedLineSlice -> {
                if (mergedLineSlice instanceof LineString) {
                    lineSlices.add((LineString)mergedLineSlice);
                }
            });
            results.put(countryCode, lineSlices);
        }
        return results;
    }

    private SortedMap<String, org.locationtech.jts.geom.MultiPolygon> sliceMultiPolygonGeometry(long identifier, org.locationtech.jts.geom.MultiPolygon geometry, Set<org.locationtech.jts.geom.Polygon> intersectingBoundaryPolygons) {
        Map<String, Set<Geometry>> currentResults = this.sliceGeometry(geometry, intersectingBoundaryPolygons);
        TreeMap<String, org.locationtech.jts.geom.MultiPolygon> results = new TreeMap<String, org.locationtech.jts.geom.MultiPolygon>();
        for (Map.Entry<String, Set<Geometry>> entry : currentResults.entrySet()) {
            HashSet polygonClippings = new HashSet();
            entry.getValue().stream().filter(polygon -> polygon instanceof org.locationtech.jts.geom.Polygon).forEach(polygon -> polygonClippings.add((org.locationtech.jts.geom.Polygon)polygon));
            String countryCode = entry.getKey();
            org.locationtech.jts.geom.MultiPolygon multipolygon = new org.locationtech.jts.geom.MultiPolygon(polygonClippings.toArray(new org.locationtech.jts.geom.Polygon[polygonClippings.size()]), JtsPrecisionManager.getGeometryFactory());
            if (multipolygon.isEmpty() || !multipolygon.isValid()) {
                if (!logger.isErrorEnabled()) continue;
                logger.warn(MULTIPOLYGON_RELATION_INVALID_SLICED_GEOMETRY, new Object[]{identifier, countryCode, multipolygon.toText()});
                continue;
            }
            results.put(countryCode, multipolygon);
        }
        return results;
    }

    private void sliceMultiPolygonRelation(CompleteRelation relation) {
        org.locationtech.jts.geom.MultiPolygon jtsMp;
        Time time = Time.now();
        this.purgeInvalidMultiPolygonMembers(relation);
        if (relation.membersMatching(member -> member.getEntity().getType().equals((Object)ItemType.LINE) && this.startingAtlas.line(member.getEntity().getIdentifier()) == null).isEmpty()) {
            logger.info(MULTIPOLYGON_RELATION_SLICING_NOT_NEEDED, (Object)relation.getOsmIdentifier(), (Object)this.shardOrAtlasName);
            return;
        }
        try {
            MultiPolygon multipolygon = RELATION_TO_MULTIPOLYGON_CONVERTER.convert(this.startingAtlas.relation(relation.getIdentifier()));
            jtsMp = JTS_MULTIPOLYGON_CONVERTER.backwardConvert(multipolygon);
        }
        catch (CoreException exception) {
            logger.error(MULTIPOLYGON_RELATION_EXCEPTION_CREATING_POLYGON, new Object[]{relation.getOsmIdentifier(), this.shardOrAtlasName, exception});
            return;
        }
        Set<org.locationtech.jts.geom.Polygon> polygons = this.getCountryBoundaryMap().query(jtsMp.getEnvelopeInternal()).stream().distinct().collect(Collectors.toSet());
        if (CountryBoundaryMap.isSameCountry(polygons)) {
            String country = CountryBoundaryMap.getGeometryProperty((Geometry)polygons.iterator().next(), "iso_country_code");
            relation.withAddedTag("iso_country_code", country);
            return;
        }
        if (!jtsMp.isValid()) {
            if (logger.isErrorEnabled()) {
                logger.error(MULTIPOLYGON_RELATION_INVALID_GEOMETRY, new Object[]{relation.getOsmIdentifier(), this.shardOrAtlasName, jtsMp.toText()});
            }
            return;
        }
        SortedMap<String, org.locationtech.jts.geom.MultiPolygon> clippedMultiPolygons = this.sliceMultiPolygonGeometry(relation.getIdentifier(), jtsMp, polygons);
        if (clippedMultiPolygons.isEmpty()) {
            logger.error(MULTIPOLYGON_RELATION_HAD_NO_SLICED_GEOMETRY, (Object)relation.getOsmIdentifier(), (Object)this.shardOrAtlasName);
            return;
        }
        for (Map.Entry<String, org.locationtech.jts.geom.MultiPolygon> entry : clippedMultiPolygons.entrySet()) {
            String country = entry.getKey();
            org.locationtech.jts.geom.MultiPolygon countryMultipolygon = entry.getValue();
            if (!countryMultipolygon.equals(jtsMp)) continue;
            logger.info(MULTIPOLYGON_RELATION_HAD_EQUIVALENT_SLICED_GEOMETRY, (Object)relation.getOsmIdentifier(), (Object)this.shardOrAtlasName);
            relation.withAddedTag("iso_country_code", country);
            return;
        }
        CountrySlicingIdentifierFactory relationIdentifierFactory = new CountrySlicingIdentifierFactory(relation.getIdentifier());
        ArrayList newRelationIds = new ArrayList();
        HashMap newRelations = new HashMap();
        clippedMultiPolygons.keySet().forEach(countryCode -> {
            long newRelationId = relationIdentifierFactory.nextIdentifier();
            newRelationIds.add(newRelationId);
            if (this.getCountries().contains(countryCode)) {
                CompleteRelation newRelation = CompleteRelation.shallowFrom(relation);
                newRelation.withTags(relation.getTags());
                newRelation.withAddedTag("iso_country_code", (String)countryCode);
                newRelation.withIdentifier(newRelationId);
                newRelation.withRelationIdentifiers((Set)relation.relationIdentifiers());
                this.addCountryMembersToSplitRelation(newRelation, relation, (org.locationtech.jts.geom.MultiPolygon)clippedMultiPolygons.get(countryCode));
                this.createSyntheticRelationMembers(newRelation, (org.locationtech.jts.geom.MultiPolygon)clippedMultiPolygons.get(countryCode));
                TreeSet<String> syntheticIds = new TreeSet<String>();
                if (!syntheticIds.isEmpty()) {
                    newRelation.withAddedTag("synthetic_relation_member_added", SyntheticRelationMemberAdded.join(syntheticIds));
                }
                newRelations.put(countryCode, newRelation);
            }
        });
        HashMap relationByCountry = new HashMap();
        newRelations.values().forEach(newRelation -> {
            newRelation.withAllRelationsWithSameOsmIdentifier(newRelationIds);
            relationByCountry.put(newRelation.getTag("iso_country_code").get(), newRelation);
            this.stagedRelations.put(newRelation.getIdentifier(), (CompleteRelation)newRelation);
        });
        this.changes.add(FeatureChange.remove(relation, this.startingAtlas));
        this.stagedRelations.remove(relation.getIdentifier());
        this.splitRelations.put(relation.getIdentifier(), relationByCountry);
        if (time.elapsedSince().isMoreThan(Duration.minutes(10.0))) {
            logger.warn(MULTIPOLYGON_RELATION_SLICING_DURATION_EXCEEDED, new Object[]{relation.getOsmIdentifier(), this.shardOrAtlasName, time.elapsedSince()});
        }
    }

    private void slicePoint(Point point) {
        if (point.getOsmTags().isEmpty() && !Iterables.stream(this.startingAtlas.linesContaining(point.getLocation())).anyMatch(this::isAtlasEdge)) {
            this.stagedPoints.remove(point.getIdentifier());
            this.changes.add(FeatureChange.remove(CompletePoint.shallowFrom(point)));
        } else {
            CompletePoint updatedPoint = this.stagedPoints.get(point.getIdentifier());
            TreeSet<String> countries = new TreeSet<String>();
            countries.addAll(Arrays.asList(this.getCountryBoundaryMap().getCountryCodeISO3(point.getLocation()).getIso3CountryCode().split(",")));
            updatedPoint.withAddedTag("iso_country_code", String.join((CharSequence)",", countries));
            if (countries.size() > 1) {
                updatedPoint.withAddedTag("synthetic_boundary_node", SyntheticBoundaryNodeTag.EXISTING.toString());
            }
            if (!this.isInCountry.test(updatedPoint)) {
                this.stagedPoints.remove(point.getIdentifier());
                this.changes.add(FeatureChange.remove(updatedPoint, this.startingAtlas));
            }
        }
    }

    private SortedMap<String, Set<org.locationtech.jts.geom.Polygon>> slicePolygonGeometry(long identifier, org.locationtech.jts.geom.Polygon polygon, Set<org.locationtech.jts.geom.Polygon> intersectingBoundaryPolygon) {
        Map<String, Set<Geometry>> currentResults = this.sliceGeometry(polygon, intersectingBoundaryPolygon);
        TreeMap<String, Set<org.locationtech.jts.geom.Polygon>> results = new TreeMap<String, Set<org.locationtech.jts.geom.Polygon>>();
        for (Map.Entry<String, Set<Geometry>> entry : currentResults.entrySet()) {
            String countryCode = entry.getKey();
            HashSet slicedPolygons = new HashSet();
            entry.getValue().forEach(geometry -> {
                if (geometry instanceof org.locationtech.jts.geom.Polygon) {
                    if (((org.locationtech.jts.geom.Polygon)geometry).getNumInteriorRing() > 0) {
                        throw new CoreException(LINE_HAD_MULTIPOLYGON_SLICE, identifier, this.shardOrAtlasName, geometry.toText());
                    }
                    slicedPolygons.add((org.locationtech.jts.geom.Polygon)geometry);
                }
            });
            results.put(countryCode, slicedPolygons);
        }
        return results;
    }
}

