/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.pbf.slicing.identifier;

import org.openstreetmap.atlas.exception.CoreException;

public abstract class AbstractIdentifierFactory {
    public static final long IDENTIFIER_SCALE_DEFAULT = 1000L;
    private final long[] referenceIdentifiers;
    private int index;
    private long delta;
    private final long identifierScale;

    public AbstractIdentifierFactory(long referenceIdentifier) {
        this(new long[]{referenceIdentifier});
    }

    public AbstractIdentifierFactory(long referenceIdentifier, long identifierScale) {
        this(new long[]{referenceIdentifier}, identifierScale);
    }

    public AbstractIdentifierFactory(long[] referenceIdentifierArray) {
        this.referenceIdentifiers = referenceIdentifierArray;
        this.delta = 0L;
        this.index = 0;
        this.identifierScale = 1000L;
    }

    public AbstractIdentifierFactory(long[] referenceIdentifierArray, long identifierScale) {
        this.referenceIdentifiers = referenceIdentifierArray;
        this.delta = 0L;
        this.index = 0;
        this.identifierScale = identifierScale;
    }

    public long getDelta() {
        return this.delta;
    }

    public long getIdentifierScale() {
        return this.identifierScale;
    }

    public long getReferenceIdentifier() {
        return this.referenceIdentifiers[this.index];
    }

    public boolean hasMore() {
        return this.delta < this.identifierScale - 1L || this.index < this.referenceIdentifiers.length - 1;
    }

    public abstract long nextIdentifier();

    protected void incrementDelta() {
        ++this.delta;
        if (this.delta >= this.identifierScale) {
            if (this.index < this.referenceIdentifiers.length - 1) {
                ++this.index;
                this.delta = 1L;
            } else {
                throw new CoreException("Entity {} has been split into more than 999 pieces", new Object[]{this.referenceIdentifiers});
            }
        }
    }
}

