/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.packed;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.AbstractAtlas;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasMetaData;
import org.openstreetmap.atlas.geography.atlas.builder.AtlasSize;
import org.openstreetmap.atlas.geography.atlas.exception.AtlasIntegrityException;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.items.RelationMemberList;
import org.openstreetmap.atlas.geography.atlas.packed.PackedArea;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlasCloner;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlasSerializer;
import org.openstreetmap.atlas.geography.atlas.packed.PackedEdge;
import org.openstreetmap.atlas.geography.atlas.packed.PackedLine;
import org.openstreetmap.atlas.geography.atlas.packed.PackedNode;
import org.openstreetmap.atlas.geography.atlas.packed.PackedPoint;
import org.openstreetmap.atlas.geography.atlas.packed.PackedRelation;
import org.openstreetmap.atlas.geography.atlas.packed.PackedTagStore;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.utilities.arrays.ByteArrayOfArrays;
import org.openstreetmap.atlas.utilities.arrays.IntegerArrayOfArrays;
import org.openstreetmap.atlas.utilities.arrays.LongArray;
import org.openstreetmap.atlas.utilities.arrays.LongArrayOfArrays;
import org.openstreetmap.atlas.utilities.arrays.PolyLineArray;
import org.openstreetmap.atlas.utilities.arrays.PolygonArray;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.compression.IntegerDictionary;
import org.openstreetmap.atlas.utilities.maps.LongToLongMap;
import org.openstreetmap.atlas.utilities.maps.LongToLongMultiMap;
import org.openstreetmap.atlas.utilities.scalars.Distance;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PackedAtlas
extends AbstractAtlas {
    protected static final String FIELD_PREFIX = "FIELD_";
    protected static final String FIELD_BOUNDS = "bounds";
    protected static final String FIELD_LOGGER = "logger";
    protected static final String FIELD_SERIAL_VERSION_UID = "serialVersionUID";
    protected static final String FIELD_SERIALIZER = "serializer";
    protected static final String FIELD_SAVE_SERIALIZATION_FORMAT = "saveSerializationFormat";
    protected static final String FIELD_LOAD_SERIALIZATION_FORMAT = "loadSerializationFormat";
    protected static final String FIELD_META_DATA = "metaData";
    protected static final String FIELD_DICTIONARY = "dictionary";
    protected static final Object FIELD_DICTIONARY_LOCK = new Object();
    protected static final String FIELD_EDGE_IDENTIFIERS = "edgeIdentifiers";
    protected static final Object FIELD_EDGE_IDENTIFIERS_LOCK = new Object();
    protected static final String FIELD_NODE_IDENTIFIERS = "nodeIdentifiers";
    protected static final Object FIELD_NODE_IDENTIFIERS_LOCK = new Object();
    protected static final String FIELD_AREA_IDENTIFIERS = "areaIdentifiers";
    protected static final Object FIELD_AREA_IDENTIFIERS_LOCK = new Object();
    protected static final String FIELD_LINE_IDENTIFIERS = "lineIdentifiers";
    protected static final Object FIELD_LINE_IDENTIFIERS_LOCK = new Object();
    protected static final String FIELD_POINT_IDENTIFIERS = "pointIdentifiers";
    protected static final Object FIELD_POINT_IDENTIFIERS_LOCK = new Object();
    protected static final String FIELD_RELATION_IDENTIFIERS = "relationIdentifiers";
    protected static final Object FIELD_RELATION_IDENTIFIERS_LOCK = new Object();
    protected static final String FIELD_EDGE_IDENTIFIER_TO_EDGE_ARRAY_INDEX = "edgeIdentifierToEdgeArrayIndex";
    protected static final Object FIELD_EDGE_IDENTIFIER_TO_EDGE_ARRAY_INDEX_LOCK = new Object();
    protected static final String FIELD_NODE_IDENTIFIER_TO_NODE_ARRAY_INDEX = "nodeIdentifierToNodeArrayIndex";
    protected static final Object FIELD_NODE_IDENTIFIER_TO_NODE_ARRAY_INDEX_LOCK = new Object();
    protected static final String FIELD_AREA_IDENTIFIER_TO_AREA_ARRAY_INDEX = "areaIdentifierToAreaArrayIndex";
    protected static final Object FIELD_AREA_IDENTIFIER_TO_AREA_ARRAY_INDEX_LOCK = new Object();
    protected static final String FIELD_LINE_IDENTIFIER_TO_LINE_ARRAY_INDEX = "lineIdentifierToLineArrayIndex";
    protected static final Object FIELD_LINE_IDENTIFIER_TO_LINE_ARRAY_INDEX_LOCK = new Object();
    protected static final String FIELD_POINT_IDENTIFIER_TO_POINT_ARRAY_INDEX = "pointIdentifierToPointArrayIndex";
    protected static final Object FIELD_POINT_IDENTIFIER_TO_POINT_ARRAY_INDEX_LOCK = new Object();
    protected static final String FIELD_RELATION_IDENTIFIER_TO_RELATION_ARRAY_INDEX = "relationIdentifierToRelationArrayIndex";
    protected static final Object FIELD_RELATION_IDENTIFIER_TO_RELATION_ARRAY_INDEX_LOCK = new Object();
    protected static final String FIELD_NODE_LOCATIONS = "nodeLocations";
    protected static final Object FIELD_NODE_LOCATIONS_LOCK = new Object();
    protected static final String FIELD_NODE_IN_EDGES_INDICES = "nodeInEdgesIndices";
    protected static final Object FIELD_NODE_IN_EDGES_INDICES_LOCK = new Object();
    protected static final String FIELD_NODE_OUT_EDGES_INDICES = "nodeOutEdgesIndices";
    protected static final Object FIELD_NODE_OUT_EDGES_INDICES_LOCK = new Object();
    protected static final String FIELD_NODE_TAGS = "nodeTags";
    protected static final Object FIELD_NODE_TAGS_LOCK = new Object();
    protected static final String FIELD_NODE_INDEX_TO_RELATION_INDICES = "nodeIndexToRelationIndices";
    protected static final Object FIELD_NODE_INDEX_TO_RELATION_INDICES_LOCK = new Object();
    protected static final String FIELD_EDGE_START_NODE_INDEX = "edgeStartNodeIndex";
    protected static final Object FIELD_EDGE_START_NODE_INDEX_LOCK = new Object();
    protected static final String FIELD_EDGE_END_NODE_INDEX = "edgeEndNodeIndex";
    protected static final Object FIELD_EDGE_END_NODE_INDEX_LOCK = new Object();
    protected static final String FIELD_EDGE_POLY_LINES = "edgePolyLines";
    protected static final Object FIELD_EDGE_POLY_LINES_LOCK = new Object();
    protected static final String FIELD_EDGE_TAGS = "edgeTags";
    protected static final Object FIELD_EDGE_TAGS_LOCK = new Object();
    protected static final String FIELD_EDGE_INDEX_TO_RELATION_INDICES = "edgeIndexToRelationIndices";
    protected static final Object FIELD_EDGE_INDEX_TO_RELATION_INDICES_LOCK = new Object();
    protected static final String FIELD_AREA_POLYGONS = "areaPolygons";
    protected static final Object FIELD_AREA_POLYGONS_LOCK = new Object();
    protected static final String FIELD_AREA_TAGS = "areaTags";
    protected static final Object FIELD_AREA_TAGS_LOCK = new Object();
    protected static final String FIELD_AREA_INDEX_TO_RELATION_INDICES = "areaIndexToRelationIndices";
    protected static final Object FIELD_AREA_INDEX_TO_RELATION_INDICES_LOCK = new Object();
    protected static final String FIELD_LINE_POLYLINES = "linePolyLines";
    protected static final Object FIELD_LINE_POLYLINES_LOCK = new Object();
    protected static final String FIELD_LINE_TAGS = "lineTags";
    protected static final Object FIELD_LINE_TAGS_LOCK = new Object();
    protected static final String FIELD_LINE_INDEX_TO_RELATION_INDICES = "lineIndexToRelationIndices";
    protected static final Object FIELD_LINE_INDEX_TO_RELATION_INDICES_LOCK = new Object();
    protected static final String FIELD_POINT_LOCATIONS = "pointLocations";
    protected static final Object FIELD_POINT_LOCATIONS_LOCK = new Object();
    protected static final String FIELD_POINT_TAGS = "pointTags";
    protected static final Object FIELD_POINT_TAGS_LOCK = new Object();
    protected static final String FIELD_POINT_INDEX_TO_RELATION_INDICES = "pointIndexToRelationIndices";
    protected static final Object FIELD_POINT_INDEX_TO_RELATION_INDICES_LOCK = new Object();
    protected static final String FIELD_RELATION_MEMBERS_INDICES = "relationMemberIndices";
    protected static final Object FIELD_RELATION_MEMBERS_INDICES_LOCK = new Object();
    protected static final String FIELD_RELATION_MEMBER_TYPES = "relationMemberTypes";
    protected static final Object FIELD_RELATION_MEMBER_TYPES_LOCK = new Object();
    protected static final String FIELD_RELATION_MEMBER_ROLES = "relationMemberRoles";
    protected static final Object FIELD_RELATION_MEMBER_ROLES_LOCK = new Object();
    protected static final String FIELD_RELATION_TAGS = "relationTags";
    protected static final Object FIELD_RELATION_TAGS_LOCK = new Object();
    protected static final String FIELD_RELATION_INDEX_TO_RELATION_INDICES = "relationIndexToRelationIndices";
    protected static final Object FIELD_RELATION_INDEX_TO_RELATION_INDICES_LOCK = new Object();
    protected static final String FIELD_RELATION_OSM_IDENTIFIER_TO_RELATION_IDENTIFIERS = "relationOsmIdentifierToRelationIdentifiers";
    protected static final Object FIELD_RELATION_OSM_IDENTIFIER_TO_RELATION_IDENTIFIERS_LOCK = new Object();
    protected static final String FIELD_RELATION_OSM_IDENTIFIERS = "relationOsmIdentifiers";
    protected static final Object FIELD_RELATION_OSM_IDENTIFIERS_LOCK = new Object();
    private static final long serialVersionUID = -7582554057580336684L;
    private static final Logger logger = LoggerFactory.getLogger(PackedAtlas.class);
    private transient PackedAtlasSerializer serializer;
    private AtlasSerializationFormat saveSerializationFormat = AtlasSerializationFormat.PROTOBUF;
    private AtlasSerializationFormat loadSerializationFormat = AtlasSerializationFormat.PROTOBUF;
    private AtlasMetaData metaData = new AtlasMetaData();
    private final IntegerDictionary<String> dictionary;
    private final LongArray edgeIdentifiers;
    private final LongArray nodeIdentifiers;
    private final LongArray areaIdentifiers;
    private final LongArray lineIdentifiers;
    private final LongArray pointIdentifiers;
    private final LongArray relationIdentifiers;
    private final LongToLongMap edgeIdentifierToEdgeArrayIndex;
    private final LongToLongMap nodeIdentifierToNodeArrayIndex;
    private final LongToLongMap areaIdentifierToAreaArrayIndex;
    private final LongToLongMap lineIdentifierToLineArrayIndex;
    private final LongToLongMap pointIdentifierToPointArrayIndex;
    private final LongToLongMap relationIdentifierToRelationArrayIndex;
    private final LongArray nodeLocations;
    private final LongArrayOfArrays nodeInEdgesIndices;
    private final LongArrayOfArrays nodeOutEdgesIndices;
    private final PackedTagStore nodeTags;
    private final LongToLongMultiMap nodeIndexToRelationIndices;
    private final LongArray edgeStartNodeIndex;
    private final LongArray edgeEndNodeIndex;
    private final PolyLineArray edgePolyLines;
    private final PackedTagStore edgeTags;
    private final LongToLongMultiMap edgeIndexToRelationIndices;
    private final PolygonArray areaPolygons;
    private final PackedTagStore areaTags;
    private final LongToLongMultiMap areaIndexToRelationIndices;
    private final PolyLineArray linePolyLines;
    private final PackedTagStore lineTags;
    private final LongToLongMultiMap lineIndexToRelationIndices;
    private final LongArray pointLocations;
    private final PackedTagStore pointTags;
    private final LongToLongMultiMap pointIndexToRelationIndices;
    private final LongArrayOfArrays relationMemberIndices;
    private final ByteArrayOfArrays relationMemberTypes;
    private final IntegerArrayOfArrays relationMemberRoles;
    private final PackedTagStore relationTags;
    private final LongToLongMultiMap relationIndexToRelationIndices;
    private final LongToLongMultiMap relationOsmIdentifierToRelationIdentifiers;
    private final LongArray relationOsmIdentifiers;
    private Rectangle bounds;

    public static PackedAtlas cloneFrom(Atlas other) {
        return new PackedAtlasCloner().cloneFrom(other);
    }

    public static PackedAtlas load(Resource resource) {
        PackedAtlas result = PackedAtlasSerializer.load(resource);
        result.setName(resource.getName());
        return result;
    }

    protected PackedAtlas() {
        this.metaData = null;
        this.dictionary = null;
        this.edgeIdentifiers = null;
        this.nodeIdentifiers = null;
        this.areaIdentifiers = null;
        this.lineIdentifiers = null;
        this.pointIdentifiers = null;
        this.relationIdentifiers = null;
        this.edgeIdentifierToEdgeArrayIndex = null;
        this.nodeIdentifierToNodeArrayIndex = null;
        this.areaIdentifierToAreaArrayIndex = null;
        this.lineIdentifierToLineArrayIndex = null;
        this.pointIdentifierToPointArrayIndex = null;
        this.relationIdentifierToRelationArrayIndex = null;
        this.nodeLocations = null;
        this.nodeInEdgesIndices = null;
        this.nodeOutEdgesIndices = null;
        this.nodeTags = null;
        this.nodeIndexToRelationIndices = null;
        this.edgeStartNodeIndex = null;
        this.edgeEndNodeIndex = null;
        this.edgePolyLines = null;
        this.edgeTags = null;
        this.edgeIndexToRelationIndices = null;
        this.areaPolygons = null;
        this.areaTags = null;
        this.areaIndexToRelationIndices = null;
        this.linePolyLines = null;
        this.lineTags = null;
        this.lineIndexToRelationIndices = null;
        this.pointLocations = null;
        this.pointTags = null;
        this.pointIndexToRelationIndices = null;
        this.relationMemberIndices = null;
        this.relationMemberTypes = null;
        this.relationMemberRoles = null;
        this.relationTags = null;
        this.relationIndexToRelationIndices = null;
        this.relationOsmIdentifierToRelationIdentifiers = null;
        this.relationOsmIdentifiers = null;
    }

    protected PackedAtlas(AtlasSize estimates) {
        long edgeNumberEstimate = estimates.getEdgeNumber();
        long nodeNumberEstimate = estimates.getNodeNumber();
        long areaNumberEstimate = estimates.getAreaNumber();
        long lineNumberEstimate = estimates.getLineNumber();
        long pointNumberEstimate = estimates.getPointNumber();
        long relationNumberEstimate = estimates.getRelationNumber();
        int subArraySize = Integer.MAX_VALUE;
        long maximumSize = Long.MAX_VALUE;
        int edgeMemoryBlockSize = (int)Math.max(1024L, edgeNumberEstimate % Integer.MAX_VALUE);
        int nodeMemoryBlockSize = (int)Math.max(1024L, nodeNumberEstimate % Integer.MAX_VALUE);
        int areaMemoryBlockSize = (int)Math.max(1024L, areaNumberEstimate % Integer.MAX_VALUE);
        int lineMemoryBlockSize = (int)Math.max(1024L, lineNumberEstimate % Integer.MAX_VALUE);
        int pointMemoryBlockSize = (int)Math.max(1024L, pointNumberEstimate % Integer.MAX_VALUE);
        int relationMemoryBlockSize = (int)Math.max(1024L, relationNumberEstimate % Integer.MAX_VALUE);
        int edgeHashSize = (int)Math.max(Math.min(edgeNumberEstimate / 10L, Integer.MAX_VALUE), 1L);
        int nodeHashSize = (int)Math.max(Math.min(nodeNumberEstimate / 10L, Integer.MAX_VALUE), 1L);
        int areaHashSize = (int)Math.max(Math.min(areaNumberEstimate / 10L, Integer.MAX_VALUE), 1L);
        int lineHashSize = (int)Math.max(Math.min(lineNumberEstimate / 10L, Integer.MAX_VALUE), 1L);
        int pointHashSize = (int)Math.max(Math.min(pointNumberEstimate / 10L, Integer.MAX_VALUE), 1L);
        int relationHashSize = (int)Math.max(Math.min(relationNumberEstimate / 10L, Integer.MAX_VALUE), 1L);
        this.dictionary = new IntegerDictionary();
        this.edgeIdentifiers = new LongArray(Long.MAX_VALUE, edgeMemoryBlockSize, Integer.MAX_VALUE);
        this.nodeIdentifiers = new LongArray(Long.MAX_VALUE, nodeMemoryBlockSize, Integer.MAX_VALUE);
        this.areaIdentifiers = new LongArray(Long.MAX_VALUE, areaMemoryBlockSize, Integer.MAX_VALUE);
        this.lineIdentifiers = new LongArray(Long.MAX_VALUE, lineMemoryBlockSize, Integer.MAX_VALUE);
        this.pointIdentifiers = new LongArray(Long.MAX_VALUE, pointMemoryBlockSize, Integer.MAX_VALUE);
        this.relationIdentifiers = new LongArray(Long.MAX_VALUE, relationMemoryBlockSize, Integer.MAX_VALUE);
        this.edgeIdentifierToEdgeArrayIndex = new LongToLongMap("PackedAtlas - edgeIdentifierToEdgeArrayIndex", Long.MAX_VALUE, edgeHashSize, edgeMemoryBlockSize, Integer.MAX_VALUE, edgeMemoryBlockSize, Integer.MAX_VALUE);
        this.nodeIdentifierToNodeArrayIndex = new LongToLongMap("PackedAtlas - nodeIdentifierToNodeArrayIndex", Long.MAX_VALUE, nodeHashSize, nodeMemoryBlockSize, Integer.MAX_VALUE, nodeMemoryBlockSize, Integer.MAX_VALUE);
        this.areaIdentifierToAreaArrayIndex = new LongToLongMap("PackedAtlas - areaIdentifierToAreaArrayIndex", Long.MAX_VALUE, areaHashSize, areaMemoryBlockSize, Integer.MAX_VALUE, areaMemoryBlockSize, Integer.MAX_VALUE);
        this.lineIdentifierToLineArrayIndex = new LongToLongMap("PackedAtlas - lineIdentifierToLineArrayIndex", Long.MAX_VALUE, lineHashSize, lineMemoryBlockSize, Integer.MAX_VALUE, lineMemoryBlockSize, Integer.MAX_VALUE);
        this.pointIdentifierToPointArrayIndex = new LongToLongMap("PackedAtlas - pointIdentifierToPointArrayIndex", Long.MAX_VALUE, pointHashSize, pointMemoryBlockSize, Integer.MAX_VALUE, pointMemoryBlockSize, Integer.MAX_VALUE);
        this.relationIdentifierToRelationArrayIndex = new LongToLongMap("PackedAtlas - relationIdentifierToRelationArrayIndex", Long.MAX_VALUE, relationHashSize, relationMemoryBlockSize, Integer.MAX_VALUE, relationMemoryBlockSize, Integer.MAX_VALUE);
        this.nodeInEdgesIndices = new LongArrayOfArrays(Integer.MAX_VALUE, nodeMemoryBlockSize, Integer.MAX_VALUE);
        this.nodeOutEdgesIndices = new LongArrayOfArrays(Integer.MAX_VALUE, nodeMemoryBlockSize, Integer.MAX_VALUE);
        this.nodeLocations = new LongArray(Long.MAX_VALUE, nodeMemoryBlockSize, Integer.MAX_VALUE);
        this.nodeTags = new PackedTagStore(Long.MAX_VALUE, nodeMemoryBlockSize, Integer.MAX_VALUE, this.dictionary());
        this.nodeIndexToRelationIndices = new LongToLongMultiMap("PackedAtlas - nodeIndexToRelationIndices", Long.MAX_VALUE, nodeHashSize, nodeMemoryBlockSize, Integer.MAX_VALUE, nodeMemoryBlockSize, nodeHashSize);
        this.edgeStartNodeIndex = new LongArray(Long.MAX_VALUE, edgeMemoryBlockSize, Integer.MAX_VALUE);
        this.edgeEndNodeIndex = new LongArray(Long.MAX_VALUE, edgeMemoryBlockSize, Integer.MAX_VALUE);
        this.edgePolyLines = new PolyLineArray(Long.MAX_VALUE, edgeMemoryBlockSize, Integer.MAX_VALUE);
        this.edgeTags = new PackedTagStore(Long.MAX_VALUE, edgeMemoryBlockSize, Integer.MAX_VALUE, this.dictionary());
        this.edgeIndexToRelationIndices = new LongToLongMultiMap("PackedAtlas - edgeIndexToRelationIndices", Long.MAX_VALUE, edgeHashSize, edgeMemoryBlockSize, Integer.MAX_VALUE, edgeMemoryBlockSize, edgeHashSize);
        this.areaPolygons = new PolygonArray(Long.MAX_VALUE, areaMemoryBlockSize, Integer.MAX_VALUE);
        this.areaTags = new PackedTagStore(Long.MAX_VALUE, areaMemoryBlockSize, Integer.MAX_VALUE, this.dictionary());
        this.areaIndexToRelationIndices = new LongToLongMultiMap("PackedAtlas - areaIndexToRelationIndices", Long.MAX_VALUE, areaHashSize, areaMemoryBlockSize, Integer.MAX_VALUE, areaMemoryBlockSize, areaHashSize);
        this.linePolyLines = new PolyLineArray(Long.MAX_VALUE, lineMemoryBlockSize, Integer.MAX_VALUE);
        this.lineTags = new PackedTagStore(Long.MAX_VALUE, lineMemoryBlockSize, Integer.MAX_VALUE, this.dictionary());
        this.lineIndexToRelationIndices = new LongToLongMultiMap("PackedAtlas - lineIndexToRelationIndices", Long.MAX_VALUE, lineHashSize, lineMemoryBlockSize, Integer.MAX_VALUE, lineMemoryBlockSize, lineHashSize);
        this.pointLocations = new LongArray(Long.MAX_VALUE, pointMemoryBlockSize, Integer.MAX_VALUE);
        this.pointTags = new PackedTagStore(Long.MAX_VALUE, pointMemoryBlockSize, Integer.MAX_VALUE, this.dictionary());
        this.pointIndexToRelationIndices = new LongToLongMultiMap("PackedAtlas - pointIndexToRelationIndices", Long.MAX_VALUE, pointHashSize, pointMemoryBlockSize, Integer.MAX_VALUE, pointMemoryBlockSize, pointHashSize);
        this.relationMemberIndices = new LongArrayOfArrays(Long.MAX_VALUE, relationMemoryBlockSize, Integer.MAX_VALUE);
        this.relationMemberTypes = new ByteArrayOfArrays(Long.MAX_VALUE, relationMemoryBlockSize, Integer.MAX_VALUE);
        this.relationMemberRoles = new IntegerArrayOfArrays(Long.MAX_VALUE, relationMemoryBlockSize, Integer.MAX_VALUE);
        this.relationTags = new PackedTagStore(Long.MAX_VALUE, relationMemoryBlockSize, Integer.MAX_VALUE, this.dictionary());
        this.relationIndexToRelationIndices = new LongToLongMultiMap("PackedAtlas - relationIndexToRelationIndices", Long.MAX_VALUE, relationHashSize, relationMemoryBlockSize, Integer.MAX_VALUE, relationMemoryBlockSize, relationHashSize);
        this.relationOsmIdentifierToRelationIdentifiers = new LongToLongMultiMap("PackedAtlas - relationOsmIdentifierToRelationIdentifier", Long.MAX_VALUE, relationHashSize, relationMemoryBlockSize, Integer.MAX_VALUE, relationMemoryBlockSize, Integer.MAX_VALUE);
        this.relationOsmIdentifiers = new LongArray(Long.MAX_VALUE, relationMemoryBlockSize, Integer.MAX_VALUE);
        this.edgeIdentifiers.setName("PackedAtlas - edgeIdentifiers");
        this.edgeStartNodeIndex.setName("PackedAtlas - edgeStartNodeIndex");
        this.edgeEndNodeIndex.setName("PackedAtlas - edgeEndNodeIndex");
        this.edgePolyLines.setName("PackedAtlas - edgePolyLines");
        this.nodeIdentifiers.setName("PackedAtlas - nodeIdentifiers");
        this.nodeInEdgesIndices.setName("PackedAtlas - nodeInEdgesIndices");
        this.nodeOutEdgesIndices.setName("PackedAtlas - nodeOutEdgesIndices");
        this.nodeLocations.setName("PackedAtlas - nodeLocations");
        this.areaIdentifiers.setName("PackedAtlas - areaIdentifiers");
        this.areaPolygons.setName("PackedAtlas - areaPolygons");
        this.lineIdentifiers.setName("PackedAtlas - lineIdentifiers");
        this.linePolyLines.setName("PackedAtlas - linePolyLines");
        this.pointIdentifiers.setName("PackedAtlas - pointIdentifiers");
        this.pointLocations.setName("PackedAtlas - pointLocations");
        this.relationIdentifiers.setName("PackedAtlas - relationIdentifiers");
        this.relationMemberIndices.setName("PackedAtlas - relationMemberIndices");
        this.relationMemberTypes.setName("PackedAtlas - relationMemberTypes");
        this.relationMemberRoles.setName("PackedAtlas - relationMemberRoles");
        this.relationOsmIdentifiers.setName("PackedAtlas - relationOsmIdentifiers");
    }

    @Override
    public Area area(long identifier) {
        if (this.areaIdentifierToAreaArrayIndex().containsKey(identifier)) {
            return new PackedArea(this, (Long)this.areaIdentifierToAreaArrayIndex().get(identifier));
        }
        return null;
    }

    @Override
    public Iterable<Area> areas() {
        return Iterables.indexBasedIterable(this.areaIdentifiers().size(), index -> new PackedArea(this, index));
    }

    @Override
    public Rectangle bounds() {
        if (this.bounds == null) {
            Iterable<AtlasEntity> boundedEntities = Iterables.filter(this, entity -> entity.bounds() != null);
            this.bounds = Rectangle.forLocated(boundedEntities);
        }
        return this.bounds;
    }

    @Override
    public Edge edge(long identifier) {
        if (this.edgeIdentifierToEdgeArrayIndex().containsKey(identifier)) {
            return new PackedEdge(this, (Long)this.edgeIdentifierToEdgeArrayIndex().get(identifier));
        }
        return null;
    }

    @Override
    public Iterable<Edge> edges() {
        return Iterables.indexBasedIterable(this.edgeIdentifiers().size(), index -> new PackedEdge(this, index));
    }

    public AtlasSerializationFormat getSaveSerializationFormat() {
        return this.saveSerializationFormat;
    }

    public AtlasSerializationFormat getSerializationFormat() {
        return this.loadSerializationFormat;
    }

    @Override
    public Line line(long identifier) {
        if (this.lineIdentifierToLineArrayIndex().containsKey(identifier)) {
            return new PackedLine(this, (Long)this.lineIdentifierToLineArrayIndex().get(identifier));
        }
        return null;
    }

    @Override
    public Iterable<Line> lines() {
        return Iterables.indexBasedIterable(this.lineIdentifiers().size(), index -> new PackedLine(this, index));
    }

    @Override
    public AtlasMetaData metaData() {
        if (this.metaData == null) {
            this.serializer.deserializeIfNeeded(FIELD_META_DATA);
        }
        return this.metaData;
    }

    @Override
    public Node node(long identifier) {
        if (this.nodeIdentifierToNodeArrayIndex().containsKey(identifier)) {
            return new PackedNode(this, (Long)this.nodeIdentifierToNodeArrayIndex().get(identifier));
        }
        return null;
    }

    @Override
    public Iterable<Node> nodes() {
        return Iterables.indexBasedIterable(this.nodeIdentifiers().size(), index -> new PackedNode(this, index));
    }

    @Override
    public long numberOfAreas() {
        return this.areaIdentifiers().size();
    }

    @Override
    public long numberOfEdges() {
        return this.edgeIdentifiers().size();
    }

    @Override
    public long numberOfLines() {
        return this.lineIdentifiers().size();
    }

    @Override
    public long numberOfNodes() {
        return this.nodeIdentifiers().size();
    }

    @Override
    public long numberOfPoints() {
        return this.pointIdentifiers().size();
    }

    @Override
    public long numberOfRelations() {
        return this.relationIdentifiers().size();
    }

    @Override
    public Point point(long identifier) {
        if (this.pointIdentifierToPointArrayIndex().containsKey(identifier)) {
            return new PackedPoint(this, (Long)this.pointIdentifierToPointArrayIndex().get(identifier));
        }
        return null;
    }

    @Override
    public Iterable<Point> points() {
        return Iterables.indexBasedIterable(this.pointIdentifiers().size(), index -> new PackedPoint(this, index));
    }

    @Override
    public Relation relation(long identifier) {
        if (this.relationIdentifierToRelationArrayIndex().containsKey(identifier)) {
            return new PackedRelation(this, (Long)this.relationIdentifierToRelationArrayIndex().get(identifier));
        }
        return null;
    }

    @Override
    public Iterable<Relation> relations() {
        return Iterables.indexBasedIterable(this.relationIdentifiers().size(), index -> new PackedRelation(this, index));
    }

    @Override
    public void save(WritableResource writableResource) {
        new PackedAtlasSerializer(this, writableResource).save();
    }

    public void setSaveSerializationFormat(AtlasSerializationFormat format) {
        this.saveSerializationFormat = format;
    }

    public void trim() {
        logger.info("Trimming Atlas {} to save on space.", (Object)this.getName());
        Time start = Time.now();
        this.edgeIdentifiers.trim();
        this.nodeIdentifiers.trim();
        this.areaIdentifiers.trim();
        this.lineIdentifiers.trim();
        this.pointIdentifiers.trim();
        this.relationIdentifiers.trim();
        this.edgeIdentifierToEdgeArrayIndex.trim();
        this.nodeIdentifierToNodeArrayIndex.trim();
        this.areaIdentifierToAreaArrayIndex.trim();
        this.lineIdentifierToLineArrayIndex.trim();
        this.pointIdentifierToPointArrayIndex.trim();
        this.relationIdentifierToRelationArrayIndex.trim();
        this.nodeLocations.trim();
        this.nodeInEdgesIndices.trim();
        this.nodeOutEdgesIndices.trim();
        this.nodeTags.trim();
        this.nodeIndexToRelationIndices.trim();
        this.edgeStartNodeIndex.trim();
        this.edgeEndNodeIndex.trim();
        this.edgePolyLines.trim();
        this.edgeTags.trim();
        this.edgeIndexToRelationIndices.trim();
        this.areaPolygons.trim();
        this.areaTags.trim();
        this.areaIndexToRelationIndices.trim();
        this.linePolyLines.trim();
        this.lineTags.trim();
        this.lineIndexToRelationIndices.trim();
        this.pointLocations.trim();
        this.pointTags.trim();
        this.pointIndexToRelationIndices.trim();
        this.relationMemberIndices.trim();
        this.relationMemberTypes.trim();
        this.relationMemberRoles.trim();
        this.relationTags.trim();
        this.relationIndexToRelationIndices.trim();
        this.relationOsmIdentifierToRelationIdentifiers.trim();
        this.relationOsmIdentifiers.trim();
        logger.info("Trimmed Atlas {} in {}.", (Object)this.getName(), (Object)start.elapsedSince());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addArea(long areaIdentifier, Polygon polygon, Map<String, String> tags) {
        LongArray longArray = this.areaIdentifiers;
        synchronized (longArray) {
            if (this.areaIdentifierToAreaArrayIndex.containsKey(areaIdentifier)) {
                throw new AtlasIntegrityException("{} with identifier {} already exists.", new Object[]{ItemType.AREA, areaIdentifier});
            }
            long index = this.areaIdentifiers.size();
            this.areaIdentifiers.add(areaIdentifier);
            this.areaIdentifierToAreaArrayIndex.put(areaIdentifier, index);
            this.areaPolygons.add(polygon);
            this.getAsNewAreaSpatialIndex().add(new PackedArea(this, index));
            this.updatePackedTagStore(this.areaTags, index, tags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEdge(long edgeIdentifier, long startNodeIdentifier, long endNodeIdentifier, PolyLine polyline, Map<String, String> tags) {
        LongArray longArray = this.edgeIdentifiers;
        synchronized (longArray) {
            if (this.edgeIdentifierToEdgeArrayIndex.containsKey(edgeIdentifier)) {
                throw new AtlasIntegrityException("{} with identifier {} already exists.", new Object[]{ItemType.EDGE, edgeIdentifier});
            }
            long index = this.edgeIdentifiers.size();
            this.edgeIdentifiers.add(edgeIdentifier);
            this.edgeIdentifierToEdgeArrayIndex.put(edgeIdentifier, index);
            this.edgePolyLines.add(polyline);
            long startNodeIndex = (Long)this.nodeIdentifierToNodeArrayIndex.get(startNodeIdentifier);
            this.edgeStartNodeIndex.add(startNodeIndex);
            long endNodeIndex = (Long)this.nodeIdentifierToNodeArrayIndex.get(endNodeIdentifier);
            this.edgeEndNodeIndex.add(endNodeIndex);
            this.updateNodeEdgesReference(endNodeIndex, this.nodeInEdgesIndices, index);
            this.updateNodeEdgesReference(startNodeIndex, this.nodeOutEdgesIndices, index);
            this.getAsNewEdgeSpatialIndex().add(new PackedEdge(this, index));
            this.updatePackedTagStore(this.edgeTags, index, tags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addLine(long lineIdentifier, PolyLine polyline, Map<String, String> tags) {
        LongArray longArray = this.lineIdentifiers;
        synchronized (longArray) {
            if (this.lineIdentifierToLineArrayIndex.containsKey(lineIdentifier)) {
                throw new AtlasIntegrityException("{} with identifier {} already exists.", new Object[]{ItemType.LINE, lineIdentifier});
            }
            long index = this.lineIdentifiers.size();
            this.lineIdentifiers.add(lineIdentifier);
            this.lineIdentifierToLineArrayIndex.put(lineIdentifier, index);
            this.linePolyLines.add(polyline);
            this.getAsNewLineSpatialIndex().add(new PackedLine(this, index));
            this.updatePackedTagStore(this.lineTags, index, tags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNode(long nodeIdentifier, Location location, Map<String, String> tags) {
        LongArray longArray = this.nodeIdentifiers;
        synchronized (longArray) {
            if (this.nodeIdentifierToNodeArrayIndex.containsKey(nodeIdentifier)) {
                throw new AtlasIntegrityException("{} with identifier {} already exists.", new Object[]{ItemType.NODE, nodeIdentifier});
            }
            long index = this.nodeIdentifiers.size();
            this.nodeIdentifiers.add(nodeIdentifier);
            this.nodeIdentifierToNodeArrayIndex.put(nodeIdentifier, index);
            this.nodeLocations.add(location.asConcatenation());
            this.nodeInEdgesIndices.add(new long[0]);
            this.nodeOutEdgesIndices.add(new long[0]);
            this.getAsNewNodeSpatialIndex().add(new PackedNode(this, index));
            this.updatePackedTagStore(this.nodeTags, index, tags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPoint(long pointIdentifier, Location location, Map<String, String> tags) {
        LongArray longArray = this.pointIdentifiers;
        synchronized (longArray) {
            if (this.pointIdentifierToPointArrayIndex.containsKey(pointIdentifier)) {
                throw new AtlasIntegrityException("{} with identifier {} already exists.", new Object[]{ItemType.POINT, pointIdentifier});
            }
            long index = this.pointIdentifiers.size();
            this.pointIdentifiers.add(pointIdentifier);
            this.pointIdentifierToPointArrayIndex.put(pointIdentifier, index);
            this.pointLocations.add(location.asConcatenation());
            this.getAsNewPointSpatialIndex().add(new PackedPoint(this, index));
            this.updatePackedTagStore(this.pointTags, index, tags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRelation(long relationIdentifier, long relationOsmIdentifier, List<Long> identifiers, List<ItemType> types, List<String> roles, Map<String, String> tags) {
        if (identifiers.size() != types.size() || types.size() != roles.size()) {
            throw new AtlasIntegrityException("Different sizes for relation identifiers and types and roles.");
        }
        if (identifiers.isEmpty()) {
            throw new AtlasIntegrityException("Cannot add the relation {} with no members", relationIdentifier);
        }
        if (identifiers.stream().anyMatch(Objects::isNull)) {
            throw new AtlasIntegrityException("Cannot have a relation with null members.");
        }
        LongArray longArray = this.relationIdentifiers;
        synchronized (longArray) {
            if (this.relationIdentifierToRelationArrayIndex.containsKey(relationIdentifier)) {
                throw new AtlasIntegrityException("{} with identifier {} already exists.", new Object[]{ItemType.RELATION, relationIdentifier});
            }
            long index = this.relationIdentifiers.size();
            this.relationIdentifiers.add(relationIdentifier);
            this.relationIdentifierToRelationArrayIndex.put(relationIdentifier, index);
            this.relationOsmIdentifierToRelationIdentifiers.add(relationOsmIdentifier, relationIdentifier);
            this.relationOsmIdentifiers.add(relationOsmIdentifier);
            long[] memberIndices = new long[identifiers.size()];
            byte[] typeValues = new byte[types.size()];
            int[] roleValues = new int[roles.size()];
            block11: for (int i = 0; i < identifiers.size(); ++i) {
                ItemType type = types.get(i);
                typeValues[i] = (byte)type.getValue();
                roleValues[i] = this.dictionary.add(roles.get(i));
                Long memberIdentifier = identifiers.get(i);
                switch (type) {
                    case NODE: {
                        this.addRelationMember("Node", index, memberIdentifier, i, memberIndices, this.nodeIdentifierToNodeArrayIndex, this.nodeIndexToRelationIndices);
                        continue block11;
                    }
                    case EDGE: {
                        this.addRelationMember("Edge", index, memberIdentifier, i, memberIndices, this.edgeIdentifierToEdgeArrayIndex, this.edgeIndexToRelationIndices);
                        continue block11;
                    }
                    case AREA: {
                        this.addRelationMember("Area", index, memberIdentifier, i, memberIndices, this.areaIdentifierToAreaArrayIndex, this.areaIndexToRelationIndices);
                        continue block11;
                    }
                    case LINE: {
                        this.addRelationMember("Line", index, memberIdentifier, i, memberIndices, this.lineIdentifierToLineArrayIndex, this.lineIndexToRelationIndices);
                        continue block11;
                    }
                    case POINT: {
                        this.addRelationMember("Point", index, memberIdentifier, i, memberIndices, this.pointIdentifierToPointArrayIndex, this.pointIndexToRelationIndices);
                        continue block11;
                    }
                    case RELATION: {
                        this.addRelationMember("Relation", index, memberIdentifier, i, memberIndices, this.relationIdentifierToRelationArrayIndex, this.relationIndexToRelationIndices);
                        continue block11;
                    }
                    default: {
                        throw new CoreException("Cannot recognize ItemType {}", new Object[]{type});
                    }
                }
            }
            this.relationMemberTypes.add(typeValues);
            this.relationMemberIndices.add(memberIndices);
            this.relationMemberRoles.add(roleValues);
            this.updatePackedTagStore(this.relationTags, index, tags);
        }
    }

    protected long areaIdentifier(long index) {
        return (Long)this.areaIdentifiers().get(index);
    }

    protected Polygon areaPolygon(long index) {
        return (Polygon)this.areaPolygons().get(index);
    }

    protected Set<Relation> areaRelations(long index) {
        return this.itemRelations((long[])this.areaIndexToRelationIndices().get(index));
    }

    protected Map<String, String> areaTags(long index) {
        return this.areaTags().keyValuePairs(index);
    }

    protected Node edgeEndNode(long index) {
        return new PackedNode(this, (Long)this.edgeEndNodeIndex().get(index));
    }

    protected long edgeIdentifier(long index) {
        return (Long)this.edgeIdentifiers().get(index);
    }

    protected PolyLine edgePolyLine(long index) {
        return (PolyLine)this.edgePolyLines().get(index);
    }

    protected Set<Relation> edgeRelations(long index) {
        return this.itemRelations((long[])this.edgeIndexToRelationIndices().get(index));
    }

    protected Node edgeStartNode(long index) {
        return new PackedNode(this, (Long)this.edgeStartNodeIndex().get(index));
    }

    protected Map<String, String> edgeTags(long index) {
        return this.edgeTags().keyValuePairs(index);
    }

    protected AtlasSerializationFormat getLoadSerializationFormat() {
        return this.loadSerializationFormat;
    }

    protected Optional<PackedAtlasSerializer> getSerializer() {
        return Optional.ofNullable(this.serializer);
    }

    protected boolean isEmpty() {
        return this.nodeIdentifiers().isEmpty() && this.edgeIdentifiers().isEmpty() && this.areaIdentifiers().isEmpty() && this.lineIdentifiers().isEmpty() && this.pointIdentifiers().isEmpty() && this.relationIdentifiers().isEmpty();
    }

    protected long lineIdentifier(long index) {
        return (Long)this.lineIdentifiers().get(index);
    }

    protected PolyLine linePolyLine(long index) {
        return (PolyLine)this.linePolyLines().get(index);
    }

    protected Set<Relation> lineRelations(long index) {
        return this.itemRelations((long[])this.lineIndexToRelationIndices().get(index));
    }

    protected Map<String, String> lineTags(long index) {
        return this.lineTags().keyValuePairs(index);
    }

    protected long nodeIdentifier(long index) {
        return (Long)this.nodeIdentifiers().get(index);
    }

    protected Long nodeIdentifierForEnlargedLocation(Location location, Distance searchDistance, Distance toleranceDistance) {
        Rectangle locationBounds = location.bounds().expand(searchDistance);
        this.buildNodeSpatialIndexIfNecessary();
        TreeSet nodes = new TreeSet((node1, node2) -> {
            Distance distance1 = location.distanceTo(node1.getLocation());
            Distance distance2 = location.distanceTo(node2.getLocation());
            double difference = distance2.asMillimeters() - distance1.asMillimeters();
            if (difference > 0.0) {
                return 1;
            }
            if (difference < 0.0) {
                return -1;
            }
            return 0;
        });
        this.getNodeSpatialIndex().get(locationBounds).forEach(nodes::add);
        for (Node candidate : nodes) {
            Distance distance = location.distanceTo(candidate.getLocation());
            if (!distance.isLessThanOrEqualTo(toleranceDistance)) continue;
            return candidate.getIdentifier();
        }
        return null;
    }

    protected Long nodeIdentifierForLocation(Location location) {
        this.buildNodeSpatialIndexIfNecessary();
        Rectangle locationBounds = location.bounds();
        TreeSet nodesByAscendingIdentifier = new TreeSet((node1, node2) -> {
            if (node1.getIdentifier() < node2.getIdentifier()) {
                return -1;
            }
            if (node1.getIdentifier() > node2.getIdentifier()) {
                return 1;
            }
            return 0;
        });
        this.getNodeSpatialIndex().get(locationBounds).forEach(nodesByAscendingIdentifier::add);
        if (!nodesByAscendingIdentifier.isEmpty()) {
            return ((Node)nodesByAscendingIdentifier.first()).getIdentifier();
        }
        return null;
    }

    protected SortedSet<Edge> nodeInEdges(long index) {
        TreeSet<Edge> result = new TreeSet<Edge>();
        for (long edgeIndex : (long[])this.nodeInEdgesIndices().get(index)) {
            result.add(new PackedEdge(this, edgeIndex));
        }
        return result;
    }

    protected Location nodeLocation(long index) {
        return new Location((Long)this.nodeLocations().get(index));
    }

    protected SortedSet<Edge> nodeOutEdges(long index) {
        TreeSet<Edge> result = new TreeSet<Edge>();
        for (long edgeIndex : (long[])this.nodeOutEdgesIndices().get(index)) {
            result.add(new PackedEdge(this, edgeIndex));
        }
        return result;
    }

    protected Set<Relation> nodeRelations(long index) {
        return this.itemRelations((long[])this.nodeIndexToRelationIndices().get(index));
    }

    protected Map<String, String> nodeTags(long index) {
        return this.nodeTags().keyValuePairs(index);
    }

    protected long pointIdentifier(long index) {
        return (Long)this.pointIdentifiers().get(index);
    }

    protected Location pointLocation(long index) {
        return new Location((Long)this.pointLocations().get(index));
    }

    protected Set<Relation> pointRelations(long index) {
        return this.itemRelations((long[])this.pointIndexToRelationIndices().get(index));
    }

    protected Map<String, String> pointTags(long index) {
        return this.pointTags().keyValuePairs(index);
    }

    protected RelationMemberList relationAllKnownOsmMembers(long index) {
        ArrayList<RelationMember> result = new ArrayList<RelationMember>();
        for (long candidateIdentifier : (long[])this.relationOsmIdentifierToRelationIdentifiers().get(this.relationOsmIdentifier(index))) {
            long candidateIndex = (Long)this.relationIdentifierToRelationArrayIndex().get(candidateIdentifier);
            result.addAll(this.relationMembers(candidateIndex));
        }
        return new RelationMemberList(result);
    }

    protected List<Relation> relationAllRelationsWithSameOsmIdentifier(long index) {
        ArrayList<Relation> result = new ArrayList<Relation>();
        for (long candidateIdentifier : (long[])this.relationOsmIdentifierToRelationIdentifiers().get(this.relationOsmIdentifier(index))) {
            long candidateIndex = (Long)this.relationIdentifierToRelationArrayIndex().get(candidateIdentifier);
            result.add(new PackedRelation(this, candidateIndex));
        }
        return result;
    }

    protected long relationIdentifier(long index) {
        return (Long)this.relationIdentifiers().get(index);
    }

    protected RelationMemberList relationMembers(long index) {
        TreeSet<RelationMember> result = new TreeSet<RelationMember>();
        int arrayIndex = 0;
        for (byte typeValue : (byte[])this.relationMemberTypes().get(index)) {
            AtlasEntity entity;
            ItemType type = ItemType.forValue(typeValue);
            long memberIndex = ((long[])this.relationMemberIndices().get(index))[arrayIndex];
            String role = this.dictionary().word(((int[])this.relationMemberRoles().get(index))[arrayIndex]);
            switch (type) {
                case NODE: {
                    entity = new PackedNode(this, memberIndex);
                    break;
                }
                case EDGE: {
                    entity = new PackedEdge(this, memberIndex);
                    break;
                }
                case AREA: {
                    entity = new PackedArea(this, memberIndex);
                    break;
                }
                case LINE: {
                    entity = new PackedLine(this, memberIndex);
                    break;
                }
                case POINT: {
                    entity = new PackedPoint(this, memberIndex);
                    break;
                }
                case RELATION: {
                    entity = new PackedRelation(this, memberIndex);
                    break;
                }
                default: {
                    throw new CoreException("Invalid member type {}", new Object[]{type});
                }
            }
            result.add(new RelationMember(role, entity, this.relationIdentifier(index)));
            ++arrayIndex;
        }
        return new RelationMemberList(result);
    }

    protected long relationOsmIdentifier(long index) {
        return (Long)this.relationOsmIdentifiers().get(index);
    }

    protected Set<Relation> relationRelations(long index) {
        return this.itemRelations((long[])this.relationIndexToRelationIndices().get(index));
    }

    protected Map<String, String> relationTags(long index) {
        return this.relationTags().keyValuePairs(index);
    }

    protected void setLoadSerializationFormat(AtlasSerializationFormat loadFormat) {
        this.loadSerializationFormat = loadFormat;
    }

    protected void setMetaData(AtlasMetaData metaData) {
        this.metaData = metaData;
    }

    @Override
    protected void setName(String name) {
        super.setName(name);
    }

    private void addRelationMember(String type, long relationIndex, Long memberIdentifier, int relationMemberListIndex, long[] relationMemberIndexArray, LongToLongMap memberIdentifierToArrayIndex, LongToLongMultiMap memberIndicesToRelationIndices) {
        if (!memberIdentifierToArrayIndex.containsKey(memberIdentifier)) {
            throw new AtlasIntegrityException("The {} {} does not exist for relation {}.", type, memberIdentifier, this.relationIdentifiers.get(relationIndex));
        }
        relationMemberIndexArray[relationMemberListIndex] = (Long)memberIdentifierToArrayIndex.get(memberIdentifier);
        memberIndicesToRelationIndices.add(relationMemberIndexArray[relationMemberListIndex], relationIndex);
    }

    private LongToLongMap areaIdentifierToAreaArrayIndex() {
        return this.deserializedIfNeeded(() -> this.areaIdentifierToAreaArrayIndex, FIELD_AREA_IDENTIFIER_TO_AREA_ARRAY_INDEX_LOCK, FIELD_AREA_IDENTIFIER_TO_AREA_ARRAY_INDEX);
    }

    private LongArray areaIdentifiers() {
        return this.deserializedIfNeeded(() -> this.areaIdentifiers, FIELD_AREA_IDENTIFIERS_LOCK, FIELD_AREA_IDENTIFIERS);
    }

    private LongToLongMultiMap areaIndexToRelationIndices() {
        return this.deserializedIfNeeded(() -> this.areaIndexToRelationIndices, FIELD_AREA_INDEX_TO_RELATION_INDICES_LOCK, FIELD_AREA_INDEX_TO_RELATION_INDICES);
    }

    private PolygonArray areaPolygons() {
        return this.deserializedIfNeeded(() -> this.areaPolygons, FIELD_AREA_POLYGONS_LOCK, FIELD_AREA_POLYGONS);
    }

    private PackedTagStore areaTags() {
        return this.deserializedIfNeeded(() -> this.areaTags, tags -> tags.setDictionary(this.dictionary()), FIELD_AREA_TAGS_LOCK, FIELD_AREA_TAGS);
    }

    private <T> T deserializedIfNeeded(Supplier<T> supplier, Object lock, String fieldName) {
        return this.deserializedIfNeeded(supplier, null, lock, fieldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T deserializedIfNeeded(Supplier<T> supplier, Consumer<T> consumer, Object lock, String fieldName) {
        if (supplier.get() == null) {
            Object object = lock;
            synchronized (object) {
                if (supplier.get() == null) {
                    this.serializer.deserializeIfNeeded(fieldName);
                }
            }
        }
        if (consumer != null) {
            consumer.accept(supplier.get());
        }
        return supplier.get();
    }

    private IntegerDictionary<String> dictionary() {
        return this.deserializedIfNeeded(() -> this.dictionary, FIELD_DICTIONARY_LOCK, FIELD_DICTIONARY);
    }

    private LongArray edgeEndNodeIndex() {
        return this.deserializedIfNeeded(() -> this.edgeEndNodeIndex, FIELD_EDGE_END_NODE_INDEX_LOCK, FIELD_EDGE_END_NODE_INDEX);
    }

    private LongToLongMap edgeIdentifierToEdgeArrayIndex() {
        return this.deserializedIfNeeded(() -> this.edgeIdentifierToEdgeArrayIndex, FIELD_EDGE_IDENTIFIER_TO_EDGE_ARRAY_INDEX_LOCK, FIELD_EDGE_IDENTIFIER_TO_EDGE_ARRAY_INDEX);
    }

    private LongArray edgeIdentifiers() {
        return this.deserializedIfNeeded(() -> this.edgeIdentifiers, FIELD_EDGE_IDENTIFIERS_LOCK, FIELD_EDGE_IDENTIFIERS);
    }

    private LongToLongMultiMap edgeIndexToRelationIndices() {
        return this.deserializedIfNeeded(() -> this.edgeIndexToRelationIndices, FIELD_EDGE_INDEX_TO_RELATION_INDICES_LOCK, FIELD_EDGE_INDEX_TO_RELATION_INDICES);
    }

    private PolyLineArray edgePolyLines() {
        return this.deserializedIfNeeded(() -> this.edgePolyLines, FIELD_EDGE_POLY_LINES_LOCK, FIELD_EDGE_POLY_LINES);
    }

    private LongArray edgeStartNodeIndex() {
        return this.deserializedIfNeeded(() -> this.edgeStartNodeIndex, FIELD_EDGE_START_NODE_INDEX_LOCK, FIELD_EDGE_START_NODE_INDEX);
    }

    private PackedTagStore edgeTags() {
        return this.deserializedIfNeeded(() -> this.edgeTags, tags -> tags.setDictionary(this.dictionary()), FIELD_EDGE_TAGS_LOCK, FIELD_EDGE_TAGS);
    }

    private Set<Relation> itemRelations(long[] relationIndices) {
        LinkedHashSet<Relation> result = new LinkedHashSet<Relation>();
        if (relationIndices == null) {
            return result;
        }
        for (long relationIndex : relationIndices) {
            result.add(new PackedRelation(this, relationIndex));
        }
        return result;
    }

    private LongToLongMap lineIdentifierToLineArrayIndex() {
        return this.deserializedIfNeeded(() -> this.lineIdentifierToLineArrayIndex, FIELD_LINE_IDENTIFIER_TO_LINE_ARRAY_INDEX_LOCK, FIELD_LINE_IDENTIFIER_TO_LINE_ARRAY_INDEX);
    }

    private LongArray lineIdentifiers() {
        return this.deserializedIfNeeded(() -> this.lineIdentifiers, FIELD_LINE_IDENTIFIERS_LOCK, FIELD_LINE_IDENTIFIERS);
    }

    private LongToLongMultiMap lineIndexToRelationIndices() {
        return this.deserializedIfNeeded(() -> this.lineIndexToRelationIndices, FIELD_LINE_INDEX_TO_RELATION_INDICES_LOCK, FIELD_LINE_INDEX_TO_RELATION_INDICES);
    }

    private PolyLineArray linePolyLines() {
        return this.deserializedIfNeeded(() -> this.linePolyLines, FIELD_LINE_POLYLINES_LOCK, FIELD_LINE_POLYLINES);
    }

    private PackedTagStore lineTags() {
        return this.deserializedIfNeeded(() -> this.lineTags, tags -> tags.setDictionary(this.dictionary()), FIELD_LINE_TAGS_LOCK, FIELD_LINE_TAGS);
    }

    private PackedTagStore newPackedTagStore(long maximumSize, int memoryBlockSize, int subArraySize) {
        return new PackedTagStore(maximumSize, memoryBlockSize, subArraySize, this.dictionary()){
            private static final long serialVersionUID = 5959934069025112665L;
        };
    }

    private LongToLongMap nodeIdentifierToNodeArrayIndex() {
        return this.deserializedIfNeeded(() -> this.nodeIdentifierToNodeArrayIndex, FIELD_NODE_IDENTIFIER_TO_NODE_ARRAY_INDEX_LOCK, FIELD_NODE_IDENTIFIER_TO_NODE_ARRAY_INDEX);
    }

    private LongArray nodeIdentifiers() {
        return this.deserializedIfNeeded(() -> this.nodeIdentifiers, FIELD_NODE_IDENTIFIERS_LOCK, FIELD_NODE_IDENTIFIERS);
    }

    private LongArrayOfArrays nodeInEdgesIndices() {
        return this.deserializedIfNeeded(() -> this.nodeInEdgesIndices, FIELD_NODE_IN_EDGES_INDICES_LOCK, FIELD_NODE_IN_EDGES_INDICES);
    }

    private LongToLongMultiMap nodeIndexToRelationIndices() {
        return this.deserializedIfNeeded(() -> this.nodeIndexToRelationIndices, FIELD_NODE_INDEX_TO_RELATION_INDICES_LOCK, FIELD_NODE_INDEX_TO_RELATION_INDICES);
    }

    private LongArray nodeLocations() {
        return this.deserializedIfNeeded(() -> this.nodeLocations, FIELD_NODE_LOCATIONS_LOCK, FIELD_NODE_LOCATIONS);
    }

    private LongArrayOfArrays nodeOutEdgesIndices() {
        return this.deserializedIfNeeded(() -> this.nodeOutEdgesIndices, FIELD_NODE_OUT_EDGES_INDICES_LOCK, FIELD_NODE_OUT_EDGES_INDICES);
    }

    private PackedTagStore nodeTags() {
        return this.deserializedIfNeeded(() -> this.nodeTags, tags -> tags.setDictionary(this.dictionary()), FIELD_NODE_TAGS_LOCK, FIELD_NODE_TAGS);
    }

    private LongToLongMap pointIdentifierToPointArrayIndex() {
        return this.deserializedIfNeeded(() -> this.pointIdentifierToPointArrayIndex, FIELD_POINT_IDENTIFIER_TO_POINT_ARRAY_INDEX_LOCK, FIELD_POINT_IDENTIFIER_TO_POINT_ARRAY_INDEX);
    }

    private LongArray pointIdentifiers() {
        return this.deserializedIfNeeded(() -> this.pointIdentifiers, FIELD_POINT_IDENTIFIERS_LOCK, FIELD_POINT_IDENTIFIERS);
    }

    private LongToLongMultiMap pointIndexToRelationIndices() {
        return this.deserializedIfNeeded(() -> this.pointIndexToRelationIndices, FIELD_POINT_INDEX_TO_RELATION_INDICES_LOCK, FIELD_POINT_INDEX_TO_RELATION_INDICES);
    }

    private LongArray pointLocations() {
        return this.deserializedIfNeeded(() -> this.pointLocations, FIELD_POINT_LOCATIONS_LOCK, FIELD_POINT_LOCATIONS);
    }

    private PackedTagStore pointTags() {
        return this.deserializedIfNeeded(() -> this.pointTags, tags -> tags.setDictionary(this.dictionary()), FIELD_POINT_TAGS_LOCK, FIELD_POINT_TAGS);
    }

    private LongToLongMap relationIdentifierToRelationArrayIndex() {
        return this.deserializedIfNeeded(() -> this.relationIdentifierToRelationArrayIndex, FIELD_RELATION_IDENTIFIER_TO_RELATION_ARRAY_INDEX_LOCK, FIELD_RELATION_IDENTIFIER_TO_RELATION_ARRAY_INDEX);
    }

    private LongArray relationIdentifiers() {
        return this.deserializedIfNeeded(() -> this.relationIdentifiers, FIELD_RELATION_IDENTIFIERS_LOCK, FIELD_RELATION_IDENTIFIERS);
    }

    private LongToLongMultiMap relationIndexToRelationIndices() {
        return this.deserializedIfNeeded(() -> this.relationIndexToRelationIndices, FIELD_RELATION_INDEX_TO_RELATION_INDICES_LOCK, FIELD_RELATION_INDEX_TO_RELATION_INDICES);
    }

    private LongArrayOfArrays relationMemberIndices() {
        return this.deserializedIfNeeded(() -> this.relationMemberIndices, FIELD_RELATION_MEMBERS_INDICES_LOCK, FIELD_RELATION_MEMBERS_INDICES);
    }

    private IntegerArrayOfArrays relationMemberRoles() {
        return this.deserializedIfNeeded(() -> this.relationMemberRoles, FIELD_RELATION_MEMBER_ROLES_LOCK, FIELD_RELATION_MEMBER_ROLES);
    }

    private ByteArrayOfArrays relationMemberTypes() {
        return this.deserializedIfNeeded(() -> this.relationMemberTypes, FIELD_RELATION_MEMBER_TYPES_LOCK, FIELD_RELATION_MEMBER_TYPES);
    }

    private LongToLongMultiMap relationOsmIdentifierToRelationIdentifiers() {
        return this.deserializedIfNeeded(() -> this.relationOsmIdentifierToRelationIdentifiers, FIELD_RELATION_OSM_IDENTIFIER_TO_RELATION_IDENTIFIERS_LOCK, FIELD_RELATION_OSM_IDENTIFIER_TO_RELATION_IDENTIFIERS);
    }

    private LongArray relationOsmIdentifiers() {
        return this.deserializedIfNeeded(() -> this.relationOsmIdentifiers, FIELD_RELATION_OSM_IDENTIFIERS_LOCK, FIELD_RELATION_OSM_IDENTIFIERS);
    }

    private PackedTagStore relationTags() {
        return this.deserializedIfNeeded(() -> this.relationTags, tags -> tags.setDictionary(this.dictionary()), FIELD_RELATION_TAGS_LOCK, FIELD_RELATION_TAGS);
    }

    private void updateNodeEdgesReference(long nodeIndex, LongArrayOfArrays nodeEdgesIndices, long edgeIndex) {
        long[] nodeEdges = (long[])nodeEdgesIndices.get(nodeIndex);
        long[] newNodeEdges = new long[nodeEdges.length + 1];
        for (int i = 0; i < nodeEdges.length; ++i) {
            newNodeEdges[i] = nodeEdges[i];
        }
        newNodeEdges[newNodeEdges.length - 1] = edgeIndex;
        nodeEdgesIndices.set(nodeIndex, newNodeEdges);
    }

    private void updatePackedTagStore(PackedTagStore packedTagStore, long index, Map<String, String> tags) {
        if (tags.isEmpty()) {
            packedTagStore.add(index, null, null);
        } else {
            for (Map.Entry<String, String> entry : tags.entrySet()) {
                packedTagStore.add(index, entry.getKey(), entry.getValue());
            }
        }
    }

    public static enum AtlasSerializationFormat {
        PROTOBUF,
        JAVA;

    }
}

