/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.water.finder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.complex.Finder;
import org.openstreetmap.atlas.geography.atlas.items.complex.water.ComplexWaterEntity;
import org.openstreetmap.atlas.geography.atlas.items.complex.water.WaterType;
import org.openstreetmap.atlas.geography.atlas.items.complex.water.finder.DefaultWaterConfigurationReader;
import org.openstreetmap.atlas.geography.atlas.items.complex.water.finder.WaterConfigurationReader;
import org.openstreetmap.atlas.tags.RelationTypeTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplexWaterEntityFinder
implements Finder<ComplexWaterEntity> {
    private static final Predicate<Relation> RELATION_FILTER = relation -> Validators.isOfType((Taggable)relation, RelationTypeTag.class, (Enum[])new RelationTypeTag[]{RelationTypeTag.MULTIPOLYGON, RelationTypeTag.BOUNDARY, RelationTypeTag.WATERWAY});
    private static final Logger logger = LoggerFactory.getLogger(ComplexWaterEntityFinder.class);
    private final List<WaterConfigurationReader> waterConfigurationReaders;

    public ComplexWaterEntityFinder() {
        this.waterConfigurationReaders = new ArrayList<WaterConfigurationReader>();
        this.waterConfigurationReaders.add(new DefaultWaterConfigurationReader("lake.json", WaterType.LAKE));
        this.waterConfigurationReaders.add(new DefaultWaterConfigurationReader("river.json", WaterType.RIVER));
        this.waterConfigurationReaders.add(new DefaultWaterConfigurationReader("lagoon.json", WaterType.LAGOON));
        this.waterConfigurationReaders.add(new DefaultWaterConfigurationReader("wetland.json", WaterType.WETLAND));
        this.waterConfigurationReaders.add(new DefaultWaterConfigurationReader("reservoir.json", WaterType.RESERVOIR));
        this.waterConfigurationReaders.add(new DefaultWaterConfigurationReader("pool.json", WaterType.POOL));
        this.waterConfigurationReaders.add(new DefaultWaterConfigurationReader("pond.json", WaterType.POND));
        this.waterConfigurationReaders.add(new DefaultWaterConfigurationReader("harbour.json", WaterType.HARBOUR));
        this.waterConfigurationReaders.add(new DefaultWaterConfigurationReader("canal.json", WaterType.CANAL));
        this.waterConfigurationReaders.add(new DefaultWaterConfigurationReader("creek.json", WaterType.CREEK));
        this.waterConfigurationReaders.add(new DefaultWaterConfigurationReader("ditch.json", WaterType.DITCH));
    }

    public ComplexWaterEntityFinder(WaterConfigurationReader ... waterConfigurationReaders) {
        this.waterConfigurationReaders = Arrays.asList(waterConfigurationReaders);
    }

    @Override
    public Iterable<ComplexWaterEntity> find(Atlas atlas) {
        Stream<Line> lineStream = StreamSupport.stream(atlas.lines().spliterator(), false);
        Stream<Area> areaStream = StreamSupport.stream(atlas.areas().spliterator(), false);
        Stream<Relation> relationStream = StreamSupport.stream(atlas.relations(RELATION_FILTER).spliterator(), false);
        return Stream.concat(Stream.concat(lineStream, areaStream), relationStream).map(x$0 -> this.processEntity((AtlasEntity)x$0)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public List<WaterConfigurationReader> getWaterConfigurationReaders() {
        return this.waterConfigurationReaders;
    }

    public Optional<ComplexWaterEntity> processEntity(AtlasEntity atlasEntity) {
        List complexWaterEntities = this.waterConfigurationReaders.stream().map(waterConfigurationReader -> waterConfigurationReader.convert(atlasEntity)).filter(Optional::isPresent).map(Optional::get).filter(object -> object instanceof ComplexWaterEntity).map(object -> (ComplexWaterEntity)object).collect(Collectors.toList());
        if (complexWaterEntities.isEmpty()) {
            logger.error("AtlasEntity: {} did not match any water type filters", (Object)atlasEntity);
            return Optional.empty();
        }
        if (complexWaterEntities.size() > 1) {
            String matchedWaterBodies = complexWaterEntities.stream().map(ComplexWaterEntity::getWaterType).map(WaterType::toString).collect(Collectors.joining(","));
            logger.error("Skipping AtlasEnity : {} as it got mapped to {}", (Object)atlasEntity, (Object)matchedWaterBodies);
            return Optional.empty();
        }
        return Optional.of((ComplexWaterEntity)complexWaterEntities.get(0));
    }
}

