/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.water;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.complex.water.ComplexWaterEntity;
import org.openstreetmap.atlas.geography.atlas.items.complex.water.ComplexWaterbody;
import org.openstreetmap.atlas.geography.atlas.items.complex.water.WaterType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplexWaterway
extends ComplexWaterEntity {
    private static final long serialVersionUID = -5567739097914423531L;
    private static final Logger logger = LoggerFactory.getLogger(ComplexWaterway.class);
    private PolyLine geometry;

    public ComplexWaterway(AtlasEntity source, WaterType type) {
        super(source, type);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ComplexWaterbody) {
            ComplexWaterbody that = (ComplexWaterbody)other;
            return new EqualsBuilder().append((Object)this.getWaterType(), (Object)that.getWaterType()).append(this.getSource(), that.getSource()).append(this.getGeometry().toWkt(), that.getGeometry().toWkt()).build();
        }
        return false;
    }

    public PolyLine getGeometry() {
        return this.geometry;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(this.getSource()).append((Object)this.getWaterType()).append(this.getGeometry().toWkb()).build();
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected void populateGeometry() {
        AtlasEntity source = this.getSource();
        if (source instanceof Line) {
            Line line = (Line)source;
            this.geometry = line.asPolyLine();
            return;
        }
        throw new CoreException("Geometry is not set for {}", source);
    }
}

