/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.water;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.complex.RelationOrAreaToMultiPolygonConverter;
import org.openstreetmap.atlas.geography.atlas.items.complex.water.ComplexWaterEntity;
import org.openstreetmap.atlas.geography.atlas.items.complex.water.WaterType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplexWaterbody
extends ComplexWaterEntity {
    private static final long serialVersionUID = -666543090371777011L;
    private static final RelationOrAreaToMultiPolygonConverter RELATION_OR_AREA_TO_MULTI_POLYGON_CONVERTER = new RelationOrAreaToMultiPolygonConverter();
    private static final Logger logger = LoggerFactory.getLogger(ComplexWaterbody.class);
    private MultiPolygon geometry;

    public ComplexWaterbody(AtlasEntity source, WaterType type) {
        super(source, type);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ComplexWaterbody) {
            ComplexWaterbody that = (ComplexWaterbody)other;
            return new EqualsBuilder().append((Object)this.getWaterType(), (Object)that.getWaterType()).append(this.getSource(), that.getSource()).append(this.getGeometry().toWkt(), that.getGeometry().toWkt()).build();
        }
        return false;
    }

    public MultiPolygon getGeometry() {
        return this.geometry;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(this.getSource()).append((Object)this.getWaterType()).append(this.getGeometry().toWkb()).build();
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected void populateGeometry() {
        Relation relation;
        String type;
        AtlasEntity source = this.getSource();
        if (source instanceof Area) {
            this.geometry = RELATION_OR_AREA_TO_MULTI_POLYGON_CONVERTER.convert(source);
            return;
        }
        if (source instanceof Relation && "multipolygon".equals(type = (relation = (Relation)source).tag("type"))) {
            this.geometry = RELATION_OR_AREA_TO_MULTI_POLYGON_CONVERTER.convert(relation);
            return;
        }
        throw new CoreException("Geometry is not set for {}", source);
    }
}

