/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.water;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.complex.ComplexEntity;
import org.openstreetmap.atlas.geography.atlas.items.complex.water.WaterType;
import org.slf4j.Logger;

public abstract class ComplexWaterEntity
extends ComplexEntity {
    private static final long serialVersionUID = 7835788819725148174L;
    private final WaterType waterType;

    public ComplexWaterEntity(AtlasEntity source, WaterType waterType) {
        super(source);
        this.waterType = waterType;
        try {
            this.populateGeometry();
        }
        catch (Exception e) {
            this.getLogger().warn("Unable to create complex water entity from {}", (Object)source, (Object)e);
            this.setInvalidReason("Unable to create complex water entity", e);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ComplexWaterEntity) {
            ComplexWaterEntity that = (ComplexWaterEntity)other;
            return new EqualsBuilder().append((Object)this.waterType, (Object)that.waterType).append(this.getSource(), that.getSource()).build();
        }
        return false;
    }

    public WaterType getWaterType() {
        return this.waterType;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(this.getSource()).append((Object)this.waterType).build();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " " + this.getWaterType() + " " + this.getSource();
    }

    protected abstract Logger getLogger();

    protected abstract void populateGeometry();
}

