/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.roundabout;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.complex.Finder;
import org.openstreetmap.atlas.geography.atlas.items.complex.roundabout.ComplexRoundabout;
import org.openstreetmap.atlas.utilities.collections.Iterables;

public class ComplexRoundaboutFinder
implements Finder<ComplexRoundabout> {
    private final Set<Long> checkedIds = new HashSet<Long>();

    @Override
    public Iterable<ComplexRoundabout> find(Atlas atlas) {
        ArrayList<ComplexRoundabout> complexRoundabouts = new ArrayList<ComplexRoundabout>();
        Iterables.stream(atlas.edges()).forEach(edge -> {
            if (!this.checkedIds.contains(edge.getIdentifier())) {
                ComplexRoundabout complexRoundabout = new ComplexRoundabout((Edge)edge);
                if (complexRoundabout.getRoundaboutEdgeSet() != null) {
                    this.checkedIds.addAll(complexRoundabout.getRoundaboutEdgeSet().stream().map(AtlasObject::getIdentifier).collect(Collectors.toSet()));
                }
                if (complexRoundabout.isValid()) {
                    complexRoundabouts.add(complexRoundabout);
                }
            }
        });
        return complexRoundabouts;
    }
}

