/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.roundabout;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Route;
import org.openstreetmap.atlas.geography.atlas.items.complex.ComplexEntity;
import org.openstreetmap.atlas.geography.atlas.walker.SimpleEdgeWalker;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.JunctionTag;

public class ComplexRoundabout
extends ComplexEntity {
    protected static final String WRONG_WAY_INVALIDATION = "This roundabout is going the wrong direction, or has been improperly tagged as a roundabout.";
    protected static final String INCOMPLETE_ROUTE_INVALIDATION = "This roundabout does not form a single, one-way, complete, car navigable route.";
    private static final String EXCEPTION_MESSAGE = "Exception thrown while trying to build a ComplexRoundabout";
    private static final List<String> LEFT_DRIVING_COUNTRIES_DEFAULT = Arrays.asList("AIA", "ATG", "AUS", "BGD", "BHS", "BMU", "BRB", "BRN", "BTN", "BWA", "CCK", "COK", "CXR", "CYM", "CYP", "DMA", "FJI", "FLK", "GBR", "GGY", "GRD", "GUY", "HKG", "IDN", "IMN", "IND", "IRL", "JAM", "JEY", "JPN", "KEN", "KIR", "KNA", "LCA", "LKA", "LSO", "MAC", "MDV", "MLT", "MOZ", "MSR", "MUS", "MWI", "MYS", "NAM", "NFK", "NIU", "NPL", "NRU", "NZL", "PAK", "PCN", "PNG", "SGP", "SGS", "SHN", "SLB", "SUR", "SWZ", "SYC", "TCA", "THA", "TKL", "TLS", "TON", "TTO", "TUV", "TZA", "UGA", "VCT", "VGB", "VIR", "WSM", "ZAF", "ZMB", "ZWE");
    private static final long serialVersionUID = 2512054399729675784L;
    private final List<ComplexEntity.ComplexEntityError> invalidationReasons = new ArrayList<ComplexEntity.ComplexEntityError>();
    private Set<Edge> roundaboutEdgeSet;
    private Route roundaboutRoute;

    private static RoundaboutDirection findRoundaboutDirection(Route roundaboutEdges) {
        int clockwiseCount = 0;
        int counterClockwiseCount = 0;
        for (int index = 0; index < roundaboutEdges.size(); ++index) {
            Edge edge2;
            Edge edge1 = roundaboutEdges.get(index);
            double crossProduct = ComplexRoundabout.getCrossProduct(edge1, edge2 = roundaboutEdges.get((index + 1) % roundaboutEdges.size()));
            RoundaboutDirection direction = crossProduct < 0.0 ? RoundaboutDirection.COUNTERCLOCKWISE : (crossProduct > 0.0 ? RoundaboutDirection.CLOCKWISE : RoundaboutDirection.UNKNOWN);
            if (direction.equals((Object)RoundaboutDirection.UNKNOWN)) continue;
            if (direction.equals((Object)RoundaboutDirection.CLOCKWISE)) {
                ++clockwiseCount;
            }
            if (!direction.equals((Object)RoundaboutDirection.COUNTERCLOCKWISE)) continue;
            ++counterClockwiseCount;
        }
        if (clockwiseCount > counterClockwiseCount) {
            return RoundaboutDirection.CLOCKWISE;
        }
        if (clockwiseCount < counterClockwiseCount) {
            return RoundaboutDirection.COUNTERCLOCKWISE;
        }
        return RoundaboutDirection.UNKNOWN;
    }

    private static double getCrossProduct(Edge edge1, Edge edge2) {
        double node1Y = edge1.start().getLocation().getLatitude().asDegrees();
        double node1X = edge1.start().getLocation().getLongitude().asDegrees();
        double node2Y = edge1.end().getLocation().getLatitude().asDegrees();
        double node2X = edge1.end().getLocation().getLongitude().asDegrees();
        double node3Y = edge2.end().getLocation().getLatitude().asDegrees();
        double node3X = edge2.end().getLocation().getLongitude().asDegrees();
        double vector1X = node2X - node1X;
        double vector1Y = node2Y - node1Y;
        double vector2X = node2X - node3X;
        double vector2Y = node2Y - node3Y;
        return vector1X * vector2Y - vector1Y * vector2X;
    }

    public ComplexRoundabout(Edge source) {
        this(source, LEFT_DRIVING_COUNTRIES_DEFAULT);
    }

    public ComplexRoundabout(Edge source, List leftDrivingCountries) {
        super(source);
        try {
            if (!(source.getTag("iso_country_code").isPresent() && JunctionTag.isRoundabout(source) && source.isMasterEdge())) {
                ComplexEntity.ComplexEntityError sourceError = new ComplexEntity.ComplexEntityError(this, String.format("Invalid source Edge (%s) for a roundabout.", source.getIdentifier()), new CoreException(EXCEPTION_MESSAGE));
                this.invalidationReasons.add(sourceError);
                throw sourceError.getException();
            }
            String isoCountryCode = source.tag("iso_country_code").toUpperCase();
            this.roundaboutEdgeSet = new SimpleEdgeWalker(source, this.isRoundaboutEdge()).collectEdges();
            try {
                this.roundaboutRoute = Route.fromNonArrangedEdgeSet(this.roundaboutEdgeSet, false);
            }
            catch (CoreException badRoundabout) {
                ComplexEntity.ComplexEntityError routeError = new ComplexEntity.ComplexEntityError(this, INCOMPLETE_ROUTE_INVALIDATION, new CoreException(EXCEPTION_MESSAGE));
                this.invalidationReasons.add(routeError);
                throw routeError.getException();
            }
            if (this.roundaboutEdgeSet.stream().anyMatch(roundaboutEdge -> !HighwayTag.isCarNavigableHighway(roundaboutEdge) || !roundaboutEdge.isMasterEdge()) || !this.roundaboutRoute.start().inEdges().contains(this.roundaboutRoute.end())) {
                this.invalidationReasons.add(new ComplexEntity.ComplexEntityError(this, INCOMPLETE_ROUTE_INVALIDATION, new CoreException(EXCEPTION_MESSAGE)));
            }
            RoundaboutDirection direction = ComplexRoundabout.findRoundaboutDirection(this.roundaboutRoute);
            boolean isLeftDriving = leftDrivingCountries.contains(isoCountryCode);
            if (direction.equals((Object)RoundaboutDirection.CLOCKWISE) && !isLeftDriving || direction.equals((Object)RoundaboutDirection.COUNTERCLOCKWISE) && isLeftDriving) {
                this.invalidationReasons.add(new ComplexEntity.ComplexEntityError(this, WRONG_WAY_INVALIDATION, new CoreException(EXCEPTION_MESSAGE)));
            }
            if (!this.invalidationReasons.isEmpty()) {
                throw this.invalidationReasons.get(0).getException();
            }
        }
        catch (Throwable exception) {
            this.setInvalidReason(exception.getMessage(), exception);
        }
    }

    @Override
    public Rectangle bounds() {
        return this.roundaboutRoute.bounds();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ComplexRoundabout) {
            return this.roundaboutEdgeSet.equals(((ComplexRoundabout)other).getRoundaboutEdgeSet());
        }
        return false;
    }

    @Override
    public List<ComplexEntity.ComplexEntityError> getAllInvalidations() {
        return this.invalidationReasons;
    }

    public Set<Edge> getRoundaboutEdgeSet() {
        return this.roundaboutEdgeSet;
    }

    public Route getRoundaboutRoute() {
        return this.roundaboutRoute;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return String.format("Roundabout of Edges: %s", this.roundaboutEdgeSet);
    }

    private Function<Edge, Stream<Edge>> isRoundaboutEdge() {
        return edge -> edge.connectedEdges().stream().filter(JunctionTag::isRoundabout);
    }

    public static enum RoundaboutDirection {
        CLOCKWISE,
        COUNTERCLOCKWISE,
        UNKNOWN;

    }
}

