/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.islands;

import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.complex.Finder;
import org.openstreetmap.atlas.geography.atlas.items.complex.WaterIslandConfigurationReader;
import org.openstreetmap.atlas.geography.atlas.items.complex.islands.ComplexIsland;
import org.openstreetmap.atlas.geography.atlas.items.complex.islands.DefaultIslandConfigurationReader;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.collections.Iterables;

public class ComplexIslandFinder
implements Finder<ComplexIsland> {
    private final WaterIslandConfigurationReader islandConfigurationReader;

    public ComplexIslandFinder() {
        this.islandConfigurationReader = new DefaultIslandConfigurationReader("islands.json");
    }

    public ComplexIslandFinder(Resource resource) {
        this.islandConfigurationReader = new DefaultIslandConfigurationReader(resource);
    }

    @Override
    public Iterable<ComplexIsland> find(Atlas atlas) {
        return StreamSupport.stream(Iterables.translate(atlas.entities(), this.islandConfigurationReader::convert).spliterator(), false).filter(Optional::isPresent).map(Optional::get).filter(object -> object instanceof ComplexIsland).map(object -> (ComplexIsland)object).collect(Collectors.toList());
    }
}

