/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.boundaries.converters;

import java.util.Map;
import org.openstreetmap.atlas.geography.atlas.items.complex.boundaries.ComplexBoundary;
import org.openstreetmap.atlas.geography.geojson.GeoJsonBuilder;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.streaming.writers.JsonWriter;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.StreamIterable;

public final class ComplexBoundaryIterableToGeoJsonWriter {
    public static void saveAsGeojson(Iterable<ComplexBoundary> complexBoundaries, WritableResource output) {
        try (JsonWriter writer = new JsonWriter(output);){
            StreamIterable<GeoJsonBuilder.LocationIterableProperties> geojsonObjects = Iterables.stream(complexBoundaries).flatMap(boundary -> {
                Map<String, String> tags = boundary.getSource().getTags();
                return Iterables.stream(boundary.getOutline().asLocationIterableProperties()).map(locationIterableProperties -> {
                    locationIterableProperties.getProperties().putAll(tags);
                    return locationIterableProperties;
                });
            });
            writer.write(new GeoJsonBuilder().create(geojsonObjects).jsonObject());
        }
    }

    private ComplexBoundaryIterableToGeoJsonWriter() {
    }
}

