/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.bignode;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.builder.AtlasSize;
import org.openstreetmap.atlas.geography.atlas.items.AtlasItem;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Route;
import org.openstreetmap.atlas.geography.atlas.items.complex.ComplexEntity;
import org.openstreetmap.atlas.geography.atlas.items.complex.bignode.RestrictedPath;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlasBuilder;
import org.openstreetmap.atlas.geography.atlas.routing.AStarRouter;
import org.openstreetmap.atlas.geography.atlas.routing.AllPathsRouter;
import org.openstreetmap.atlas.geography.geojson.GeoJsonBuilder;
import org.openstreetmap.atlas.geography.geojson.GeoJsonObject;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.Maps;
import org.openstreetmap.atlas.utilities.collections.MultiIterable;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public class BigNode
extends ComplexEntity {
    public static final int MAXIMUM_NODES = 20;
    private static final long serialVersionUID = 4102278807908010498L;
    private Type type;
    private final Set<Node> nodes;
    private Set<Edge> edges;
    private Set<Edge> inEdges;
    private Set<Edge> outEdges;
    private Set<Edge> junctionEdges;
    private final Predicate<Edge> isJunctionEdge = edge -> this.junctionEdges().stream().filter(junctionEdge -> junctionEdge.getIdentifier() == edge.getIdentifier()).count() > 0L;

    public BigNode(Node source) {
        super(source);
        HashSet<Node> nodes = new HashSet<Node>();
        nodes.add(source);
        this.nodes = nodes;
        this.type = Type.SIMPLE;
    }

    public BigNode(Node source, Set<Node> nodes, Type type) {
        this(source, nodes);
        this.type = type;
    }

    protected BigNode(Node source, Set<Node> nodes) {
        super(source);
        this.nodes = nodes;
    }

    public Set<Route> allPaths() {
        return this.allPaths(20000);
    }

    public Set<Route> allPaths(int maximumPathCount) {
        Atlas atlas = this.nodes().iterator().next().getAtlas();
        Atlas bigNodeAtlas = this.buildBigNodeAtlas();
        HashSet<Route> allPaths = new HashSet<Route>();
        for (Edge inEdge : this.inEdges()) {
            for (Edge outEdge : this.outEdges()) {
                Set<Route> bigNodeRoutes = AllPathsRouter.allRoutes(bigNodeAtlas.edge(inEdge.getIdentifier()), bigNodeAtlas.edge(outEdge.getIdentifier()), this.isJunctionEdge, maximumPathCount);
                if (bigNodeRoutes.isEmpty()) continue;
                for (Route bigNodeRoute : bigNodeRoutes) {
                    Route route = Route.forEdge(atlas.edge(bigNodeRoute.start().getIdentifier()));
                    for (int index = 1; index < bigNodeRoute.size(); ++index) {
                        long edgeIdentifier = bigNodeRoute.get(index).getIdentifier();
                        route = route.append(atlas.edge(edgeIdentifier));
                    }
                    allPaths.add(route);
                }
            }
        }
        return allPaths;
    }

    public GeoJsonObject asGeoJson() {
        return new GeoJsonBuilder().create(Iterables.from(this.asGeoJsonBigNode()));
    }

    public GeoJsonBuilder.LocationIterableProperties asGeoJsonBigNode() {
        ArrayList<Location> locations = new ArrayList<Location>();
        this.nodes().stream().forEach(node -> locations.addAll(Rectangle.forLocated(node.getLocation()).expand(Distance.meters(2.0))));
        return new GeoJsonBuilder.LocationIterableProperties(new Polygon((List<Location>)locations), Maps.hashMap("BigNode", String.valueOf(this.getSource().getIdentifier())));
    }

    public Iterable<GeoJsonBuilder.LocationIterableProperties> asGeoJsonRestrictedPath() {
        return this.turnRestrictions().stream().map(turnRestriction -> new GeoJsonBuilder.LocationIterableProperties(turnRestriction.getRoute().asPolyLine(), Maps.hashMap("highway", "motorway", "oneway", "yes", "route", turnRestriction.getRoute().toString()))).collect(Collectors.toList());
    }

    @Override
    public Rectangle bounds() {
        return Rectangle.forLocated(this.nodesAndEdges());
    }

    public Set<Edge> edges() {
        if (this.edges == null) {
            this.edges = this.nodes.stream().flatMap(node -> node.connectedEdges().stream().filter(HighwayTag::isCarNavigableHighway)).collect(Collectors.toSet());
        }
        return this.edges;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof BigNode) {
            return this.getSource().equals(((BigNode)other).getSource()) && this.nodes().equals(((BigNode)other).nodes());
        }
        return false;
    }

    public Set<Edge> exteriorEdges() {
        return this.exteriorEdgesStream().collect(Collectors.toSet());
    }

    @Override
    public List<ComplexEntity.ComplexEntityError> getAllInvalidations() {
        ArrayList<ComplexEntity.ComplexEntityError> returnValue = new ArrayList<ComplexEntity.ComplexEntityError>();
        if (!this.isValid()) {
            returnValue.add(new ComplexEntity.ComplexEntityError(this, String.format("Too many nodes %d", this.nodes().size()), null));
        }
        return returnValue;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public Set<Edge> inEdges() {
        if (this.inEdges == null) {
            this.inEdges = this.inEdgesStream().collect(Collectors.toSet());
        }
        return this.inEdges;
    }

    @Override
    public boolean isValid() {
        return this.nodes().size() <= 20;
    }

    public Set<Edge> junctionEdges() {
        if (this.junctionEdges == null) {
            this.junctionEdges = this.junctionEdgesStream().collect(Collectors.toSet());
        }
        return this.junctionEdges;
    }

    public Set<Node> nodes() {
        return this.nodes;
    }

    public Iterable<AtlasItem> nodesAndEdges() {
        return new MultiIterable<AtlasItem>(this.nodes(), this.edges());
    }

    public Set<Edge> outEdges() {
        if (this.outEdges == null) {
            this.outEdges = this.outEdgesStream().collect(Collectors.toSet());
        }
        return this.outEdges;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Set<Route> shortestPaths() {
        Atlas atlas = this.nodes().iterator().next().getAtlas();
        Atlas bigNodeAtlas = this.buildBigNodeAtlas();
        HashSet<Route> shortestPaths = new HashSet<Route>();
        for (Edge inEdge : this.inEdges()) {
            for (Edge outEdge : this.outEdges()) {
                Route bigNodeRoute = AStarRouter.dijkstra(bigNodeAtlas, Distance.ONE_METER).route(bigNodeAtlas.edge(inEdge.getIdentifier()), bigNodeAtlas.edge(outEdge.getIdentifier()));
                if (bigNodeRoute == null) continue;
                Route route = Route.forEdge(atlas.edge(bigNodeRoute.start().getIdentifier()));
                for (int index = 1; index < bigNodeRoute.size(); ++index) {
                    long edgeIdentifier = bigNodeRoute.get(index).getIdentifier();
                    route = route.append(atlas.edge(edgeIdentifier));
                }
                shortestPaths.add(route);
            }
        }
        return shortestPaths;
    }

    @Override
    public String toString() {
        return "[BigNode: nodes=" + this.nodes().stream().map(AtlasObject::getIdentifier).collect(Collectors.toSet()) + "]";
    }

    public Set<RestrictedPath> turnRestrictions() {
        return this.allPaths().stream().filter(Route::isTurnRestriction).map(route -> new RestrictedPath(this, (Route)route)).collect(Collectors.toSet());
    }

    protected Stream<Edge> exteriorEdgesStream() {
        return this.edges().stream().filter(edge -> !this.nodes().contains(edge.end()) || !this.nodes().contains(edge.start()));
    }

    protected Stream<Edge> inEdgesStream() {
        return this.edges().stream().filter(edge -> !this.nodes().contains(edge.start()));
    }

    protected Stream<Edge> junctionEdgesStream() {
        return this.edges().stream().filter(edge -> this.nodes().contains(edge.start()) && this.nodes().contains(edge.end()));
    }

    protected Stream<Edge> outEdgesStream() {
        return this.edges().stream().filter(edge -> !this.nodes().contains(edge.end()));
    }

    private Atlas buildBigNodeAtlas() {
        Set<Edge> edges = this.edges();
        HashSet extendedNodes = new HashSet();
        edges.forEach(edge -> {
            extendedNodes.add(edge.start());
            extendedNodes.add(edge.end());
        });
        PackedAtlasBuilder builder = new PackedAtlasBuilder().withSizeEstimates(new AtlasSize(edges.size(), extendedNodes.size(), 0L, 0L, 0L, 0L));
        extendedNodes.forEach(node -> builder.addNode(node.getIdentifier(), node.getLocation(), node.getTags()));
        edges.forEach(edge -> builder.addEdge(edge.getIdentifier(), edge.asPolyLine(), edge.getTags()));
        return builder.get();
    }

    public static enum Type {
        SIMPLE,
        DUAL_CARRIAGEWAY;

    }

    public static enum Path {
        SHORTEST,
        ALL;

    }
}

