/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.aoi;

import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.complex.Finder;
import org.openstreetmap.atlas.geography.atlas.items.complex.aoi.ComplexAreaOfInterest;
import org.openstreetmap.atlas.tags.filters.TaggableFilter;
import org.openstreetmap.atlas.utilities.collections.MultiIterable;

public class ComplexAreaOfInterestFinder
implements Finder<ComplexAreaOfInterest> {
    @Override
    public Iterable<ComplexAreaOfInterest> find(Atlas atlas) {
        Iterable iterableOfComplexAOIRelations = StreamSupport.stream(atlas.relations().spliterator(), true).map(ComplexAreaOfInterest::getComplexAOI).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        Iterable iterableOfComplexAOIAreas = StreamSupport.stream(atlas.areas().spliterator(), true).map(ComplexAreaOfInterest::getComplexAOI).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        return new MultiIterable<ComplexAreaOfInterest>(iterableOfComplexAOIRelations, iterableOfComplexAOIAreas);
    }

    public Iterable<ComplexAreaOfInterest> find(Atlas atlas, TaggableFilter aoiFilter) {
        Iterable iterableOfComplexAOIRelations = StreamSupport.stream(atlas.relations().spliterator(), true).map(relation -> ComplexAreaOfInterest.getComplexAOI(relation, aoiFilter)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        Iterable iterableOfComplexAOIAreas = StreamSupport.stream(atlas.areas().spliterator(), true).map(area -> ComplexAreaOfInterest.getComplexAOI(area, aoiFilter)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        return new MultiIterable<ComplexAreaOfInterest>(iterableOfComplexAOIRelations, iterableOfComplexAOIAreas);
    }
}

