/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.complete;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.atlas.change.eventhandling.event.TagChangeEvent;
import org.openstreetmap.atlas.geography.atlas.change.eventhandling.listenable.TagChangeListenable;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteArea;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEdge;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteItemType;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteLine;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteNode;
import org.openstreetmap.atlas.geography.atlas.complete.CompletePoint;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteRelation;
import org.openstreetmap.atlas.geography.atlas.complete.PrettifyStringFormat;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.items.Relation;

public interface CompleteEntity<C extends CompleteEntity<C>>
extends TagChangeListenable {
    public static Map<String, String> addNewTag(Map<String, String> tags, String key, String value) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (tags != null) {
            result = new HashMap<String, String>(tags);
        }
        result.put(key, value);
        return result;
    }

    public static boolean basicEqual(AtlasEntity left, AtlasEntity right) {
        return left.getIdentifier() == right.getIdentifier() && Objects.equals(left.getTags(), right.getTags()) && Objects.equals(left.relations(), right.relations());
    }

    public static <M, T> boolean equalThroughGet(M left, M right, Function<M, T> getter) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        return Objects.equals(getter.apply(left), getter.apply(right));
    }

    public static AtlasEntity from(AtlasEntity reference) {
        ItemType type = reference.getType();
        switch (type) {
            case NODE: {
                return CompleteNode.from((Node)reference);
            }
            case EDGE: {
                return CompleteEdge.from((Edge)reference);
            }
            case AREA: {
                return CompleteArea.from((Area)reference);
            }
            case LINE: {
                return CompleteLine.from((Line)reference);
            }
            case POINT: {
                return CompletePoint.from((Point)reference);
            }
            case RELATION: {
                return CompleteRelation.from((Relation)reference);
            }
        }
        throw new CoreException("Unknown ItemType {}", new Object[]{type});
    }

    public static Map<String, String> removeTag(Map<String, String> tags, String key) {
        HashMap<String, String> result = new HashMap();
        if (tags != null) {
            result = new HashMap<String, String>(tags);
        }
        result.remove(key);
        return result;
    }

    public static AtlasEntity shallowFrom(AtlasEntity reference) {
        ItemType type = reference.getType();
        switch (type) {
            case NODE: {
                return CompleteNode.shallowFrom((Node)reference);
            }
            case EDGE: {
                return CompleteEdge.shallowFrom((Edge)reference);
            }
            case AREA: {
                return CompleteArea.shallowFrom((Area)reference);
            }
            case LINE: {
                return CompleteLine.shallowFrom((Line)reference);
            }
            case POINT: {
                return CompletePoint.shallowFrom((Point)reference);
            }
            case RELATION: {
                return CompleteRelation.shallowFrom((Relation)reference);
            }
        }
        throw new CoreException("Unknown ItemType {}", new Object[]{type});
    }

    public static AtlasEntity shallowFrom(ItemType type, Long identifier) {
        switch (type) {
            case NODE: {
                return new CompleteNode(identifier);
            }
            case EDGE: {
                return new CompleteEdge(identifier);
            }
            case AREA: {
                return new CompleteArea(identifier);
            }
            case LINE: {
                return new CompleteLine(identifier);
            }
            case POINT: {
                return new CompletePoint(identifier);
            }
            case RELATION: {
                return new CompleteRelation(identifier);
            }
        }
        throw new CoreException("Unknown ItemType {}", new Object[]{type});
    }

    public static <C extends CompleteEntity<C>> C withAddedTag(C completeEntity, String key, String value, boolean suppressFiringEvent) {
        CompleteEntity.withTags(completeEntity, CompleteEntity.addNewTag(completeEntity.getTags(), key, value), true);
        if (!suppressFiringEvent) {
            completeEntity.fireTagChangeEvent(TagChangeEvent.added(completeEntity.completeItemType(), completeEntity.getIdentifier(), Pair.of(key, value)));
        }
        return completeEntity;
    }

    public static <C extends CompleteEntity<C>> C withRemovedTag(C completeEntity, String key, boolean suppressFiringEvent) {
        CompleteEntity.withTags(completeEntity, CompleteEntity.removeTag(completeEntity.getTags(), key), true);
        if (!suppressFiringEvent) {
            completeEntity.fireTagChangeEvent(TagChangeEvent.remove(completeEntity.completeItemType(), completeEntity.getIdentifier(), key));
        }
        return completeEntity;
    }

    public static <C extends CompleteEntity<C>> C withReplacedTag(C completeEntity, String oldKey, String newKey, String newValue, boolean suppressFiringEvent) {
        CompleteEntity.withRemovedTag(completeEntity, oldKey, true);
        CompleteEntity.withAddedTag(completeEntity, newKey, newValue, true);
        if (!suppressFiringEvent) {
            completeEntity.fireTagChangeEvent(TagChangeEvent.replaced(completeEntity.completeItemType(), completeEntity.getIdentifier(), Triple.of(oldKey, newKey, newValue)));
        }
        return completeEntity;
    }

    public static <C extends CompleteEntity<C>> C withTags(C completeEntity, Map<String, String> tags, boolean suppressFiringEvent) {
        completeEntity.setTags(tags);
        if (!suppressFiringEvent) {
            completeEntity.fireTagChangeEvent(TagChangeEvent.overwrite(completeEntity.completeItemType(), completeEntity.getIdentifier(), tags));
        }
        return completeEntity;
    }

    public CompleteItemType completeItemType();

    public Iterable<Location> getGeometry();

    public long getIdentifier();

    public Map<String, String> getTags();

    public ItemType getType();

    public boolean isFull();

    public boolean isShallow();

    public String prettify(PrettifyStringFormat var1, boolean var2);

    default public String prettify(PrettifyStringFormat format) {
        return this.prettify(PrettifyStringFormat.MINIMAL_SINGLE_LINE, true);
    }

    default public String prettify() {
        return this.prettify(PrettifyStringFormat.MINIMAL_SINGLE_LINE);
    }

    public Set<Long> relationIdentifiers();

    public void setTags(Map<String, String> var1);

    public String toWkt();

    default public String truncate(String input) {
        return input.substring(0, Math.min(input.length(), 2000)) + "...";
    }

    public CompleteEntity withAddedRelationIdentifier(Long var1);

    default public C withAddedTag(String key, String value) {
        return (C)CompleteEntity.withAddedTag(this, key, value, false);
    }

    public CompleteEntity withGeometry(Iterable<Location> var1);

    public CompleteEntity withIdentifier(long var1);

    public CompleteEntity withRelationIdentifiers(Set<Long> var1);

    public CompleteEntity withRelations(Set<Relation> var1);

    public CompleteEntity withRemovedRelationIdentifier(Long var1);

    default public C withRemovedTag(String key) {
        return (C)CompleteEntity.withRemovedTag(this, key, false);
    }

    default public C withReplacedTag(String oldKey, String newKey, String newValue) {
        return (C)CompleteEntity.withReplacedTag(this, oldKey, newKey, newValue, false);
    }

    default public C withTags(Map<String, String> tags) {
        return (C)CompleteEntity.withTags(this, tags, false);
    }
}

