/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.complete;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.change.eventhandling.event.TagChangeEvent;
import org.openstreetmap.atlas.geography.atlas.change.eventhandling.listener.TagChangeListener;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEntity;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteItemType;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteRelation;
import org.openstreetmap.atlas.geography.atlas.complete.EmptyAtlas;
import org.openstreetmap.atlas.geography.atlas.complete.PrettifyStringFormat;
import org.openstreetmap.atlas.geography.atlas.complete.TagChangeDelegate;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Relation;

public class CompleteArea
extends Area
implements CompleteEntity<CompleteArea> {
    private static final long serialVersionUID = 309534717673911086L;
    private Rectangle bounds;
    private long identifier;
    private Polygon polygon;
    private Map<String, String> tags;
    private Set<Long> relationIdentifiers;
    private final TagChangeDelegate tagChangeDelegate = TagChangeDelegate.newTagChangeDelegate();

    public static CompleteArea from(Area area) {
        if (area instanceof CompleteArea && !((CompleteArea)area).isFull()) {
            throw new CoreException("Area parameter was a CompleteArea but it was not full: {}", area);
        }
        return new CompleteArea(area.getIdentifier(), area.asPolygon(), area.getTags(), area.relations().stream().map(AtlasObject::getIdentifier).collect(Collectors.toSet()));
    }

    public static CompleteArea shallowFrom(Area area) {
        if (area.bounds() == null) {
            throw new CoreException("Area parameter bounds were null");
        }
        return new CompleteArea(area.getIdentifier()).withBoundsExtendedBy(area.bounds());
    }

    public CompleteArea(Long identifier, Polygon polygon, Map<String, String> tags, Set<Long> relationIdentifiers) {
        super(new EmptyAtlas());
        if (identifier == null) {
            throw new CoreException("Identifier can never be null.");
        }
        this.bounds = polygon != null ? polygon.bounds() : null;
        this.identifier = identifier;
        this.polygon = polygon;
        this.tags = tags;
        this.relationIdentifiers = relationIdentifiers;
    }

    CompleteArea(long identifier) {
        this(identifier, null, null, null);
    }

    @Override
    public void addTagChangeListener(TagChangeListener tagChangeListener) {
        this.tagChangeDelegate.addTagChangeListener(tagChangeListener);
    }

    @Override
    public Polygon asPolygon() {
        return this.polygon;
    }

    @Override
    public Rectangle bounds() {
        return this.bounds;
    }

    @Override
    public CompleteItemType completeItemType() {
        return CompleteItemType.AREA;
    }

    public CompleteArea copy() {
        return new CompleteArea(this.identifier, this.polygon, this.tags, this.relationIdentifiers);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof CompleteArea) {
            CompleteArea that = (CompleteArea)other;
            return CompleteEntity.basicEqual(this, that) && Objects.equals(this.asPolygon(), that.asPolygon());
        }
        return false;
    }

    @Override
    public void fireTagChangeEvent(TagChangeEvent tagChangeEvent) {
        this.tagChangeDelegate.fireTagChangeEvent(tagChangeEvent);
    }

    @Override
    public Iterable<Location> getGeometry() {
        if (this.polygon != null) {
            return new ArrayList<Location>(this.polygon);
        }
        return null;
    }

    @Override
    public long getIdentifier() {
        return this.identifier;
    }

    @Override
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean isFull() {
        return this.bounds != null && this.polygon != null && this.tags != null && this.relationIdentifiers != null;
    }

    @Override
    public boolean isShallow() {
        return this.polygon == null && this.tags == null && this.relationIdentifiers == null;
    }

    @Override
    public String prettify(PrettifyStringFormat format, boolean truncate) {
        String separator = "";
        if (format == PrettifyStringFormat.MINIMAL_SINGLE_LINE) {
            separator = "";
        } else if (format == PrettifyStringFormat.MINIMAL_MULTI_LINE) {
            separator = "\n";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName() + " ");
        builder.append("[");
        builder.append(separator);
        builder.append("identifier: " + this.identifier + ", ");
        builder.append(separator);
        if (this.polygon != null) {
            if (truncate) {
                builder.append("polygon: " + this.truncate(this.polygon.toString()) + ", ");
            } else {
                builder.append("polygon: " + this.polygon.toString() + ", ");
            }
            builder.append(separator);
        }
        if (this.tags != null) {
            builder.append("tags: " + this.tags + ", ");
            builder.append(separator);
        }
        if (this.relationIdentifiers != null) {
            builder.append("parentRelations: " + this.relationIdentifiers + ", ");
            builder.append(separator);
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public Set<Long> relationIdentifiers() {
        return this.relationIdentifiers;
    }

    @Override
    public Set<Relation> relations() {
        return this.relationIdentifiers == null ? null : this.relationIdentifiers.stream().map(CompleteRelation::new).collect(Collectors.toSet());
    }

    @Override
    public void removeTagChangeListeners() {
        this.tagChangeDelegate.removeTagChangeListeners();
    }

    @Override
    public void setTags(Map<String, String> tags) {
        this.tags = tags != null ? new HashMap<String, String>(tags) : null;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [identifier=" + this.identifier + ", polygon=" + this.polygon + ", tags=" + this.tags + ", relationIdentifiers=" + this.relationIdentifiers + "]";
    }

    @Override
    public String toWkt() {
        if (this.polygon == null) {
            return null;
        }
        return this.polygon.toWkt();
    }

    @Override
    public CompleteArea withAddedRelationIdentifier(Long relationIdentifier) {
        this.relationIdentifiers.add(relationIdentifier);
        return this;
    }

    public CompleteArea withBoundsExtendedBy(Rectangle bounds) {
        if (this.bounds == null) {
            this.bounds = bounds;
            return this;
        }
        this.bounds = Rectangle.forLocated(this.bounds, bounds);
        return this;
    }

    @Override
    public CompleteEntity withGeometry(Iterable<Location> locations) {
        return this.withPolygon(new Polygon(locations));
    }

    @Override
    public CompleteArea withIdentifier(long identifier) {
        this.identifier = identifier;
        return this;
    }

    public CompleteArea withPolygon(Polygon polygon) {
        this.polygon = polygon;
        if (this.polygon != null) {
            this.bounds = polygon.bounds();
        }
        return this;
    }

    @Override
    public CompleteArea withRelationIdentifiers(Set<Long> relationIdentifiers) {
        this.relationIdentifiers = relationIdentifiers;
        return this;
    }

    @Override
    public CompleteArea withRelations(Set<Relation> relations) {
        this.relationIdentifiers = relations.stream().map(AtlasObject::getIdentifier).collect(Collectors.toSet());
        return this;
    }

    @Override
    public CompleteArea withRemovedRelationIdentifier(Long relationIdentifier) {
        this.relationIdentifiers = this.relationIdentifiers.stream().filter(keepId -> keepId.longValue() != relationIdentifier.longValue()).collect(Collectors.toSet());
        return this;
    }
}

