/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.command.buildings;

import java.io.PrintStream;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.command.AbstractAtlasSubCommand;
import org.openstreetmap.atlas.geography.atlas.items.AtlasItem;
import org.openstreetmap.atlas.tags.BuildingPartTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;

public class AtlasFindBuildingPartsSubCommand
extends AbstractAtlasSubCommand {
    private static void output(AtlasItem item) {
        System.out.printf("[%25s] [%9d] %s\n", item.getAtlas().getName(), item.getOsmIdentifier(), item);
    }

    public AtlasFindBuildingPartsSubCommand() {
        super("building-parts", "Task for finding all of the OSM ids with building:part=yes");
    }

    @Override
    public void usage(PrintStream writer) {
        writer.printf("-input=/path/to/atlas/files : the atlas files we want to load\n", new Object[0]);
    }

    @Override
    protected void handle(Atlas atlas, CommandMap command) {
        Predicate<Taggable> filter = Validators.hasValuesFor(BuildingPartTag.class);
        StreamSupport.stream(atlas.items().spliterator(), true).filter(filter).forEach(AtlasFindBuildingPartsSubCommand::output);
    }
}

