/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.command;

import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.command.AbstractAtlasSubCommand;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;

public class AtlasFindByFeatureIdentifierLocatorSubCommand
extends AbstractAtlasSubCommand {
    private static final Command.Switch<Set<String>> FEATURE_ID_PARAMETER = new Command.Switch("id", "list of comma-delimited Atlas extended feature identifier", possibleMultipleOSMIdentifier -> Stream.of(possibleMultipleOSMIdentifier.split(",")).collect(Collectors.toSet()), Command.Optionality.REQUIRED);
    private static final int TYPE_INDEX = 1;
    private static final int ID_INDEX = 2;
    private static final int EXPECTED_IDENTIFIER_LENGTH = 4;
    private final Predicate<Node> nodeCheck = item -> this.nodeIds.contains(item.getOsmIdentifier());
    private final Predicate<Point> pointCheck = item -> this.pointIds.contains(item.getOsmIdentifier());
    private final Predicate<Area> areaCheck = item -> this.areaIds.contains(item.getOsmIdentifier());
    private final Predicate<Edge> edgeCheck = item -> item.getOsmIdentifier() > 0L && this.edgeIds.contains(item.getOsmIdentifier());
    private final Predicate<Line> lineCheck = item -> this.lineIds.contains(item.getOsmIdentifier());
    private final Predicate<Relation> relationCheck = item -> this.relationIds.contains(item.getOsmIdentifier());
    private final Set<Long> nodeIds = new HashSet<Long>();
    private final Set<Long> pointIds = new HashSet<Long>();
    private final Set<Long> areaIds = new HashSet<Long>();
    private final Set<Long> edgeIds = new HashSet<Long>();
    private final Set<Long> lineIds = new HashSet<Long>();
    private final Set<Long> relationIds = new HashSet<Long>();

    public AtlasFindByFeatureIdentifierLocatorSubCommand() {
        super("find", "find which atlas files contain particular OSM features using a given set of extended identifiers");
    }

    @Override
    public Command.SwitchList switches() {
        return super.switches().with(FEATURE_ID_PARAMETER);
    }

    @Override
    public void usage(PrintStream writer) {
        writer.printf("-input=/path/to/atlas/files : the atlas files we want to load\n", new Object[0]);
        writer.printf("-id=comma-separated atlas extended feature identifiers to search for\n", new Object[0]);
    }

    protected String formatAtlasObject(String type, Atlas atlas, AtlasEntity entity) {
        String shardName = atlas.metaData().getShardName().orElse("UNKNOWN");
        return String.format("[%10s] [%d] [%d] --> [%s:%s] Tags: [%s]\n", type, entity.getOsmIdentifier(), entity.getIdentifier(), shardName, atlas.getName(), entity.getTags());
    }

    @Override
    protected void handle(Atlas atlas, CommandMap command) {
        int[] found = new int[]{0};
        atlas.nodes(this.nodeCheck).forEach(item -> {
            System.out.printf(this.formatAtlasObject("NODE", atlas, (AtlasEntity)item), new Object[0]);
            found[0] = found[0] + 1;
        });
        atlas.points(this.pointCheck).forEach(item -> {
            System.out.printf(this.formatAtlasObject("POINT", atlas, (AtlasEntity)item), new Object[0]);
            found[0] = found[0] + 1;
        });
        atlas.edges(this.edgeCheck).forEach(item -> {
            System.out.printf(this.formatAtlasObject("EDGE", atlas, (AtlasEntity)item), new Object[0]);
            found[0] = found[0] + 1;
        });
        atlas.lines(this.lineCheck).forEach(item -> {
            System.out.printf(this.formatAtlasObject("LINE", atlas, (AtlasEntity)item), new Object[0]);
            found[0] = found[0] + 1;
        });
        atlas.areas(this.areaCheck).forEach(item -> {
            System.out.printf(this.formatAtlasObject("AREA", atlas, (AtlasEntity)item), new Object[0]);
            found[0] = found[0] + 1;
        });
        atlas.relations(this.relationCheck).forEach(item -> {
            System.out.printf(this.formatAtlasObject("RELATION", atlas, (AtlasEntity)item), new Object[0]);
            found[0] = found[0] + 1;
        });
    }

    @Override
    protected void start(CommandMap command) {
        Set unparsedFeatureIds = (Set)command.get(FEATURE_ID_PARAMETER);
        for (String unparsedFeatureId : unparsedFeatureIds) {
            String[] parsedFeatureIds = unparsedFeatureId.split("_");
            if (parsedFeatureIds.length != 4) {
                throw new CoreException("There should be four pieces in an extended feature identifier: {}", unparsedFeatureId);
            }
            long osmId = Long.parseLong(parsedFeatureIds[2]);
            if (parsedFeatureIds[1].equals("N")) {
                this.nodeIds.add(osmId);
                this.pointIds.add(osmId);
                continue;
            }
            if (parsedFeatureIds[1].equals("W")) {
                this.areaIds.add(osmId);
                this.lineIds.add(osmId);
                this.edgeIds.add(osmId);
                continue;
            }
            if (parsedFeatureIds[1].equals("R")) {
                this.relationIds.add(osmId);
                continue;
            }
            throw new CoreException("Unknown type: {}", parsedFeatureIds[1]);
        }
    }
}

