/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.command;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasResourceLoader;
import org.openstreetmap.atlas.geography.atlas.multi.MultiAtlas;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.openstreetmap.atlas.utilities.runtime.FlexibleSubCommand;

public abstract class AbstractAtlasSubCommand
implements FlexibleSubCommand {
    private static final Command.Switch<File> INPUT_FOLDER_PARAMETER = new Command.Switch("input", "Input atlas file or folder containing atlas files to load", File::new, Command.Optionality.REQUIRED);
    private static final Command.Flag COMBINE_PARAMETER = new Command.Flag("combine", "Will combine all atlases found into a MultiAtlas before reading the metadata");
    private static final Command.Flag PARALLEL_FLAG = new Command.Flag("parallel", "Will process multiple atlases in parallel");
    private final String name;
    private final String description;

    protected AbstractAtlasSubCommand(String name, String description) {
        this.name = name;
        this.description = description;
    }

    @Override
    public int execute(CommandMap command) {
        this.start(command);
        File path = (File)command.get(INPUT_FOLDER_PARAMETER);
        Stream atlases = path.listFilesRecursively().stream().filter(AtlasResourceLoader.HAS_ATLAS_EXTENSION).map(atlas -> new AtlasResourceLoader().load((Resource)atlas));
        if (((Boolean)command.get(PARALLEL_FLAG)).booleanValue()) {
            atlases = (Stream)atlases.parallel();
        }
        if (((Boolean)command.get(COMBINE_PARAMETER)).booleanValue()) {
            this.handle(new MultiAtlas(atlases.collect(Collectors.toList())), command);
        } else {
            atlases.forEach(atlas -> this.handle((Atlas)atlas, command));
        }
        return this.finish(command);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public Command.SwitchList switches() {
        return new Command.SwitchList().with(INPUT_FOLDER_PARAMETER, COMBINE_PARAMETER, PARALLEL_FLAG);
    }

    protected int finish(CommandMap command) {
        return 0;
    }

    protected abstract void handle(Atlas var1, CommandMap var2);

    protected void start(CommandMap command) {
    }
}

