/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.changeset;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasMetaData;
import org.openstreetmap.atlas.geography.atlas.builder.RelationBean;
import org.openstreetmap.atlas.geography.atlas.changeset.ChangeAction;
import org.openstreetmap.atlas.geography.atlas.changeset.ChangeItem;
import org.openstreetmap.atlas.geography.atlas.changeset.ChangeSet;
import org.openstreetmap.atlas.geography.atlas.items.AtlasItem;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlasBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ChangeSetAtlasBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ChangeSetAtlasBuilder.class);
    private static final int MAXIMUM_RELATION_LOOPS = 500;
    private final PackedAtlasBuilder builder;
    private final Atlas originalAtlas;
    private final ChangeSet changeSet;
    private Atlas conflatedAtlas;

    public ChangeSetAtlasBuilder(Atlas atlas, ChangeSet changeSet) {
        this.originalAtlas = atlas;
        this.changeSet = changeSet;
        this.builder = new PackedAtlasBuilder().withMetaData(new AtlasMetaData()).withSizeEstimates(atlas.size());
    }

    public Atlas get() {
        if (this.conflatedAtlas != null) {
            return this.conflatedAtlas;
        }
        this.handleSimple(this.originalAtlas.nodes());
        this.handleSimple(this.originalAtlas.points());
        this.handleSimple(this.originalAtlas.lines());
        this.handleSimple(this.originalAtlas.edges());
        this.handleSimple(this.originalAtlas.areas());
        this.handleRelations();
        this.conflatedAtlas = this.builder.get();
        return this.conflatedAtlas;
    }

    private void addItem(long identifier, ItemType type, Iterable<Location> geometry, Map<String, String> tags) {
        switch (type) {
            case POINT: {
                this.builder.addPoint(identifier, (Location)geometry, tags);
                break;
            }
            case NODE: {
                this.builder.addNode(identifier, (Location)geometry, tags);
                break;
            }
            case LINE: {
                this.builder.addLine(identifier, (PolyLine)geometry, tags);
                break;
            }
            case EDGE: {
                this.builder.addEdge(identifier, (PolyLine)geometry, tags);
                break;
            }
            case AREA: {
                this.builder.addArea(identifier, (Polygon)geometry, tags);
                break;
            }
            default: {
                throw new IllegalArgumentException("addItem can't take relation type");
            }
        }
    }

    private void handleRelations() {
        this.originalAtlas.relations().forEach(relation -> {
            if (this.changeSet.contains(relation.getIdentifier(), ItemType.RELATION, ChangeAction.DELETE)) {
                return;
            }
            Optional<ChangeItem> optionalItem = this.changeSet.get(relation.getIdentifier(), ItemType.RELATION, ChangeAction.UPDATE);
            if (optionalItem.isPresent()) {
                ChangeItem changeItem = optionalItem.get();
                this.builder.addRelation(relation.getIdentifier(), relation.getOsmIdentifier(), changeItem.getRelationBean().get(), changeItem.getTags());
            } else {
                RelationBean bean = new RelationBean();
                relation.members().forEach(member -> bean.addItem(member.getEntity().getIdentifier(), member.getRole(), member.getEntity().getType()));
                this.builder.addRelation(relation.getIdentifier(), relation.osmRelationIdentifier(), bean, relation.getTags());
            }
        });
        HashSet<Long> stagedRelationIdentifiers = new HashSet<Long>();
        Iterator<ChangeItem> iterator = this.changeSet.iterator(ItemType.RELATION, ChangeAction.CREATE);
        while (iterator.hasNext()) {
            ChangeItem relationMatchResult = iterator.next();
            if (StreamSupport.stream(relationMatchResult.getMembers().spliterator(), false).anyMatch(member -> member.getType() == ItemType.RELATION)) {
                stagedRelationIdentifiers.add(relationMatchResult.getIdentifier());
                continue;
            }
            this.builder.addRelation(relationMatchResult.getIdentifier(), relationMatchResult.getIdentifier(), relationMatchResult.getRelationBean().get(), relationMatchResult.getTags());
        }
        int iterations = 0;
        while (++iterations < 500 && !stagedRelationIdentifiers.isEmpty()) {
            logger.trace("Copying relations level {} deep.", (Object)iterations);
            HashSet<Long> stagedRelationIdentifiersCopy = new HashSet<Long>();
            for (Long relationIdentifier : stagedRelationIdentifiers) {
                Optional<ChangeItem> optionalItem = this.changeSet.get(relationIdentifier, ItemType.RELATION, ChangeAction.CREATE);
                if (!optionalItem.isPresent()) {
                    logger.error("can't find relation with id {}", (Object)relationIdentifier);
                    continue;
                }
                ChangeItem relationItem = optionalItem.get();
                boolean skip = StreamSupport.stream(relationItem.getMembers().spliterator(), false).allMatch(member -> member.getType() == ItemType.RELATION && this.builder.peek().relation(member.getIdentifier()) == null);
                if (!skip) {
                    this.builder.addRelation(relationItem.getIdentifier(), relationItem.getIdentifier(), relationItem.getRelationBean().get(), relationItem.getTags());
                    continue;
                }
                stagedRelationIdentifiersCopy.add(relationIdentifier);
            }
            stagedRelationIdentifiers = stagedRelationIdentifiersCopy;
        }
        if (iterations >= 500) {
            throw new CoreException("There might be a loop in relations! It took more than {} loops to copy the relation.", 500);
        }
    }

    private void handleSimple(Iterable<? extends AtlasItem> items) {
        items.forEach(item -> {
            if (this.changeSet.contains(item.getIdentifier(), item.getType(), ChangeAction.DELETE)) {
                return;
            }
            Optional<ChangeItem> optionalItem = this.changeSet.get(item.getIdentifier(), item.getType(), ChangeAction.UPDATE);
            if (optionalItem.isPresent()) {
                ChangeItem changeItem = optionalItem.get();
                this.addItem(changeItem.getIdentifier(), item.getType(), changeItem.getGeometry(), changeItem.getTags());
            } else {
                this.addItem(item.getIdentifier(), item.getType(), item.getRawGeometry(), item.getTags());
            }
        });
        Iterator<? extends AtlasItem> iterator = items.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        ItemType type = iterator.next().getType();
        this.changeSet.iterator(type, ChangeAction.CREATE).forEachRemaining(changeItem -> this.addItem(changeItem.getIdentifier(), type, changeItem.getGeometry(), changeItem.getTags()));
    }
}

