/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.change.eventhandling.event;

import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.openstreetmap.atlas.geography.atlas.change.eventhandling.event.EntityChangeEvent;
import org.openstreetmap.atlas.geography.atlas.change.eventhandling.event.consts.FieldChangeOperation;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteItemType;

public class TagChangeEvent
extends EntityChangeEvent {
    private static final long serialVersionUID = -3108915161471760840L;
    private final FieldChangeOperation fieldOperation;

    public static TagChangeEvent added(CompleteItemType completeItemType, long identifier, Pair<String, String> addedTagPair) {
        return new TagChangeEvent(completeItemType, identifier, Optional.of(addedTagPair), FieldChangeOperation.ADD);
    }

    public static TagChangeEvent overwrite(CompleteItemType completeItemType, long identifier, Map<String, String> newTags) {
        return new TagChangeEvent(completeItemType, identifier, Optional.ofNullable(newTags), FieldChangeOperation.OVERWRITE);
    }

    public static TagChangeEvent remove(CompleteItemType completeItemType, long identifier, String key) {
        return new TagChangeEvent(completeItemType, identifier, Optional.of(key), FieldChangeOperation.REMOVE);
    }

    public static TagChangeEvent replaced(CompleteItemType completeItemType, long identifier, Triple<String, String, String> tagReplacementInfo) {
        return new TagChangeEvent(completeItemType, identifier, Optional.of(tagReplacementInfo), FieldChangeOperation.REPLACE);
    }

    protected TagChangeEvent(CompleteItemType completeItemType, long identifier, Optional<Object> newValue, FieldChangeOperation fieldOperation) {
        super(completeItemType, identifier, newValue);
        this.fieldOperation = fieldOperation;
    }

    public FieldChangeOperation getFieldOperation() {
        return this.fieldOperation;
    }
}

