/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.change.diff;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.change.Change;
import org.openstreetmap.atlas.geography.atlas.change.ChangeBuilder;
import org.openstreetmap.atlas.geography.atlas.change.ChangeType;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.change.diff.AtlasDiffHelper;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasDiff {
    private static final Logger logger = LoggerFactory.getLogger(AtlasDiff.class);
    private final Atlas before;
    private final Atlas after;
    private Change change;
    private boolean saveAllGeometries = true;

    public AtlasDiff(Atlas before, Atlas after) {
        this.before = before;
        this.after = after;
        this.change = null;
        if (this.before == null) {
            throw new CoreException("Before atlas cannot be null.");
        }
        if (this.after == null) {
            throw new CoreException("After atlas cannot be null.");
        }
    }

    public Optional<Change> generateChange() {
        Time start = Time.now();
        if (this.change != null) {
            return Optional.of(this.change);
        }
        HashSet<AtlasEntity> addedEntities = new HashSet<AtlasEntity>();
        HashSet<AtlasEntity> removedEntities = new HashSet<AtlasEntity>();
        HashSet<AtlasEntity> potentiallyModifiedEntities = new HashSet<AtlasEntity>();
        ChangeBuilder changeBuilder = new ChangeBuilder();
        Iterables.stream(this.before).forEach(beforeEntity -> {
            if (this.isEntityMissingFromGivenAtlas((AtlasEntity)beforeEntity, this.after)) {
                removedEntities.add((AtlasEntity)beforeEntity);
            } else {
                potentiallyModifiedEntities.add((AtlasEntity)beforeEntity);
            }
        });
        Iterables.stream(this.after).filter(afterEntity -> this.isEntityMissingFromGivenAtlas((AtlasEntity)afterEntity, this.before)).forEach(addedEntities::add);
        this.createFeatureChangesBasedOnEntitySets(addedEntities, removedEntities, potentiallyModifiedEntities, this.before, this.after, this.saveAllGeometries).stream().forEach(changeBuilder::add);
        if (changeBuilder.peekNumberOfChanges() == 0) {
            logger.debug("Computed AtlasDiff ({} vs {}) in {}", new Object[]{this.before.getName(), this.after.getName(), start.elapsedSince()});
            return Optional.empty();
        }
        this.change = changeBuilder.get();
        logger.debug("Computed AtlasDiff ({} vs {}) in {}", new Object[]{this.before.getName(), this.after.getName(), start.elapsedSince()});
        return Optional.of(this.change);
    }

    public Atlas getAfterAtlas() {
        return this.after;
    }

    public Atlas getBeforeAtlas() {
        return this.before;
    }

    public AtlasDiff saveAllGeometries(boolean saveAllGeometries) {
        this.saveAllGeometries = saveAllGeometries;
        return this;
    }

    private Set<FeatureChange> createFeatureChangesBasedOnEntitySets(Set<AtlasEntity> addedEntities, Set<AtlasEntity> removedEntities, Set<AtlasEntity> potentiallyModifiedEntities, Atlas beforeAtlas, Atlas afterAtlas, boolean saveAllGeometries) {
        HashSet<FeatureChange> featureChanges = new HashSet<FeatureChange>();
        addedEntities.stream().map(addedEntity -> this.createSimpleFeatureChangeWithType(ChangeType.ADD, (AtlasEntity)addedEntity, afterAtlas, beforeAtlas, saveAllGeometries)).forEach(featureChanges::add);
        removedEntities.stream().map(removedEntity -> this.createSimpleFeatureChangeWithType(ChangeType.REMOVE, (AtlasEntity)removedEntity, beforeAtlas, beforeAtlas, saveAllGeometries)).forEach(featureChanges::add);
        potentiallyModifiedEntities.stream().map(modifiedEntity -> this.createModifyFeatureChanges((AtlasEntity)modifiedEntity, beforeAtlas, saveAllGeometries)).forEach(modifyFeatureChangeSet -> modifyFeatureChangeSet.forEach(featureChanges::add));
        return featureChanges;
    }

    private Set<FeatureChange> createModifyFeatureChanges(AtlasEntity entity, Atlas beforeViewAtlas, boolean saveAllGeometries) {
        HashSet<FeatureChange> featureChanges = new HashSet<FeatureChange>();
        AtlasEntity beforeEntity = entity.getType().entityForIdentifier(this.before, entity.getIdentifier());
        AtlasEntity afterEntity = entity.getType().entityForIdentifier(this.after, entity.getIdentifier());
        if (beforeEntity == null || afterEntity == null) {
            throw new CoreException("Unexpected null entity. This should never happen.");
        }
        AtlasDiffHelper.getTagChangeIfNecessary(beforeEntity, afterEntity, beforeViewAtlas, saveAllGeometries).ifPresent(featureChanges::add);
        AtlasDiffHelper.getParentRelationMembershipChangeIfNecessary(beforeEntity, afterEntity, beforeViewAtlas, saveAllGeometries).ifPresent(featureChanges::add);
        if (entity instanceof Node) {
            AtlasDiffHelper.getNodeChangeIfNecessary((Node)beforeEntity, (Node)afterEntity, beforeViewAtlas, saveAllGeometries).ifPresent(featureChanges::add);
        } else if (entity instanceof Edge) {
            AtlasDiffHelper.getEdgeChangeIfNecessary((Edge)beforeEntity, (Edge)afterEntity, beforeViewAtlas, saveAllGeometries).ifPresent(featureChanges::add);
        } else if (entity instanceof Point) {
            AtlasDiffHelper.getPointChangeIfNecessary((Point)beforeEntity, (Point)afterEntity, beforeViewAtlas).ifPresent(featureChanges::add);
        } else if (entity instanceof Line) {
            AtlasDiffHelper.getLineChangeIfNecessary((Line)beforeEntity, (Line)afterEntity, beforeViewAtlas).ifPresent(featureChanges::add);
        } else if (entity instanceof Area) {
            AtlasDiffHelper.getAreaChangeIfNecessary((Area)beforeEntity, (Area)afterEntity, beforeViewAtlas).ifPresent(featureChanges::add);
        } else if (entity instanceof Relation) {
            AtlasDiffHelper.getRelationChangeIfNecessary((Relation)beforeEntity, (Relation)afterEntity, beforeViewAtlas).ifPresent(featureChanges::add);
        }
        return featureChanges;
    }

    private FeatureChange createSimpleFeatureChangeWithType(ChangeType changeType, AtlasEntity entity, Atlas atlasContainingTheEntity, Atlas beforeViewAtlas, boolean saveAllGeometries) {
        FeatureChange featureChange;
        switch (entity.getType()) {
            case NODE: {
                featureChange = AtlasDiffHelper.simpleCompleteNodeChange(changeType, atlasContainingTheEntity, beforeViewAtlas, entity, saveAllGeometries);
                break;
            }
            case EDGE: {
                featureChange = AtlasDiffHelper.simpleCompleteEdgeChange(changeType, atlasContainingTheEntity, beforeViewAtlas, entity, saveAllGeometries);
                break;
            }
            case POINT: {
                featureChange = AtlasDiffHelper.simpleCompletePointChange(changeType, atlasContainingTheEntity, beforeViewAtlas, entity, saveAllGeometries);
                break;
            }
            case LINE: {
                featureChange = AtlasDiffHelper.simpleCompleteLineChange(changeType, atlasContainingTheEntity, beforeViewAtlas, entity, saveAllGeometries);
                break;
            }
            case AREA: {
                featureChange = AtlasDiffHelper.simpleCompleteAreaChange(changeType, atlasContainingTheEntity, beforeViewAtlas, entity, saveAllGeometries);
                break;
            }
            case RELATION: {
                featureChange = AtlasDiffHelper.simpleCompleteRelationChange(changeType, atlasContainingTheEntity, beforeViewAtlas, entity);
                break;
            }
            default: {
                throw new CoreException("Unknown item type {}", new Object[]{entity.getType()});
            }
        }
        return featureChange;
    }

    private boolean isEntityMissingFromGivenAtlas(AtlasEntity entity, Atlas atlasToCheck) {
        return entity.getType().entityForIdentifier(atlasToCheck, entity.getIdentifier()) == null;
    }
}

