/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.change.description.descriptors;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import org.openstreetmap.atlas.geography.atlas.change.description.ChangeDescriptorType;
import org.openstreetmap.atlas.geography.atlas.change.description.descriptors.ChangeDescriptor;
import org.openstreetmap.atlas.geography.atlas.change.description.descriptors.ChangeDescriptorName;

public class TagChangeDescriptor
implements ChangeDescriptor {
    private final ChangeDescriptorType changeType;
    private final String key;
    private final String value;
    private final String originalValue;

    public TagChangeDescriptor(ChangeDescriptorType changeType, String key, String value, String originalValue) {
        this.changeType = changeType;
        this.key = key;
        this.value = value;
        this.originalValue = originalValue;
    }

    public TagChangeDescriptor(ChangeDescriptorType changeType, String key, String value) {
        this(changeType, key, value, null);
    }

    @Override
    public ChangeDescriptorType getChangeDescriptorType() {
        return this.changeType;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public ChangeDescriptorName getName() {
        return ChangeDescriptorName.TAG;
    }

    public Optional<String> getOriginalValue() {
        return Optional.ofNullable(this.originalValue);
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public JsonElement toJsonElement() {
        JsonObject descriptor = (JsonObject)ChangeDescriptor.super.toJsonElement();
        descriptor.addProperty("key", this.key);
        descriptor.addProperty("value", this.value);
        if (this.originalValue != null) {
            descriptor.addProperty("originalValue", this.originalValue);
        }
        return descriptor;
    }

    public String toString() {
        String string = this.getName().toString() + "(" + this.changeType + ", " + this.key + ", ";
        string = this.originalValue == null ? string + this.value + ")" : string + this.originalValue + " => " + this.value + ")";
        return string;
    }
}

