/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.change.description.descriptors;

import com.github.difflib.DiffUtils;
import com.github.difflib.algorithm.DiffException;
import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.Patch;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.atlas.change.description.ChangeDescriptorType;
import org.openstreetmap.atlas.geography.atlas.change.description.descriptors.ChangeDescriptor;
import org.openstreetmap.atlas.geography.atlas.change.description.descriptors.ChangeDescriptorName;

public final class GeometryChangeDescriptor
implements ChangeDescriptor {
    private static final int TRUNCATE_WIDTH = 200;
    private final ChangeDescriptorType changeType;
    private final AbstractDelta<Location> delta;
    private final int sourceMaterialSize;

    public static List<GeometryChangeDescriptor> getDescriptorsForGeometry(List<Location> beforeList, List<Location> afterList) {
        Patch<Location> diff;
        try {
            diff = DiffUtils.diff(beforeList, afterList);
        }
        catch (DiffException exception) {
            throw new CoreException("Failed to compute diff for GeometryChangeDescriptor", exception);
        }
        ArrayList<GeometryChangeDescriptor> descriptors = new ArrayList<GeometryChangeDescriptor>();
        for (AbstractDelta<Location> delta : diff.getDeltas()) {
            descriptors.add(new GeometryChangeDescriptor(delta, beforeList.size()));
        }
        return descriptors;
    }

    public static Patch getPatch(List<GeometryChangeDescriptor> descriptors) {
        Patch<Location> patch = new Patch<Location>();
        for (GeometryChangeDescriptor descriptor : descriptors) {
            patch.addDelta(descriptor.getDelta());
        }
        return patch;
    }

    private GeometryChangeDescriptor(AbstractDelta<Location> delta, int sourceMaterialSize) {
        switch (delta.getType()) {
            case CHANGE: {
                this.changeType = ChangeDescriptorType.UPDATE;
                break;
            }
            case DELETE: {
                this.changeType = ChangeDescriptorType.REMOVE;
                break;
            }
            case INSERT: {
                this.changeType = ChangeDescriptorType.ADD;
                break;
            }
            default: {
                throw new CoreException("Unexpected Delta value: " + delta.getType());
            }
        }
        this.delta = delta;
        this.sourceMaterialSize = sourceMaterialSize;
    }

    public Optional<String> getAfterViewWkt() {
        if (this.changeType == ChangeDescriptorType.ADD || this.changeType == ChangeDescriptorType.UPDATE) {
            return Optional.of(new PolyLine(this.delta.getTarget().getLines()).toWkt());
        }
        return Optional.empty();
    }

    public Optional<String> getBeforeViewWkt() {
        if (this.changeType == ChangeDescriptorType.REMOVE || this.changeType == ChangeDescriptorType.UPDATE) {
            return Optional.of(new PolyLine(this.delta.getSource().getLines()).toWkt());
        }
        return Optional.empty();
    }

    @Override
    public ChangeDescriptorType getChangeDescriptorType() {
        return this.changeType;
    }

    public AbstractDelta<Location> getDelta() {
        return this.delta;
    }

    @Override
    public ChangeDescriptorName getName() {
        return ChangeDescriptorName.GEOMETRY;
    }

    public int getSourcePosition() {
        return this.delta.getSource().getPosition();
    }

    @Override
    public JsonElement toJsonElement() {
        JsonObject descriptor = (JsonObject)ChangeDescriptor.super.toJsonElement();
        descriptor.addProperty("position", this.delta.getSource().getPosition() + "/" + this.sourceMaterialSize);
        switch (this.changeType) {
            case UPDATE: {
                descriptor.addProperty("beforeView", StringUtils.truncate(new PolyLine(this.delta.getSource().getLines()).toWkt(), 200));
                descriptor.addProperty("afterView", StringUtils.truncate(new PolyLine(this.delta.getTarget().getLines()).toWkt(), 200));
                break;
            }
            case REMOVE: {
                descriptor.addProperty("beforeView", StringUtils.truncate(new PolyLine(this.delta.getSource().getLines()).toWkt(), 200));
                break;
            }
            case ADD: {
                descriptor.addProperty("afterView", StringUtils.truncate(new PolyLine(this.delta.getTarget().getLines()).toWkt(), 200));
                break;
            }
            default: {
                throw new CoreException("Unexpected ChangeType value: " + this.delta.getType());
            }
        }
        return descriptor;
    }

    public String toString() {
        StringBuilder diffString = new StringBuilder();
        diffString.append(this.changeType.toString());
        diffString.append(", ");
        diffString.append(this.delta.getSource().getPosition());
        diffString.append("/");
        diffString.append(this.sourceMaterialSize);
        switch (this.changeType) {
            case UPDATE: {
                diffString.append(", ");
                diffString.append(new PolyLine(this.delta.getSource().getLines()).toWkt());
                diffString.append(" => ");
                diffString.append(new PolyLine(this.delta.getTarget().getLines()).toWkt());
                break;
            }
            case REMOVE: {
                diffString.append(", ");
                diffString.append(new PolyLine(this.delta.getSource().getLines()).toWkt());
                break;
            }
            case ADD: {
                diffString.append(", ");
                diffString.append(new PolyLine(this.delta.getTarget().getLines()).toWkt());
                break;
            }
            default: {
                throw new CoreException("Unexpected ChangeType value: " + this.delta.getType());
            }
        }
        return this.getName().toString() + "(" + diffString.toString() + ")";
    }
}

