/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.change.description.descriptors;

import java.util.Comparator;
import java.util.Optional;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.change.description.descriptors.ChangeDescriptor;
import org.openstreetmap.atlas.geography.atlas.change.description.descriptors.GeometryChangeDescriptor;
import org.openstreetmap.atlas.geography.atlas.change.description.descriptors.LongElementChangeDescriptor;
import org.openstreetmap.atlas.geography.atlas.change.description.descriptors.RelationMemberChangeDescriptor;
import org.openstreetmap.atlas.geography.atlas.change.description.descriptors.TagChangeDescriptor;

public class ChangeDescriptorComparator
implements Comparator<ChangeDescriptor> {
    @Override
    public int compare(ChangeDescriptor left, ChangeDescriptor right) {
        if (left.getName() != right.getName()) {
            return left.getName().compareTo(right.getName());
        }
        return this.complexCompare(left, right);
    }

    private int complexCompare(ChangeDescriptor left, ChangeDescriptor right) {
        if (left instanceof TagChangeDescriptor && right instanceof TagChangeDescriptor) {
            return this.tagChangeCompare((TagChangeDescriptor)left, (TagChangeDescriptor)right);
        }
        if (left instanceof GeometryChangeDescriptor && right instanceof GeometryChangeDescriptor) {
            return this.geometryChangeCompare((GeometryChangeDescriptor)left, (GeometryChangeDescriptor)right);
        }
        if (left instanceof LongElementChangeDescriptor && right instanceof LongElementChangeDescriptor) {
            return this.genericSetChangeCompare((LongElementChangeDescriptor)left, (LongElementChangeDescriptor)right);
        }
        if (left instanceof RelationMemberChangeDescriptor && right instanceof RelationMemberChangeDescriptor) {
            return this.relationMemberChangeCompare((RelationMemberChangeDescriptor)left, (RelationMemberChangeDescriptor)right);
        }
        throw new CoreException("Could not compare {} vs {}", left, right);
    }

    private int genericSetChangeCompare(LongElementChangeDescriptor left, LongElementChangeDescriptor right) {
        if (left.getName() != right.getName()) {
            return left.getName().compareTo(right.getName());
        }
        if (left.getChangeDescriptorType() != right.getChangeDescriptorType()) {
            return left.getChangeDescriptorType().compareTo(right.getChangeDescriptorType());
        }
        Long leftBeforeComparable = left.getBeforeElement();
        Long rightBeforeComparable = right.getBeforeElement();
        if (leftBeforeComparable != null && rightBeforeComparable != null && !((Object)leftBeforeComparable).equals(rightBeforeComparable)) {
            return leftBeforeComparable.compareTo(rightBeforeComparable);
        }
        Long leftAfterComparable = left.getAfterElement();
        Long rightAfterComparable = right.getAfterElement();
        if (leftAfterComparable != null && rightAfterComparable != null && !((Object)leftAfterComparable).equals(rightAfterComparable)) {
            return leftAfterComparable.compareTo(rightAfterComparable);
        }
        throw new CoreException("No comparable criteria for {} vs {}", left, right);
    }

    private int geometryChangeCompare(GeometryChangeDescriptor left, GeometryChangeDescriptor right) {
        if (left.getChangeDescriptorType() != right.getChangeDescriptorType()) {
            return left.getChangeDescriptorType().compareTo(right.getChangeDescriptorType());
        }
        if (left.getSourcePosition() != right.getSourcePosition()) {
            return Integer.compare(left.getSourcePosition(), right.getSourcePosition());
        }
        Optional<String> leftBeforeViewWkt = left.getBeforeViewWkt();
        Optional<String> rightBeforeViewWkt = right.getBeforeViewWkt();
        if (leftBeforeViewWkt.isPresent() && rightBeforeViewWkt.isPresent() && !leftBeforeViewWkt.get().equals(rightBeforeViewWkt.get())) {
            return leftBeforeViewWkt.get().compareTo(rightBeforeViewWkt.get());
        }
        Optional<String> leftAfterViewWkt = left.getAfterViewWkt();
        Optional<String> rightAfterViewWkt = right.getAfterViewWkt();
        if (leftAfterViewWkt.isPresent() && rightAfterViewWkt.isPresent()) {
            return leftAfterViewWkt.get().compareTo(rightAfterViewWkt.get());
        }
        throw new CoreException("No comparable criteria for {} vs {}", left, right);
    }

    private int relationMemberChangeCompare(RelationMemberChangeDescriptor left, RelationMemberChangeDescriptor right) {
        if (left.getChangeDescriptorType() != right.getChangeDescriptorType()) {
            return left.getChangeDescriptorType().compareTo(right.getChangeDescriptorType());
        }
        if (left.getItemType() != right.getItemType()) {
            return left.getItemType().compareTo(right.getItemType());
        }
        if (left.getIdentifier() != right.getIdentifier()) {
            return Long.compare(left.getIdentifier(), right.getIdentifier());
        }
        return left.getRole().compareTo(right.getRole());
    }

    private int tagChangeCompare(TagChangeDescriptor left, TagChangeDescriptor right) {
        if (left.getChangeDescriptorType() != right.getChangeDescriptorType()) {
            return left.getChangeDescriptorType().compareTo(right.getChangeDescriptorType());
        }
        return left.getKey().compareTo(right.getKey());
    }
}

