/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.change.description;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.atlas.geography.atlas.change.ChangeType;
import org.openstreetmap.atlas.geography.atlas.change.description.ChangeDescriptorGenerator;
import org.openstreetmap.atlas.geography.atlas.change.description.ChangeDescriptorType;
import org.openstreetmap.atlas.geography.atlas.change.description.descriptors.ChangeDescriptor;
import org.openstreetmap.atlas.geography.atlas.change.description.descriptors.ChangeDescriptorComparator;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;

public class ChangeDescription {
    private static final ChangeDescriptorComparator COMPARATOR = new ChangeDescriptorComparator();
    private final long identifier;
    private final ItemType itemType;
    private final ChangeDescriptorType changeDescriptorType;
    private final List<ChangeDescriptor> descriptors;

    public ChangeDescription(long identifier, ItemType itemType, AtlasEntity beforeView, AtlasEntity afterView, ChangeType sourceFeatureChangeType) {
        this.identifier = identifier;
        this.itemType = itemType;
        this.descriptors = new ArrayList<ChangeDescriptor>();
        this.changeDescriptorType = sourceFeatureChangeType == ChangeType.ADD ? (beforeView != null ? ChangeDescriptorType.UPDATE : ChangeDescriptorType.ADD) : ChangeDescriptorType.REMOVE;
        this.descriptors.addAll(new ChangeDescriptorGenerator(beforeView, afterView, this.changeDescriptorType).generate());
    }

    public ChangeDescriptorType getChangeDescriptorType() {
        return this.changeDescriptorType;
    }

    public List<ChangeDescriptor> getChangeDescriptors() {
        return new ArrayList<ChangeDescriptor>(this.descriptors);
    }

    public long getIdentifier() {
        return this.identifier;
    }

    public ItemType getItemType() {
        return this.itemType;
    }

    public JsonElement toJsonElement() {
        JsonObject description = new JsonObject();
        description.addProperty("type", this.changeDescriptorType.toString());
        JsonArray descriptorArray = new JsonArray();
        for (ChangeDescriptor descriptor : this.descriptors) {
            descriptorArray.add(descriptor.toJsonElement());
        }
        description.add("descriptors", descriptorArray);
        return description;
    }

    public String toString() {
        this.descriptors.sort(COMPARATOR);
        StringBuilder builder = new StringBuilder();
        builder.append("ChangeDescription [");
        builder.append("\n");
        builder.append((Object)this.changeDescriptorType);
        builder.append(" ");
        builder.append((Object)this.itemType);
        builder.append(" ");
        builder.append(this.getIdentifier());
        builder.append("\n");
        if (this.descriptors.isEmpty()) {
            builder.append("]");
            return builder.toString();
        }
        for (int i = 0; i < this.descriptors.size() - 1; ++i) {
            builder.append(this.descriptors.get(i).toString());
            builder.append("\n");
        }
        builder.append(this.descriptors.get(this.descriptors.size() - 1).toString());
        builder.append("\n");
        builder.append("]");
        return builder.toString();
    }
}

