/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.change;

import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.exception.change.FeatureChangeMergeException;
import org.openstreetmap.atlas.exception.change.MergeFailureType;
import org.openstreetmap.atlas.geography.atlas.change.MemberMergeStrategies;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteNode;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.utilities.function.QuaternaryOperator;
import org.openstreetmap.atlas.utilities.function.TernaryOperator;

public final class MemberMerger<M> {
    private String memberName;
    private AtlasEntity beforeEntityLeft;
    private AtlasEntity afterEntityLeft;
    private AtlasEntity beforeEntityRight;
    private AtlasEntity afterEntityRight;
    private Function<AtlasEntity, M> memberExtractor;
    private BinaryOperator<M> afterViewNoBeforeViewMerger;
    private TernaryOperator<M> afterViewConsistentBeforeViewMerger;
    private QuaternaryOperator<M> afterViewConflictingBeforeViewMerger;
    private BinaryOperator<M> beforeViewMerger;
    private boolean useHackForMergingConflictingConnectedEdgeSetBeforeViews;
    private Optional<CompleteNode> leftNode;
    private Optional<CompleteNode> rightNode;

    private MemberMerger() {
    }

    public MergedMemberBean<M> mergeMember() {
        Object afterMemberRight;
        Object beforeMemberLeft = this.beforeEntityLeft == null ? null : (Object)this.memberExtractor.apply(this.beforeEntityLeft);
        Object afterMemberLeft = this.afterEntityLeft == null ? null : (Object)this.memberExtractor.apply(this.afterEntityLeft);
        M beforeMemberRight = this.beforeEntityRight == null ? null : (M)this.memberExtractor.apply(this.beforeEntityRight);
        Object m3 = afterMemberRight = this.afterEntityRight == null ? null : (Object)this.memberExtractor.apply(this.afterEntityRight);
        if (beforeMemberLeft != null && beforeMemberRight != null && !beforeMemberLeft.equals(beforeMemberRight)) {
            if (this.useHackForMergingConflictingConnectedEdgeSetBeforeViews) {
                return this.mergeMemberHackForConflictingConnectedEdgeSetBeforeViews(beforeMemberLeft, afterMemberLeft, beforeMemberRight, afterMemberRight);
            }
            return this.mergeMemberWithConflictingBeforeViews(beforeMemberLeft, afterMemberLeft, beforeMemberRight, afterMemberRight);
        }
        Object beforeMemberResult = this.chooseNonNullMemberIfPossible(beforeMemberLeft, beforeMemberRight);
        if (afterMemberLeft != null && afterMemberRight != null) {
            return this.mergeMembersWithConsistentBeforeViews(beforeMemberResult, afterMemberLeft, afterMemberRight);
        }
        Object afterMemberResult = afterMemberLeft != null ? afterMemberLeft : (afterMemberRight != null ? afterMemberRight : null);
        return new MergedMemberBean<Object>(beforeMemberResult, afterMemberResult);
    }

    private M chooseNonNullMemberIfPossible(M memberLeft, M memberRight) {
        if (memberLeft != null && memberRight != null) {
            return memberLeft;
        }
        if (memberLeft != null) {
            return memberLeft;
        }
        if (memberRight != null) {
            return memberRight;
        }
        return null;
    }

    private MergedMemberBean<M> mergeMemberHackForConflictingConnectedEdgeSetBeforeViews(M beforeMemberLeft, M afterMemberLeft, M beforeMemberRight, M afterMemberRight) {
        SortedSet<Long> afterMemberResult;
        Object beforeMemberResult;
        Set<Long> explicitlyExcludedRight;
        Set<Long> explicitlyExcludedLeft;
        if (!this.leftNode.isPresent()) {
            throw new CoreException("Attempted merge failed for {}: tried to use hackForConflictingConnectedEdgeSet but was missing leftNode", this.memberName);
        }
        if (!this.rightNode.isPresent()) {
            throw new CoreException("Attempted merge failed for {}: tried to use hackForConflictingConnectedEdgeSet but was missing rightNode", this.memberName);
        }
        if ("inEdgeIdentifiers".equals(this.memberName)) {
            explicitlyExcludedLeft = this.leftNode.get().explicitlyExcludedInEdgeIdentifiers();
            explicitlyExcludedRight = this.rightNode.get().explicitlyExcludedInEdgeIdentifiers();
        } else if ("outEdgeIdentifiers".equals(this.memberName)) {
            explicitlyExcludedLeft = this.leftNode.get().explicitlyExcludedOutEdgeIdentifiers();
            explicitlyExcludedRight = this.rightNode.get().explicitlyExcludedOutEdgeIdentifiers();
        } else {
            throw new CoreException("Attempted merge failed for {}: hackForConflictingConnectedEdgeSet is not a valid strategy for {}", this.memberName, this.memberName);
        }
        if (this.beforeViewMerger == null) {
            throw new FeatureChangeMergeException(MergeFailureType.MISSING_BEFORE_VIEW_MERGE_STRATEGY, "Conflicting beforeMembers {} and no beforeView merge strategy was provided; beforeView:\n{}\nvs\n{}", this.memberName, beforeMemberLeft, beforeMemberRight);
        }
        try {
            beforeMemberResult = this.beforeViewMerger.apply(beforeMemberLeft, beforeMemberRight);
        }
        catch (FeatureChangeMergeException exception) {
            throw new FeatureChangeMergeException(exception.withNewTopLevelFailure(MergeFailureType.BEFORE_VIEW_MERGE_STRATEGY_FAILED), "Attempted beforeView merge strategy failed for {} with beforeView:\n{}\nvs\n{}", this.memberName, beforeMemberLeft, beforeMemberRight, exception);
        }
        catch (Exception exception) {
            throw new FeatureChangeMergeException(MergeFailureType.BEFORE_VIEW_MERGE_STRATEGY_FAILED, "Attempted beforeView merge strategy failed for {} with beforeView:\n{}\nvs\n{}", this.memberName, beforeMemberLeft, beforeMemberRight, exception);
        }
        try {
            SortedSet<Long> mergeResult;
            afterMemberResult = mergeResult = MemberMergeStrategies.conflictingBeforeViewSetMerger.apply((SortedSet)beforeMemberLeft, (SortedSet)afterMemberLeft, explicitlyExcludedLeft, (SortedSet)beforeMemberRight, (SortedSet)afterMemberRight, explicitlyExcludedRight);
        }
        catch (FeatureChangeMergeException exception) {
            throw new FeatureChangeMergeException(exception.withNewTopLevelFailure(MergeFailureType.AFTER_VIEW_CONFLICTING_BEFORE_VIEW_MERGE_STRATEGY_FAILED), "Tried merge strategy for hackForConflictingConnectedEdgeSet, but it failed for {}\nbeforeView:\n{}\nvs\n{}\nafterView:\n{}\nvs\n{}", this.memberName, beforeMemberLeft, beforeMemberRight, afterMemberLeft, afterMemberRight, exception);
        }
        catch (Exception exception) {
            throw new FeatureChangeMergeException(MergeFailureType.AFTER_VIEW_CONFLICTING_BEFORE_VIEW_MERGE_STRATEGY_FAILED, "Tried merge strategy for hackForConflictingConnectedEdgeSet, but it failed for {}\nbeforeView:\n{}\nvs\n{}\nafterView:\n{}\nvs\n{}", this.memberName, beforeMemberLeft, beforeMemberRight, afterMemberLeft, afterMemberRight, exception);
        }
        return new MergedMemberBean<SortedSet<Long>>((SortedSet<Long>)beforeMemberResult, afterMemberResult);
    }

    private MergedMemberBean<M> mergeMemberWithConflictingBeforeViews(M beforeMemberLeft, M afterMemberLeft, M beforeMemberRight, M afterMemberRight) {
        Object afterMemberResult;
        Object beforeMemberResult;
        if (this.afterViewConflictingBeforeViewMerger == null) {
            throw new FeatureChangeMergeException(MergeFailureType.MISSING_AFTER_VIEW_MERGE_STRATEGY_WITH_BEFORE_MEMBER_CONFLICT_HANDLING, "Conflicting beforeMembers {} and no afterView merge strategy capable of handling conflicting beforeViews was provided; beforeView:\n{}\nvs\n{}", this.memberName, beforeMemberLeft, beforeMemberRight);
        }
        if (this.beforeViewMerger == null) {
            throw new FeatureChangeMergeException(MergeFailureType.MISSING_BEFORE_VIEW_MERGE_STRATEGY, "Conflicting beforeMembers {} and no beforeView merge strategy was provided; beforeView:\n{}\nvs\n{}", this.memberName, beforeMemberLeft, beforeMemberRight);
        }
        try {
            beforeMemberResult = this.beforeViewMerger.apply(beforeMemberLeft, beforeMemberRight);
        }
        catch (FeatureChangeMergeException exception) {
            throw new FeatureChangeMergeException(exception.withNewTopLevelFailure(MergeFailureType.BEFORE_VIEW_MERGE_STRATEGY_FAILED), "Attempted beforeView merge strategy failed for {} with beforeView:\n{}\nvs\n{}", this.memberName, beforeMemberLeft, beforeMemberRight, exception);
        }
        catch (Exception exception) {
            throw new FeatureChangeMergeException(MergeFailureType.BEFORE_VIEW_MERGE_STRATEGY_FAILED, "Attempted beforeView merge strategy failed for {} with beforeView:\n{}\nvs\n{}", this.memberName, beforeMemberLeft, beforeMemberRight, exception);
        }
        try {
            afterMemberResult = this.afterViewConflictingBeforeViewMerger.apply(beforeMemberLeft, afterMemberLeft, beforeMemberRight, afterMemberRight);
        }
        catch (FeatureChangeMergeException exception) {
            throw new FeatureChangeMergeException(exception.withNewTopLevelFailure(MergeFailureType.AFTER_VIEW_CONFLICTING_BEFORE_VIEW_MERGE_STRATEGY_FAILED), "Tried merge strategy for handling conflicting beforeViews. but it failed for {}\nbeforeView:\n{}\nvs\n{}\nafterView:\n{}\nvs\n{}", this.memberName, beforeMemberLeft, beforeMemberRight, afterMemberLeft, afterMemberRight, exception);
        }
        catch (Exception exception) {
            throw new FeatureChangeMergeException(MergeFailureType.AFTER_VIEW_CONFLICTING_BEFORE_VIEW_MERGE_STRATEGY_FAILED, "Tried merge strategy for handling conflicting beforeViews. but it failed for {}\nbeforeView:\n{}\nvs\n{}\nafterView:\n{}\nvs\n{}", this.memberName, beforeMemberLeft, beforeMemberRight, afterMemberLeft, afterMemberRight, exception);
        }
        return new MergedMemberBean(beforeMemberResult, afterMemberResult);
    }

    private MergedMemberBean<M> mergeMembersWithConsistentBeforeViews(M beforeMemberResult, M afterMemberLeft, M afterMemberRight) {
        Object afterMemberResult;
        if (afterMemberLeft.equals(afterMemberRight)) {
            return new MergedMemberBean<M>(beforeMemberResult, afterMemberLeft);
        }
        if (beforeMemberResult != null && this.afterViewConsistentBeforeViewMerger != null) {
            try {
                afterMemberResult = this.afterViewConsistentBeforeViewMerger.apply(beforeMemberResult, afterMemberLeft, afterMemberRight);
            }
            catch (FeatureChangeMergeException exception) {
                throw new FeatureChangeMergeException(exception.withNewTopLevelFailure(MergeFailureType.AFTER_VIEW_CONSISTENT_BEFORE_VIEW_MERGE_STRATEGY_FAILED), "Attempted afterViewConsistentBeforeMerge failed for {} with beforeView:\n{}\nafterView:\n{}\nvs\n{}", this.memberName, beforeMemberResult, afterMemberLeft, afterMemberRight, exception);
            }
            catch (Exception exception) {
                throw new FeatureChangeMergeException(MergeFailureType.AFTER_VIEW_CONSISTENT_BEFORE_VIEW_MERGE_STRATEGY_FAILED, "Attempted afterViewConsistentBeforeMerge failed for {} with beforeView:\n{}\nafterView:\n{}\nvs\n{}", this.memberName, beforeMemberResult, afterMemberLeft, afterMemberRight, exception);
            }
        } else if (this.afterViewNoBeforeViewMerger != null) {
            try {
                afterMemberResult = this.afterViewNoBeforeViewMerger.apply(afterMemberLeft, afterMemberRight);
            }
            catch (FeatureChangeMergeException exception) {
                throw new FeatureChangeMergeException(exception.withNewTopLevelFailure(MergeFailureType.AFTER_VIEW_NO_BEFORE_VIEW_MERGE_STRATEGY_FAILED), "Attempted afterViewNoBeforeMerge failed for {}; afterView:\n{}\nvs\n{}", this.memberName, afterMemberLeft, afterMemberRight, exception);
            }
            catch (Exception exception) {
                throw new FeatureChangeMergeException(MergeFailureType.AFTER_VIEW_NO_BEFORE_VIEW_MERGE_STRATEGY_FAILED, "Attempted afterViewNoBeforeMerge failed for {}; afterView:\n{}\nvs\n{}", this.memberName, afterMemberLeft, afterMemberRight, exception);
            }
        } else {
            throw new FeatureChangeMergeException(MergeFailureType.MISSING_AFTER_VIEW_MERGE_STRATEGY, "Conflicting members and no merge strategy for {}; afterView:\n{}\nvs\n{}", this.memberName, afterMemberLeft, afterMemberRight);
        }
        return new MergedMemberBean<M>(beforeMemberResult, afterMemberResult);
    }

    public static class MergedMemberBean<M> {
        private final M beforeMemberMerged;
        private final M afterMemberMerged;

        public MergedMemberBean(M before, M after) {
            this.beforeMemberMerged = before;
            this.afterMemberMerged = after;
        }

        public M getMergedAfterMember() {
            return this.afterMemberMerged;
        }

        public M getMergedBeforeMember() {
            return this.beforeMemberMerged;
        }
    }

    public static class Builder<M> {
        private String memberName;
        private AtlasEntity beforeEntityLeft;
        private AtlasEntity afterEntityLeft;
        private AtlasEntity beforeEntityRight;
        private AtlasEntity afterEntityRight;
        private Function<AtlasEntity, M> memberExtractor;
        private BinaryOperator<M> afterViewNoBeforeViewMerger;
        private TernaryOperator<M> afterViewConsistentBeforeViewMerger;
        private QuaternaryOperator<M> afterViewConflictingBeforeViewMerger;
        private BinaryOperator<M> beforeViewMerger;
        private boolean useHackForMergingConflictingConnectedEdgeSetBeforeViews = false;
        private Optional<CompleteNode> leftNode;
        private Optional<CompleteNode> rightNode;

        public MemberMerger<M> build() {
            this.assertRequiredFieldsNonNull();
            MemberMerger merger = new MemberMerger();
            merger.memberName = this.memberName;
            merger.beforeEntityLeft = this.beforeEntityLeft;
            merger.afterEntityLeft = this.afterEntityLeft;
            merger.beforeEntityRight = this.beforeEntityRight;
            merger.afterEntityRight = this.afterEntityRight;
            merger.memberExtractor = this.memberExtractor;
            merger.afterViewNoBeforeViewMerger = this.afterViewNoBeforeViewMerger;
            merger.afterViewConsistentBeforeViewMerger = this.afterViewConsistentBeforeViewMerger;
            merger.afterViewConflictingBeforeViewMerger = this.afterViewConflictingBeforeViewMerger;
            merger.beforeViewMerger = this.beforeViewMerger;
            merger.useHackForMergingConflictingConnectedEdgeSetBeforeViews = this.useHackForMergingConflictingConnectedEdgeSetBeforeViews;
            merger.leftNode = this.leftNode;
            merger.rightNode = this.rightNode;
            return merger;
        }

        public Builder<M> useHackForMergingConflictingConnectedEdgeSetBeforeViews(CompleteNode left, CompleteNode right) {
            this.useHackForMergingConflictingConnectedEdgeSetBeforeViews = true;
            this.leftNode = Optional.ofNullable(left);
            this.rightNode = Optional.ofNullable(right);
            return this;
        }

        public Builder<M> withAfterEntityLeft(AtlasEntity afterEntityLeft) {
            this.afterEntityLeft = afterEntityLeft;
            return this;
        }

        public Builder<M> withAfterEntityRight(AtlasEntity afterEntityRight) {
            this.afterEntityRight = afterEntityRight;
            return this;
        }

        public Builder<M> withAfterViewConflictingBeforeViewMerger(QuaternaryOperator<M> afterViewConflictingBeforeViewMerger) {
            this.afterViewConflictingBeforeViewMerger = afterViewConflictingBeforeViewMerger;
            return this;
        }

        public Builder<M> withAfterViewConsistentBeforeViewMerger(TernaryOperator<M> afterViewConsistentBeforeViewMerger) {
            this.afterViewConsistentBeforeViewMerger = afterViewConsistentBeforeViewMerger;
            return this;
        }

        public Builder<M> withAfterViewNoBeforeMerger(BinaryOperator<M> afterViewNoBeforeMerger) {
            this.afterViewNoBeforeViewMerger = afterViewNoBeforeMerger;
            return this;
        }

        public Builder<M> withBeforeEntityLeft(AtlasEntity beforeEntityLeft) {
            this.beforeEntityLeft = beforeEntityLeft;
            return this;
        }

        public Builder<M> withBeforeEntityRight(AtlasEntity beforeEntityRight) {
            this.beforeEntityRight = beforeEntityRight;
            return this;
        }

        public Builder<M> withBeforeViewMerger(BinaryOperator<M> beforeViewMerger) {
            this.beforeViewMerger = beforeViewMerger;
            return this;
        }

        public Builder<M> withMemberExtractor(Function<AtlasEntity, M> memberExtractor) {
            this.memberExtractor = memberExtractor;
            return this;
        }

        public Builder<M> withMemberName(String memberName) {
            this.memberName = memberName;
            return this;
        }

        private void assertRequiredFieldsNonNull() {
            if (this.memberName == null) {
                throw new CoreException("Required field 'memberName' was unset");
            }
            if (this.afterEntityLeft == null) {
                throw new CoreException("Required field 'afterEntityLeft' was unset");
            }
            if (this.afterEntityRight == null) {
                throw new CoreException("Required field 'afterEntityRight' was unset");
            }
            if (this.beforeEntityLeft != null && this.beforeEntityRight == null || this.beforeEntityLeft == null && this.beforeEntityRight != null) {
                throw new CoreException("Both 'beforeEntity' fields must either be set or null");
            }
            if (this.memberExtractor == null) {
                throw new CoreException("Required field 'memberExtractor' was unset");
            }
        }
    }
}

