/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.change;

import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.atlas.change.ChangeAtlas;
import org.openstreetmap.atlas.geography.atlas.change.ChangeEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.LocationItem;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.tags.Taggable;

public class ChangePoint
extends Point {
    private static final long serialVersionUID = 4353679260691518275L;
    private final Point source;
    private final Point override;
    private transient Set<Relation> relationsCache;
    private transient Object relationsCacheLock = new Object();

    protected ChangePoint(ChangeAtlas atlas, Point source, Point override) {
        super(atlas);
        this.source = source;
        this.override = override;
    }

    @Override
    public long getIdentifier() {
        return this.attribute(AtlasObject::getIdentifier, "identifier");
    }

    @Override
    public Location getLocation() {
        return this.attribute(LocationItem::getLocation, "location");
    }

    @Override
    public Map<String, String> getTags() {
        return this.attribute(Taggable::getTags, "tags");
    }

    @Override
    public Set<Relation> relations() {
        Supplier<Set> creator = () -> ChangeEntity.filterRelations(this.attribute(AtlasEntity::relations, "relations"), this.getChangeAtlas());
        return ChangeEntity.getOrCreateCache(this.relationsCache, cache -> {
            this.relationsCache = cache;
        }, this.relationsCacheLock, creator);
    }

    private <T> T attribute(Function<Point, T> memberExtractor, String name) {
        return ChangeEntity.getAttributeOrBackup(this.source, this.override, memberExtractor, name);
    }

    private ChangeAtlas getChangeAtlas() {
        return (ChangeAtlas)this.getAtlas();
    }
}

