/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.change;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.atlas.geography.Located;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.change.AtlasEntityKey;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChangeMergeGroup;
import org.openstreetmap.atlas.geography.atlas.change.description.ChangeDescriptorType;
import org.openstreetmap.atlas.geography.atlas.change.description.descriptors.ChangeDescriptorName;
import org.openstreetmap.atlas.geography.atlas.change.description.descriptors.TagChangeDescriptor;
import org.openstreetmap.atlas.geography.atlas.change.serializer.ChangeGeoJsonSerializer;
import org.openstreetmap.atlas.geography.atlas.change.serializer.FeatureChangeGeoJsonSerializer;
import org.openstreetmap.atlas.geography.atlas.complete.PrettifyStringFormat;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.tuples.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Change
implements Located,
Serializable {
    private static final long serialVersionUID = 1048481626851547987L;
    private static final Logger logger = LoggerFactory.getLogger(Change.class);
    private static final AtomicInteger CHANGE_IDENTIFIER_FACTORY = new AtomicInteger();
    private final List<FeatureChange> featureChanges = new ArrayList<FeatureChange>();
    private final Map<AtlasEntityKey, Integer> identifierToIndex = new HashMap<AtlasEntityKey, Integer>();
    private final int identifier = CHANGE_IDENTIFIER_FACTORY.getAndIncrement();
    private Rectangle bounds;
    private String name;

    public static Change merge(Change ... changeInstances) {
        FeatureChange[] mergedFeatureChanges = (FeatureChange[])Arrays.stream(changeInstances).flatMap(Change::changes).collect(Collectors.groupingBy(FeatureChangeMergeGroup::from, LinkedHashMap::new, Collectors.reducing(FeatureChange::merge))).values().stream().map(Optional::get).toArray(FeatureChange[]::new);
        return Change.newInstance().withName("Merged Change").addAll(mergedFeatureChanges);
    }

    public static Change newInstance() {
        return new Change();
    }

    protected Change() {
    }

    public Map<AtlasEntityKey, FeatureChange> allChangesMappedByAtlasEntityKey() {
        return this.changes().map(featureChange -> Tuple.createTuple(AtlasEntityKey.from(featureChange), featureChange)).collect(Collectors.toMap(Tuple::getFirst, Tuple::getSecond));
    }

    @Override
    public Rectangle bounds() {
        return this.bounds;
    }

    public int changeCount() {
        return this.featureChanges.size();
    }

    public Optional<FeatureChange> changeFor(ItemType itemType, Long identifier) {
        AtlasEntityKey key = AtlasEntityKey.from(itemType, identifier);
        if (!this.identifierToIndex.containsKey(key)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.featureChanges.get(this.identifierToIndex.get(key)));
    }

    public Stream<FeatureChange> changes() {
        return this.featureChanges.stream();
    }

    public Stream<FeatureChange> changesFor(ItemType itemType) {
        return this.identifierToIndex.keySet().stream().filter(tuple -> tuple.getFirst() == itemType).map(tuple -> this.featureChanges.get(this.identifierToIndex.get(tuple)));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        Change that = (Change)other;
        return Objects.equals(this.featureChanges, that.featureChanges);
    }

    public List<FeatureChange> getFeatureChanges() {
        return this.featureChanges;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return Optional.ofNullable(this.name).orElse(String.valueOf(this.getIdentifier()));
    }

    public int hashCode() {
        return Objects.hashCode(this.featureChanges);
    }

    public String prettify(PrettifyStringFormat featureChangeFormat, PrettifyStringFormat completeEntityFormat) {
        return this.prettify(featureChangeFormat, completeEntityFormat, true);
    }

    public String prettify(PrettifyStringFormat featureChangeFormat, PrettifyStringFormat completeEntityFormat, boolean truncate) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName() + " [");
        builder.append("\n");
        for (FeatureChange featureChange : this.featureChanges) {
            builder.append(featureChange.prettify(featureChangeFormat, completeEntityFormat, truncate));
            builder.append("\n");
        }
        builder.append("]");
        return builder.toString();
    }

    public void save(WritableResource resource) {
        new ChangeGeoJsonSerializer().accept(this, resource);
    }

    public void save(WritableResource resource, boolean showDescription) {
        new ChangeGeoJsonSerializer(true, showDescription).accept(this, resource);
    }

    public String summaryString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName() + " [");
        builder.append("\n");
        for (ItemType itemType : ItemType.values()) {
            for (ChangeDescriptorType changeType : ChangeDescriptorType.values()) {
                builder.append((Object)itemType);
                builder.append(" had ");
                builder.append(this.changeCountFor(itemType, changeType));
                builder.append(" ");
                builder.append((Object)changeType);
                builder.append(" changes\n");
            }
        }
        builder.append("]");
        return builder.toString();
    }

    public Map<ItemType, Map<ChangeDescriptorType, Map<String, AtomicLong>>> tagCountMap() {
        EnumMap<ItemType, Map<ChangeDescriptorType, Map<String, AtomicLong>>> tagMap = new EnumMap<ItemType, Map<ChangeDescriptorType, Map<String, AtomicLong>>>(ItemType.class);
        for (ItemType itemType : ItemType.values()) {
            EnumMap descriptorMap = new EnumMap(ChangeDescriptorType.class);
            for (ChangeDescriptorType type : ChangeDescriptorType.values()) {
                descriptorMap.put(type, new HashMap());
            }
            tagMap.put(itemType, descriptorMap);
            this.featureChanges.stream().filter(change -> change.getItemType().equals((Object)itemType) && change.explain().getChangeDescriptorType().equals((Object)ChangeDescriptorType.UPDATE) && change.explain().getChangeDescriptors().stream().anyMatch(descriptor -> descriptor.getName().equals((Object)ChangeDescriptorName.TAG))).forEach(change -> change.explain().getChangeDescriptors().stream().filter(changeDescriptor -> changeDescriptor.getName().equals((Object)ChangeDescriptorName.TAG)).forEach(changeDescriptor -> {
                TagChangeDescriptor tagChangeDescriptor = (TagChangeDescriptor)changeDescriptor;
                if (((Map)((Map)tagMap.get((Object)itemType)).get((Object)tagChangeDescriptor.getChangeDescriptorType())).containsKey(tagChangeDescriptor.getKey())) {
                    ((AtomicLong)((Map)((Map)tagMap.get((Object)itemType)).get((Object)tagChangeDescriptor.getChangeDescriptorType())).get(tagChangeDescriptor.getKey())).incrementAndGet();
                } else {
                    ((Map)((Map)tagMap.get((Object)itemType)).get((Object)tagChangeDescriptor.getChangeDescriptorType())).put(tagChangeDescriptor.getKey(), new AtomicLong(1L));
                }
            }));
        }
        return tagMap;
    }

    public String toJson() {
        return new ChangeGeoJsonSerializer().convert(this);
    }

    public String toJson(boolean showDescription) {
        return new ChangeGeoJsonSerializer(true, showDescription).convert(this);
    }

    public String toLineDelimitedFeatureChanges() {
        StringBuilder builder = new StringBuilder();
        FeatureChangeGeoJsonSerializer serializer = new FeatureChangeGeoJsonSerializer(false);
        for (FeatureChange featureChange : this.featureChanges) {
            builder.append((String)serializer.apply(featureChange) + "\n");
        }
        return builder.toString();
    }

    public String toString() {
        StringList split = new StringList();
        StringBuilder builder = new StringBuilder();
        for (int index = 0; index < this.featureChanges.size(); ++index) {
            split.add(index + " - " + this.featureChanges.get(index));
        }
        builder.append("[Change:");
        builder.append(System.lineSeparator());
        builder.append(split.join(System.lineSeparator()));
        builder.append(System.lineSeparator());
        builder.append("]");
        return builder.toString();
    }

    public Change withName(String name) {
        this.name = name;
        return this;
    }

    protected Change add(FeatureChange featureChange) {
        int currentIndex = this.featureChanges.size();
        AtlasEntityKey key = AtlasEntityKey.from(featureChange.getItemType(), featureChange.getIdentifier());
        FeatureChange chosen = featureChange;
        if (!this.identifierToIndex.containsKey(key)) {
            this.identifierToIndex.put(key, currentIndex);
            this.featureChanges.add(featureChange);
        } else {
            int existingIndex = this.identifierToIndex.get(key);
            FeatureChange existing = this.featureChanges.get(existingIndex);
            logger.trace("Change already has a similar feature change. Triggered a merge attempt! Existing: {}; New: {}", (Object)existing, (Object)featureChange);
            chosen = existing.merge(featureChange);
            this.featureChanges.set(existingIndex, chosen);
        }
        Rectangle featureBounds = chosen.bounds();
        this.bounds = this.bounds != null ? (featureBounds != null ? this.bounds.combine(featureBounds) : this.bounds) : featureBounds;
        return this;
    }

    protected Change addAll(FeatureChange ... featureChanges) {
        Arrays.stream(featureChanges).forEach(this::add);
        return this;
    }

    private long changeCountFor(ItemType itemType, ChangeDescriptorType changeType) {
        return this.featureChanges.stream().filter(change -> change.getItemType().equals((Object)itemType) && change.explain().getChangeDescriptorType().equals((Object)changeType)).count();
    }
}

