/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.change;

import java.io.Serializable;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.change.Change;
import org.openstreetmap.atlas.geography.atlas.change.ChangeAtlas;
import org.openstreetmap.atlas.geography.atlas.change.ChangeBuilder;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChangeBoundsExpander;
import org.openstreetmap.atlas.utilities.conversion.Converter;

public interface AtlasChangeGenerator
extends Converter<Atlas, Set<FeatureChange>>,
Serializable {
    @Override
    default public Set<FeatureChange> convert(Atlas atlas) {
        return this.generate(atlas);
    }

    default public Set<FeatureChange> generate(Atlas atlas) {
        Set<FeatureChange> result = new FeatureChangeBoundsExpander(this.generateWithoutValidation(atlas), atlas).apply();
        result.stream().forEach(featureChange -> featureChange.withAtlasContext(atlas));
        if (result.isEmpty()) {
            return result;
        }
        ChangeBuilder builder = new ChangeBuilder();
        result.forEach(builder::add);
        Change change = builder.get();
        this.validate(atlas, change);
        return change.changes().collect(Collectors.toSet());
    }

    public Set<FeatureChange> generateWithoutValidation(Atlas var1);

    default public String getName() {
        return this.getClass().getSimpleName();
    }

    default public void validate(Atlas source, Change change) {
        new ChangeAtlas(source, change).validate();
    }
}

